/*
 * Decompiled with CFR 0.152.
 */
package org.molap.index;

import com.macrofocus.common.annotation.Synchronized;
import com.macrofocus.common.collection.ArrayFnKt;
import com.macrofocus.common.collection.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.index.AbstractUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/molap/index/IntegerListUniqueIndex;", "Lorg/molap/index/AbstractUniqueIndex;", "", "list", "", "<init>", "([I)V", "lazy", "Lorg/molap/index/IntegerListUniqueIndex$Lazy;", "contains", "", "key", "getAddress", "keys", "", "getKey", "i", "(I)Ljava/lang/Integer;", "size", "getSize", "()I", "head", "Lorg/molap/index/UniqueIndex;", "count", "tail", "keepAddresses", "addresses", "Lazy", "molap"})
public final class IntegerListUniqueIndex
extends AbstractUniqueIndex<Integer> {
    @NotNull
    private final int[] list;
    @NotNull
    private final Lazy lazy;

    public IntegerListUniqueIndex(@NotNull int[] list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.list = list;
        this.lazy = new Lazy();
    }

    public boolean contains(int key) {
        return this.lazy.getIndex().containsKey(key);
    }

    @Override
    public int getAddress(int key) {
        return ((Number)MapsKt.getValue(this.lazy.getIndex(), (Object)key)).intValue();
    }

    @Override
    @NotNull
    public Iterable<Integer> keys() {
        int[] nArray = this.list;
        return Iterables.INSTANCE.forIntArray(Arrays.copyOf(nArray, nArray.length));
    }

    @NotNull
    public Integer getKey(int i) {
        return this.list[i];
    }

    public int getSize() {
        return this.list.length;
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> head(int count) {
        return new IntegerListUniqueIndex(ArrayFnKt.copyOf((int[])this.list, (int)Math.min(this.list.length, count)));
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> tail(int count) {
        return new IntegerListUniqueIndex(ArrayFnKt.copyOfRange((int[])this.list, (int)(this.list.length - count), (int)this.list.length));
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> keepAddresses(@NotNull int[] addresses) {
        Intrinsics.checkNotNullParameter((Object)addresses, (String)"addresses");
        int[] keys2 = new int[addresses.length];
        int n = addresses.length;
        for (int i = 0; i < n; ++i) {
            keys2[i] = this.list[addresses[i]];
        }
        return new IntegerListUniqueIndex(addresses);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007H\u0007R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/molap/index/IntegerListUniqueIndex$Lazy;", "", "<init>", "(Lorg/molap/index/IntegerListUniqueIndex;)V", "index", "", "", "Lcom/macrofocus/common/collection/TIntIntMap;", "getIndex", "molap"})
    private final class Lazy {
        @Nullable
        private Map<Integer, Integer> index;

        @Synchronized
        @NotNull
        public final Map<Integer, Integer> getIndex() {
            if (this.index == null) {
                this.index = new HashMap(IntegerListUniqueIndex.this.list.length);
                int n = IntegerListUniqueIndex.this.list.length;
                for (int i = 0; i < n; ++i) {
                    int key = IntegerListUniqueIndex.this.list[i];
                    Map<Integer, Integer> map = this.index;
                    Intrinsics.checkNotNull(map);
                    map.put(key, i);
                }
            }
            Map<Integer, Integer> map = this.index;
            Intrinsics.checkNotNull(map);
            return map;
        }
    }
}

