/*
 * Decompiled with CFR 0.152.
 */
import com.treemap.AbstractTreeMapNode;
import com.treemap.Algorithm;
import com.treemap.AlgorithmFactory;
import com.treemap.DefaultTreeMap;
import com.treemap.Rendering;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.mkui.colormap.MutableColorMap;
import org.mkui.font.crossplatform.CPFont;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;
import org.mkui.swing.HierarchicalComboBox;
import org.mkui.swing.Orientation;
import org.mkui.swing.SingleSelectionComboBoxModel;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.JsonDataFrame;

public class Demo {
    public static void main(String[] args) throws IOException {
        InputStream inputStream = Demo.class.getResourceAsStream("Forbes Global 2000 - 2021.json");
        JsonDataFrame dataFrame = JsonDataFrame.fromInputStream((InputStream)inputStream);
        DefaultTreeMap treeMap = new DefaultTreeMap((DataFrame)dataFrame);
        TreeMapModel model = treeMap.getModel();
        TreeMapSettings settings = model.getSettings();
        settings.setRendering(RenderingFactory.getFLAT());
        settings.setGroupByColumns(Arrays.asList("Sector", "Industry"));
        settings.setSizeColumn((Object)"Market Value");
        settings.setColorColumn((Object)"Profits");
        TreeMapColumnSettings profitsSettings = settings.getColumnSettings((Object)"Profits");
        FixedPalette negpos = PaletteFactory.Companion.getInstance().get("negpos").getPalette();
        MutableColorMap colorMap = model.getColorMap((Object)"Profits");
        colorMap.setPalette((MutablePalette)negpos);
        colorMap.getInterval().setValue(-63.93, 127.86);
        treeMap.getView().setShowTiming(true);
        TreeMapColumnSettings companySettings = settings.getColumnSettings((Object)"Company");
        companySettings.setLabelingFont(new CPFont(new Font("Helvetica", 0, 9)).getNativeFont());
        companySettings.setLabelingMinimumCharactersToDisplay(Integer.valueOf(5));
        companySettings.setLabelingResizeTextToFitShape(true);
        companySettings.setLabelingVerticalAlignment(0);
        companySettings.setLabelingHorizontalAlignment(0);
        JPanel configuration = Demo.createConfiguration((TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings);
        JSplitPane splitPane = new JSplitPane(1, true, configuration, treeMap.getComponent().getNativeComponent());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)Demo.createGroupBy(Orientation.Horizontal, (TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings), "North");
        mainPanel.add(splitPane);
        JFrame frame = new JFrame("TreeMap");
        frame.getContentPane().add(mainPanel);
        frame.setSize(1024, 768);
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    @NotNull
    private static JPanel createConfiguration(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JPanel configuration = new JPanel();
        configuration.setLayout(new BoxLayout(configuration, 3));
        configuration.add((Component)Demo.createGroupBy(Orientation.Vertical, model, settings));
        configuration.add(Demo.createSizeComboBox(model, settings));
        configuration.add(Demo.createColorComboBox(model, settings));
        configuration.add(Demo.createAlgorithmComboBox(settings.getDefaultColumnSettings()));
        configuration.add(Demo.createRenderingComboBox(settings));
        configuration.add(Box.createGlue());
        return configuration;
    }

    @NotNull
    private static HierarchicalComboBox<String> createGroupBy(Orientation orientation, TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        HierarchicalComboBox<String> groupBy = new HierarchicalComboBox<String>(orientation, settings.getGroupByColumnsSelection(), model.getGroupByColumns()){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        groupBy.setBorder((Border)BorderFactory.createTitledBorder("Group by"));
        groupBy.setAlignmentX(0.0f);
        return groupBy;
    }

    private static JComboBox<String> createSizeComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JComboBox<String> sizeComboBox = new JComboBox<String>((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getSizeColumnSelection(), model.getSizeColumns())){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        sizeComboBox.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox.setAlignmentX(0.0f);
        return sizeComboBox;
    }

    private static JComboBox<String> createColorComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        JComboBox<String> sizeComboBox = new JComboBox<String>((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getColorColumnSelection(), model.getColorColumns())){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        sizeComboBox.setBorder(BorderFactory.createTitledBorder("Size"));
        sizeComboBox.setAlignmentX(0.0f);
        return sizeComboBox;
    }

    private static JComboBox<Algorithm> createAlgorithmComboBox(TreeMapColumnSettings settings) {
        JComboBox<Algorithm> algorithmComboBox = new JComboBox<Algorithm>((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getAlgorithmProperty(), (Iterable)AlgorithmFactory.Companion.getInstance().getAlgorithms())){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        algorithmComboBox.setBorder(BorderFactory.createTitledBorder("Algorithm"));
        algorithmComboBox.setAlignmentX(0.0f);
        return algorithmComboBox;
    }

    private static JComboBox<Rendering> createRenderingComboBox(TreeMapSettings<String> settings) {
        JComboBox<Rendering> renderingComboBox = new JComboBox<Rendering>((ComboBoxModel)new SingleSelectionComboBoxModel(settings.getRenderingSelection(), (Iterable)RenderingFactory.getInstance().getRenderings())){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        renderingComboBox.setBorder(BorderFactory.createTitledBorder("Rendering"));
        renderingComboBox.setAlignmentX(0.0f);
        return renderingComboBox;
    }
}

