/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableInterval;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/macrofocus/common/interval/AbstractMutableInterval;", "Lcom/macrofocus/common/interval/MutableInterval;", "<init>", "()V", "listeners", "", "Lcom/macrofocus/common/interval/IntervalListener;", "addIntervalListener", "", "listener", "addWeakIntervalListener", "removeIntervalListener", "removeIntervalListeners", "notifyIntervalChanged", "event", "Lcom/macrofocus/common/interval/IntervalEvent;", "WeakIntervalListener", "macrofocus-common"})
public abstract class AbstractMutableInterval
implements MutableInterval {
    @NotNull
    private final List<IntervalListener> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();

    @Override
    public void addIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        WeakIntervalListener weakListener = new WeakIntervalListener(listener2);
        this.listeners.add(weakListener);
    }

    @Override
    public void removeIntervalListener(@NotNull IntervalListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (listener2 instanceof WeakIntervalListener) {
            boolean bl = this.listeners.remove(listener2);
        } else {
            IntervalListener toRemove = null;
            for (IntervalListener intervalListener2 : this.listeners) {
                IntervalListener comparable = null;
                comparable = intervalListener2 instanceof WeakIntervalListener ? ((WeakIntervalListener)intervalListener2).getReference() : intervalListener2;
                if (!Intrinsics.areEqual((Object)listener2, (Object)comparable)) continue;
                toRemove = intervalListener2;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeIntervalListeners() {
        this.listeners.clear();
    }

    protected final void notifyIntervalChanged(@NotNull IntervalEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (IntervalListener listener2 : this.listeners) {
            listener2.intervalChanged(event);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/macrofocus/common/interval/AbstractMutableInterval$WeakIntervalListener;", "Lcom/macrofocus/common/interval/IntervalListener;", "listener", "<init>", "(Lcom/macrofocus/common/interval/AbstractMutableInterval;Lcom/macrofocus/common/interval/IntervalListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "intervalChanged", "", "event", "Lcom/macrofocus/common/interval/IntervalEvent;", "reference", "getReference", "()Lcom/macrofocus/common/interval/IntervalListener;", "toString", "", "macrofocus-common"})
    private final class WeakIntervalListener
    implements IntervalListener {
        @NotNull
        private final WeakReference<IntervalListener> l_ref;

        public WeakIntervalListener(IntervalListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.l_ref = new WeakReference<IntervalListener>(listener2);
        }

        @Override
        public void intervalChanged(@NotNull IntervalEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IntervalListener l = this.getReference();
            if (l != null) {
                l.intervalChanged(event);
            } else {
                AbstractMutableInterval.this.removeIntervalListener(this);
            }
        }

        @Nullable
        public final IntervalListener getReference() {
            return this.l_ref.get();
        }

        @NotNull
        public String toString() {
            IntervalListener l = this.getReference();
            return l != null ? "Weak[" + l + "]" : Reflection.getOrCreateKotlinClass(this.getClass()) + "@" + this.hashCode();
        }
    }
}

