/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.interval;

import com.macrofocus.common.interval.ClosedInterval;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R$\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00038V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/macrofocus/common/interval/PropertyClosedInterval;", "Lcom/macrofocus/common/interval/ClosedInterval;", "start", "", "extent", "<init>", "(DD)V", "startProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "getStartProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "endProperty", "getEndProperty", "value", "getStart", "()D", "setStart", "(D)V", "end", "getEnd", "setEnd", "getExtent", "setExtent", "setValue", "", "toString", "", "macrofocus-common"})
public class PropertyClosedInterval
extends ClosedInterval {
    @NotNull
    private final MutableProperty<Double> startProperty;
    @NotNull
    private final MutableProperty<Double> endProperty;

    public PropertyClosedInterval(final double start, final double extent) {
        this.startProperty = new SimpleProperty<Double>(start);
        this.endProperty = new SimpleProperty<Double>(((Number)this.getStartProperty().getValue()).doubleValue() + extent);
        this.getStartProperty().addPropertyListener(new PropertyListener<Double>(){

            @Override
            public void propertyChanged(PropertyEvent<Double> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                IntervalEvent e = new IntervalEvent(((Number)event.getOldValue()).doubleValue(), this.getEnd(), this.getEnd() - ((Number)event.getOldValue()).doubleValue());
                e.setNewValues(start, this.getEnd(), extent);
                this.notifyIntervalChanged(e);
            }
        });
        this.getEndProperty().addPropertyListener(new PropertyListener<Double>(){

            @Override
            public void propertyChanged(PropertyEvent<Double> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                IntervalEvent e = new IntervalEvent(start, ((Number)event.getOldValue()).doubleValue(), ((Number)event.getOldValue()).doubleValue() - start);
                e.setNewValues(start, this.getEnd(), extent);
                this.notifyIntervalChanged(e);
            }
        });
    }

    @Override
    @NotNull
    public MutableProperty<Double> getStartProperty() {
        return this.startProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Double> getEndProperty() {
        return this.endProperty;
    }

    @Override
    public double getStart() {
        return ((Number)this.getStartProperty().getValue()).doubleValue();
    }

    @Override
    public void setStart(double value) {
        this.getStartProperty().setValue(value);
    }

    @Override
    public double getEnd() {
        return ((Number)this.getEndProperty().getValue()).doubleValue();
    }

    @Override
    public void setEnd(double value) {
        this.getEndProperty().setValue(value);
    }

    @Override
    public double getExtent() {
        return super.getExtent();
    }

    @Override
    public void setExtent(double extent) {
        this.getEndProperty().setValue(this.getStart() + extent);
    }

    @Override
    public void setValue(double value, double extent) {
        this.getStartProperty().setValue(value);
        this.getEndProperty().setValue(value + extent);
    }

    @NotNull
    public String toString() {
        return "PropertyClosedInterval{start=" + this.getStart() + ", end=" + this.getEnd() + ", extent=" + this.getExtent() + "}";
    }
}

