/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.collection.EnumMap;
import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.AbstractProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002%&B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bBG\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012.\u0010\t\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\u0006\"\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0096\u0082\u0004J)\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019J/\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00028\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00152\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$R,\u0010\r\u001a \u0012\u0004\u0012\u00028\u0000\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000fR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/macrofocus/common/properties/EnumProperties;", "K", "", "Lcom/macrofocus/common/properties/AbstractProperties;", "Lcom/macrofocus/common/properties/MutableProperties;", "enums", "", "<init>", "([Ljava/lang/Enum;)V", "pairs", "Lkotlin/Pair;", "", "([Ljava/lang/Enum;[Lkotlin/Pair;)V", "propertyMap", "Lcom/macrofocus/common/collection/EnumMap;", "Lcom/macrofocus/common/properties/EnumProperties$ExposedProperty;", "listenerMap", "Lcom/macrofocus/common/properties/PropertyListener;", "iterator", "", "createProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "T", "name", "value", "(Ljava/lang/Enum;Ljava/lang/Object;)Lcom/macrofocus/common/properties/MutableProperty;", "addProperty", "property", "(Ljava/lang/Enum;Lcom/macrofocus/common/properties/MutableProperty;)Lcom/macrofocus/common/properties/MutableProperty;", "replaceProperty", "getValue", "(Ljava/lang/Enum;)Ljava/lang/Object;", "setValue", "", "(Ljava/lang/Enum;Ljava/lang/Object;)V", "getProperty", "(Ljava/lang/Enum;)Lcom/macrofocus/common/properties/MutableProperty;", "NamedPropertyListener", "ExposedProperty", "macrofocus-common"})
public class EnumProperties<K extends Enum<K>>
extends AbstractProperties<K>
implements MutableProperties<K> {
    @NotNull
    private final EnumMap<K, ExposedProperty<Object>> propertyMap;
    @NotNull
    private final EnumMap<K, PropertyListener<Object>> listenerMap;

    public EnumProperties(@NotNull K[] enums) {
        Intrinsics.checkNotNullParameter(enums, (String)"enums");
        this.propertyMap = new EnumMap(enums);
        this.listenerMap = new EnumMap(enums);
    }

    public EnumProperties(@NotNull K[] enums, Pair<? extends K, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(enums, (String)"enums");
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this((Enum[])enums);
        for (Pair<? extends K, ? extends Object> pair : pairs) {
            this.createProperty((K)((Enum)pair.getFirst()), (T)pair.getSecond());
        }
    }

    @Override
    @NotNull
    public Iterator<K> iterator() {
        return this.propertyMap.keySet().iterator();
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> createProperty(@NotNull K name, T value) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        MutableProperty property = SimpleProperty.Companion.newInstance(value);
        return this.addProperty(name, property);
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> addProperty(@NotNull K name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<T> exposedProperty = new ExposedProperty<T>(property);
        ((Map)this.propertyMap).put(name, exposedProperty);
        NamedPropertyListener listener2 = new NamedPropertyListener(this, name);
        exposedProperty.addPropertyListener(listener2);
        ((Map)this.listenerMap).put(name, listener2);
        return exposedProperty;
    }

    @Override
    @NotNull
    public <T> MutableProperty<T> replaceProperty(@NotNull K name, @NotNull MutableProperty<T> property) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get((Object)name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setSecretProperty(property);
        return property;
    }

    @Override
    @Nullable
    public Object getValue(@NotNull K name) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get((Object)name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty.getValue();
    }

    @Override
    public void setValue(@NotNull K name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get((Object)name);
        Intrinsics.checkNotNull(exposedProperty);
        exposedProperty.setValue(value);
    }

    @Override
    @NotNull
    public MutableProperty<Object> getProperty(@NotNull K name) {
        Intrinsics.checkNotNullParameter(name, (String)"name");
        ExposedProperty<Object> exposedProperty = this.propertyMap.get((Object)name);
        Intrinsics.checkNotNull(exposedProperty);
        return exposedProperty;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u00018V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/macrofocus/common/properties/EnumProperties$ExposedProperty;", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "Lcom/macrofocus/common/properties/MutableProperty;", "secret", "<init>", "(Lcom/macrofocus/common/properties/EnumProperties;Lcom/macrofocus/common/properties/MutableProperty;)V", "listener", "Lcom/macrofocus/common/properties/PropertyListener;", "getListener", "()Lcom/macrofocus/common/properties/PropertyListener;", "setListener", "(Lcom/macrofocus/common/properties/PropertyListener;)V", "setSecretProperty", "", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "macrofocus-common"})
    private final class ExposedProperty<T>
    extends AbstractMutableProperty<T>
    implements MutableProperty<T> {
        @NotNull
        private MutableProperty<T> secret;
        @NotNull
        private PropertyListener<T> listener;

        public ExposedProperty(MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            this.listener = new PropertyListener<T>(this){
                final /* synthetic */ ExposedProperty<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void propertyChanged(PropertyEvent<T> event) {
                    Intrinsics.checkNotNullParameter(event, (String)"event");
                    this.this$0.notifyPropertyChanged(event);
                }
            };
            this.secret = secret;
            this.secret.addPropertyListener(this.listener);
        }

        @NotNull
        public final PropertyListener<T> getListener() {
            return this.listener;
        }

        public final void setListener(@NotNull PropertyListener<T> propertyListener) {
            Intrinsics.checkNotNullParameter(propertyListener, (String)"<set-?>");
            this.listener = propertyListener;
        }

        public final void setSecretProperty(@NotNull MutableProperty<T> secret) {
            Intrinsics.checkNotNullParameter(secret, (String)"secret");
            if (this.secret != secret) {
                this.secret.removePropertyListener(this.listener);
                T oldValue = this.secret.getValue();
                T newValue = secret.getValue();
                this.secret = secret;
                this.secret.addPropertyListener(this.listener);
                System.out.println((Object)("setSecretProperty: " + oldValue + " -> " + newValue + ": " + !Intrinsics.areEqual(oldValue, newValue)));
                if (!Intrinsics.areEqual(oldValue, newValue)) {
                    this.notifyPropertyChanged(new PropertyEvent<T>(oldValue, newValue));
                }
            }
        }

        @Override
        public T getValue() {
            return this.secret.getValue();
        }

        @Override
        public void setValue(T value) {
            this.secret.setValue(value);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nH\u0016R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/macrofocus/common/properties/EnumProperties$NamedPropertyListener;", "Lcom/macrofocus/common/properties/PropertyListener;", "", "name", "<init>", "(Lcom/macrofocus/common/properties/EnumProperties;Ljava/lang/Enum;)V", "Ljava/lang/Enum;", "propertyChanged", "", "event", "Lcom/macrofocus/common/properties/PropertyEvent;", "macrofocus-common"})
    private static final class NamedPropertyListener
    implements PropertyListener<Object> {
        @NotNull
        private final K name;
        final /* synthetic */ EnumProperties<K> this$0;

        public NamedPropertyListener(K name) {
            Intrinsics.checkNotNullParameter(name, (String)"name");
            this.this$0 = this$0;
            this.name = name;
        }

        @Override
        public void propertyChanged(@NotNull PropertyEvent<Object> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            this.this$0.notifyPropertyChanged(this.name, event);
        }
    }
}

