/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.properties;

import com.macrofocus.common.properties.AbstractMutableProperty;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.TransformedProperty;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\b\t*\u0001\u0011\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R&\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0001@VX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/common/properties/TransformedProperty;", "O", "T", "Lcom/macrofocus/common/properties/AbstractMutableProperty;", "original", "Lcom/macrofocus/common/properties/MutableProperty;", "forward", "Lkotlin/Function1;", "backward", "<init>", "(Lcom/macrofocus/common/properties/MutableProperty;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getOriginal", "()Lcom/macrofocus/common/properties/MutableProperty;", "getForward", "()Lkotlin/jvm/functions/Function1;", "getBackward", "listener", "com/macrofocus/common/properties/TransformedProperty$listener$1", "Lcom/macrofocus/common/properties/TransformedProperty$listener$1;", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "macrofocus-common"})
public final class TransformedProperty<O, T>
extends AbstractMutableProperty<T> {
    @NotNull
    private final MutableProperty<O> original;
    @NotNull
    private final Function1<O, T> forward;
    @NotNull
    private final Function1<T, O> backward;
    @NotNull
    private final listener.1 listener;
    private T value;

    public TransformedProperty(@NotNull MutableProperty<O> original, @NotNull Function1<? super O, ? extends T> forward, @NotNull Function1<? super T, ? extends O> backward) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(forward, (String)"forward");
        Intrinsics.checkNotNullParameter(backward, (String)"backward");
        this.original = original;
        this.forward = forward;
        this.backward = backward;
        this.listener = new PropertyListener<O>(this){
            final /* synthetic */ TransformedProperty<O, T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(PropertyEvent<O> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                Object oldValue = this.this$0.getForward().invoke(event.getOldValue());
                Object newValue = this.this$0.getForward().invoke(event.getNewValue());
                System.out.println((Object)("TransformedProperty changed: " + oldValue + "," + newValue + " -> " + !Intrinsics.areEqual((Object)oldValue, (Object)newValue)));
                if (!Intrinsics.areEqual((Object)oldValue, (Object)newValue)) {
                    this.this$0.setValue(newValue);
                    this.this$0.notifyPropertyChanged(new PropertyEvent<Object>(oldValue, newValue));
                }
            }
        };
        this.original.addWeakPropertyListener(this.listener);
        this.value = this.forward.invoke(this.original.getValue());
    }

    @NotNull
    public final MutableProperty<O> getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function1<O, T> getForward() {
        return this.forward;
    }

    @NotNull
    public final Function1<T, O> getBackward() {
        return this.backward;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        System.out.println((Object)("TransformedProperty set: " + value + "," + this.value + " -> " + !Intrinsics.areEqual(value, this.value)));
        if (!Intrinsics.areEqual(value, this.value)) {
            this.value = value;
            Object newValue = this.backward.invoke(value);
            System.out.println((Object)("TransformedProperty apply: " + this.original.getValue() + "," + newValue + " -> " + !Intrinsics.areEqual(this.original.getValue(), (Object)newValue)));
            if (!Intrinsics.areEqual(this.original.getValue(), (Object)newValue)) {
                this.original.setValue(newValue);
            }
        }
    }
}

