/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.selection;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.selection.AbstractMutableSelection;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SimpleSelectionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001d\b\u0016\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007\"\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J)\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\u00122\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001d\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0096\u0082\u0004J\n\u0010(\u001a\u00020)H\u0096\u0080\u0004R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/macrofocus/common/selection/SimpleSelection;", "E", "Lcom/macrofocus/common/selection/AbstractMutableSelection;", "Lcom/macrofocus/common/selection/MutableSelection;", "<init>", "()V", "selected", "", "([Ljava/lang/Object;)V", "", "clearSelection", "", "isActive", "()Z", "isSelected", "element", "(Ljava/lang/Object;)Z", "setSelectedElement", "", "e", "(Ljava/lang/Object;)V", "setSelectedState", "(Ljava/lang/Object;Z)V", "setSelectedIterableState", "elements", "", "setSelectedElementsState", "(Z[Ljava/lang/Object;)Z", "setSelectedElements", "setSelectedIterable", "selectedCount", "", "getSelectedCount", "()I", "selectedSet", "", "getSelectedSet", "()Ljava/util/Set;", "iterator", "", "toString", "", "macrofocus-common"})
public final class SimpleSelection<E>
extends AbstractMutableSelection<E>
implements MutableSelection<E> {
    @NotNull
    private final Set<E> selected;

    public SimpleSelection() {
        this.selected = CollectionFactory.INSTANCE.concurrentLinkedHashSet();
    }

    public SimpleSelection(E ... selected2) {
        Intrinsics.checkNotNullParameter(selected2, (String)"selected");
        this();
        CollectionsKt.addAll((Collection)this.selected, (Object[])selected2);
    }

    @Override
    public boolean clearSelection() {
        boolean bl;
        if (this.isEnabled() && this.isActive()) {
            Set changes = new HashSet();
            changes.addAll((Collection)this.selected);
            this.selected.clear();
            this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isActive() {
        return !this.selected.isEmpty() && this.isEnabled();
    }

    @Override
    public boolean isSelected(@Nullable E element) {
        return element != null && this.selected.contains(element);
    }

    @Override
    public void setSelectedElement(E e) {
        if (this.isEnabled()) {
            if (e != null) {
                Set changes = new HashSet();
                for (E element : this.selected) {
                    changes.add(element);
                }
                if (!this.isSelected(e)) {
                    changes.add(e);
                    v0 = this.selected.add(e);
                } else {
                    v0 = changes.remove(e);
                }
                if (changes.size() > 0) {
                    this.selected.clear();
                    this.selected.add(e);
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                }
            } else {
                this.clearSelection();
            }
        }
    }

    @Override
    public void setSelectedState(E element, boolean selected2) {
        if (this.isEnabled() && element != null) {
            if (selected2) {
                if (!this.isSelected(element)) {
                    Set changes = new HashSet();
                    changes.add(element);
                    this.selected.add(element);
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                }
            } else if (this.isSelected(element)) {
                Set changes = new HashSet();
                changes.add(element);
                this.selected.remove(element);
                this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
            }
        }
    }

    @Override
    public boolean setSelectedIterableState(@NotNull Iterable<? extends E> elements, boolean selected2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.isEnabled()) {
            if (selected2) {
                Set changes = new HashSet();
                for (E element : elements) {
                    if (this.isSelected(element)) continue;
                    changes.add(element);
                    this.selected.add(element);
                }
                if (changes.size() > 0) {
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                    return true;
                }
            } else {
                Set changes = new HashSet();
                for (E element : elements) {
                    if (!this.isSelected(element)) continue;
                    changes.add(element);
                    this.selected.remove(element);
                }
                if (changes.size() > 0) {
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean setSelectedElementsState(boolean selected2, E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.isEnabled()) {
            if (selected2) {
                Set changes = new HashSet();
                for (E element : elements) {
                    if (this.isSelected(element)) continue;
                    changes.add(element);
                    this.selected.add(element);
                }
                if (changes.size() > 0) {
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                    return true;
                }
            } else {
                Set changes = new HashSet();
                for (E element : elements) {
                    if (!this.isSelected(element)) continue;
                    changes.add(element);
                    this.selected.remove(element);
                }
                if (changes.size() > 0) {
                    this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setSelectedElements(E ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.isEnabled()) {
            Set changes = new HashSet();
            for (E element : this.selected) {
                changes.add(element);
            }
            int n = elements.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                E element = elements[i];
                if (!this.isSelected(element)) {
                    changes.add(element);
                    bl = this.selected.add(element);
                    continue;
                }
                bl = changes.remove(element);
            }
            if (changes.size() > 0) {
                this.selected.clear();
                CollectionsKt.addAll((Collection)this.selected, (Object[])elements);
                this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
            }
        }
    }

    @Override
    public void setSelectedIterable(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (this.isEnabled()) {
            Set changes = new HashSet();
            for (Object element : this.selected) {
                changes.add(element);
            }
            for (Object element : elements) {
                boolean bl;
                if (!this.isSelected(element)) {
                    changes.add(element);
                    bl = this.selected.add(element);
                    continue;
                }
                bl = changes.remove(element);
            }
            if (changes.size() > 0) {
                this.selected.clear();
                for (Object element : elements) {
                    this.selected.add(element);
                }
                this.notifySelectedChanged(new SimpleSelectionEvent(this, changes));
            }
        }
    }

    @Override
    public int getSelectedCount() {
        return this.selected.size();
    }

    @Override
    @NotNull
    public Set<E> getSelectedSet() {
        return this.selected;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.selected.iterator();
    }

    @NotNull
    public String toString() {
        Object selected2 = "";
        boolean first = true;
        for (E s : this.selected) {
            if (!first) {
                selected2 = (String)selected2 + ",";
            } else {
                first = false;
            }
            selected2 = (String)selected2 + s;
        }
        return "SimpleSelection{selected=" + (String)selected2 + "}";
    }
}

