/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.common.timing;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010\t\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\u0006\u0010$\u001a\u00020\"J\n\u0010)\u001a\u00020&H\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u0014\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/macrofocus/common/timing/Timing;", "", "<init>", "()V", "useThreadMXBean", "", "getThreadMXBean", "Ljava/lang/management/ThreadMXBean;", "threadMXBean", "start", "", "end", "cpuStart", "Ljava/lang/Long;", "cpuEnd", "_lastDurationNs", "durationNs", "count", "", "_lastCpuDurationNs", "cpuDurationNs", "lastDuration", "getLastDuration", "()J", "averageDuration", "getAverageDuration", "lastCpuDuration", "getLastCpuDuration", "()Ljava/lang/Long;", "averageCpuDuration", "getAverageCpuDuration", "fps", "getFps", "()I", "", "stop", "print", "formattedCpuLastDuration", "", "getFormattedCpuLastDuration", "()Ljava/lang/String;", "toString", "macrofocus-common"})
@SourceDebugExtension(value={"SMAP\nTiming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timing.kt\ncom/macrofocus/common/timing/Timing\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class Timing {
    private final boolean useThreadMXBean;
    @Nullable
    private ThreadMXBean threadMXBean;
    private long start;
    private long end;
    @Nullable
    private Long cpuStart;
    @Nullable
    private Long cpuEnd;
    private long _lastDurationNs;
    private long durationNs;
    private int count;
    @Nullable
    private Long _lastCpuDurationNs;
    @Nullable
    private Long cpuDurationNs;

    private final ThreadMXBean getThreadMXBean() {
        if (this.useThreadMXBean) {
            ManagementFactory.getThreadMXBean();
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            boolean isSupported = threadBean.isCurrentThreadCpuTimeSupported();
            if (isSupported) {
                return threadBean;
            }
            return null;
        }
        return null;
    }

    public final long getLastDuration() {
        return this._lastDurationNs / (long)1000000;
    }

    public final long getAverageDuration() {
        return this.durationNs / (long)this.count / (long)1000000;
    }

    @Nullable
    public final Long getLastCpuDuration() {
        Long l = this._lastCpuDurationNs;
        return l != null ? Long.valueOf(l / (long)1000000) : null;
    }

    @Nullable
    public final Long getAverageCpuDuration() {
        Long l = this.cpuDurationNs;
        return l != null ? Long.valueOf(l / (long)this.count / (long)1000000) : null;
    }

    public final int getFps() {
        if (this.getLastDuration() > 0L) {
            return (int)(1000L / this.getLastDuration());
        }
        return 1000;
    }

    public final void start() {
        this.start = System.nanoTime();
        ThreadMXBean threadMXBean = this.threadMXBean = this.getThreadMXBean();
        this.cpuStart = threadMXBean != null ? Long.valueOf(threadMXBean.getCurrentThreadCpuTime()) : null;
    }

    public final void stop() {
        long it;
        this.end = System.nanoTime();
        ThreadMXBean threadMXBean = this.threadMXBean;
        this.cpuEnd = threadMXBean != null ? Long.valueOf(threadMXBean.getCurrentThreadCpuTime()) : null;
        this.threadMXBean = null;
        this._lastDurationNs = this.end - this.start;
        this.durationNs += this._lastDurationNs;
        Long l = this.cpuStart;
        if (l != null) {
            it = ((Number)l).longValue();
            boolean bl = false;
            Long l2 = this.cpuEnd;
            this._lastCpuDurationNs = l2 != null ? Long.valueOf(l2 - it) : null;
        }
        if (this.cpuDurationNs == null) {
            this.cpuDurationNs = this._lastCpuDurationNs;
        } else {
            Long l3;
            Timing timing = this;
            Long l4 = this._lastCpuDurationNs;
            if (l4 != null) {
                it = ((Number)l4).longValue();
                Timing timing2 = timing;
                boolean bl = false;
                Long l5 = this.cpuDurationNs;
                Intrinsics.checkNotNull((Object)l5);
                l3 = l5 + it;
                timing = timing2;
            } else {
                l3 = null;
            }
            timing.cpuDurationNs = l3;
        }
        int n = this.count;
        this.count = n + 1;
    }

    public final void print() {
        System.out.println((Object)this.toString());
    }

    @NotNull
    public final String getFormattedCpuLastDuration() {
        Long cpu = this.getLastCpuDuration();
        if (cpu != null) {
            return this.getLastDuration() + " (" + this.getLastCpuDuration() + ") ms)";
        }
        return this.getLastDuration() + " ms";
    }

    @NotNull
    public String toString() {
        return "Timing(lastDuration=" + this.getLastDuration() + ", fps=" + this.getFps() + ", averageDuration=" + this.getAverageDuration() + ")";
    }
}

