/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.Vector3D;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J&\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/algorithm/CGAlgorithms3D;", "", "<init>", "()V", "distance", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "distancePointSegment", "p", "A", "B", "distanceSegmentSegment", "C", "D", "kts-core"})
public final class CGAlgorithms3D {
    @NotNull
    public static final CGAlgorithms3D INSTANCE = new CGAlgorithms3D();

    private CGAlgorithms3D() {
    }

    public final double distance(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        if (Math.INSTANCE.isNaN(p0.getZ()) || Math.INSTANCE.isNaN(p1.getZ())) {
            return p0.distance(p1);
        }
        double dx = p0.x - p1.x;
        double dy = p0.y - p1.y;
        double dz = p0.getZ() - p1.getZ();
        return Math.INSTANCE.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double distancePointSegment(@NotNull Coordinate p, @NotNull Coordinate A, @NotNull Coordinate B) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        if (A.equals3D(B)) {
            return this.distance(p, A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y) + (B.getZ() - A.getZ()) * (B.getZ() - A.getZ());
        if (Math.INSTANCE.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r = ((p.x - A.x) * (B.x - A.x) + (p.y - A.y) * (B.y - A.y) + (p.getZ() - A.getZ()) * (B.getZ() - A.getZ())) / len2;
        if (r <= 0.0) {
            return this.distance(p, A);
        }
        if (r >= 1.0) {
            return this.distance(p, B);
        }
        double qx = A.x + r * (B.x - A.x);
        double qy = A.y + r * (B.y - A.y);
        double qz = A.getZ() + r * (B.getZ() - A.getZ());
        double dx = p.x - qx;
        double dy = p.y - qy;
        double dz = p.getZ() - qz;
        return Math.INSTANCE.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public final double distanceSegmentSegment(@NotNull Coordinate A, @NotNull Coordinate B, @NotNull Coordinate C, @NotNull Coordinate D) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        Intrinsics.checkNotNullParameter((Object)C, (String)"C");
        Intrinsics.checkNotNullParameter((Object)D, (String)"D");
        if (A.equals3D(B)) {
            return this.distancePointSegment(A, C, D);
        }
        if (C.equals3D(B)) {
            return this.distancePointSegment(C, A, B);
        }
        double a = Vector3D.Companion.dot(A, B, A, B);
        double b = Vector3D.Companion.dot(A, B, C, D);
        double c = Vector3D.Companion.dot(C, D, C, D);
        double d = Vector3D.Companion.dot(A, B, C, A);
        double e = Vector3D.Companion.dot(C, D, C, A);
        double denom = a * c - b * b;
        if (Math.INSTANCE.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double s = 0.0;
        double t = 0.0;
        if (denom <= 0.0) {
            s = 0.0;
            t = b > c ? d / b : e / c;
        } else {
            s = (b * e - c * d) / denom;
            t = (a * e - b * d) / denom;
        }
        if (s < 0.0) {
            return this.distancePointSegment(A, C, D);
        }
        if (s > 1.0) {
            return this.distancePointSegment(B, C, D);
        }
        if (t < 0.0) {
            return this.distancePointSegment(C, A, B);
        }
        if (t > 1.0) {
            return this.distancePointSegment(D, A, B);
        }
        double x1 = A.x + s * (B.x - A.x);
        double y1 = A.y + s * (B.y - A.y);
        double z1 = A.getZ() + s * (B.getZ() - A.getZ());
        double x2 = C.x + t * (D.x - C.x);
        double y2 = C.y + t * (D.y - C.y);
        double z2 = C.getZ() + t * (D.getZ() - C.getZ());
        return this.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

