/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J*\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/algorithm/Intersection;", "", "<init>", "()V", "intersection", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "q1", "q2", "lineSegment", "line1", "line2", "seg1", "seg2", "kts-core"})
public final class Intersection {
    @NotNull
    public static final Intersection INSTANCE = new Intersection();

    private Intersection() {
    }

    @JvmStatic
    @Nullable
    public static final Coordinate intersection(@NotNull Coordinate p1, @NotNull Coordinate p2, @NotNull Coordinate q1, @NotNull Coordinate q2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)q1, (String)"q1");
        Intrinsics.checkNotNullParameter((Object)q2, (String)"q2");
        double minX0 = p1.x < p2.x ? p1.x : p2.x;
        double minY0 = p1.y < p2.y ? p1.y : p2.y;
        double maxX0 = p1.x > p2.x ? p1.x : p2.x;
        double maxY0 = p1.y > p2.y ? p1.y : p2.y;
        double minX1 = q1.x < q2.x ? q1.x : q2.x;
        double minY1 = q1.y < q2.y ? q1.y : q2.y;
        double maxX1 = q1.x > q2.x ? q1.x : q2.x;
        double maxY1 = q1.y > q2.y ? q1.y : q2.y;
        double intMinX = minX0 > minX1 ? minX0 : minX1;
        double intMaxX = maxX0 < maxX1 ? maxX0 : maxX1;
        double intMinY = minY0 > minY1 ? minY0 : minY1;
        double intMaxY = maxY0 < maxY1 ? maxY0 : maxY1;
        double midx = (intMinX + intMaxX) / 2.0;
        double midy = (intMinY + intMaxY) / 2.0;
        double p1x = p1.x - midx;
        double p1y = p1.y - midy;
        double p2x = p2.x - midx;
        double p2y = p2.y - midy;
        double q1x = q1.x - midx;
        double q1y = q1.y - midy;
        double q2x = q2.x - midx;
        double q2y = q2.y - midy;
        double px = p1y - p2y;
        double py = p2x - p1x;
        double pw = p1x * p2y - p2x * p1y;
        double qx = q1y - q2y;
        double qy = q2x - q1x;
        double qw = q1x * q2y - q2x * q1y;
        double x = py * qw - qy * pw;
        double y = qx * pw - px * qw;
        double w = px * qy - qx * py;
        double xInt = x / w;
        double yInt = y / w;
        return Math.INSTANCE.isNaN(xInt) || Math.INSTANCE.isInfinite(xInt) || Math.INSTANCE.isNaN(yInt) || Math.INSTANCE.isInfinite(yInt) ? null : new Coordinate(xInt + midx, yInt + midy);
    }

    @JvmStatic
    @Nullable
    public static final Coordinate lineSegment(@NotNull Coordinate line1, @NotNull Coordinate line2, @NotNull Coordinate seg1, @NotNull Coordinate seg2) {
        double dist2;
        Coordinate intPt;
        Intrinsics.checkNotNullParameter((Object)line1, (String)"line1");
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line2");
        Intrinsics.checkNotNullParameter((Object)seg1, (String)"seg1");
        Intrinsics.checkNotNullParameter((Object)seg2, (String)"seg2");
        int orientS1 = Orientation.index(line1, line2, seg1);
        if (orientS1 == 0) {
            return seg1.copy();
        }
        int orientS2 = Orientation.index(line1, line2, seg2);
        if (orientS2 == 0) {
            return seg2.copy();
        }
        if (orientS1 > 0 && orientS2 > 0 || orientS1 < 0 && orientS2 < 0) {
            return null;
        }
        Coordinate coordinate = intPt = Intersection.intersection(line1, line2, seg1, seg2);
        if (coordinate != null) {
            return coordinate;
        }
        double dist1 = Distance.pointToLinePerpendicular(seg1, line1, line2);
        return dist1 < (dist2 = Distance.pointToLinePerpendicular(seg2, line1, line2)) ? seg1.copy() : seg2;
    }
}

