/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/algorithm/Length;", "", "<init>", "()V", "ofLine", "", "pts", "Lorg/locationtech/jts/geom/CoordinateSequence;", "kts-core"})
public final class Length {
    @NotNull
    public static final Length INSTANCE = new Length();

    private Length() {
    }

    @JvmStatic
    public static final double ofLine(@NotNull CoordinateSequence pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p = pts.createCoordinate();
        pts.getCoordinate(0, p);
        double x0 = p.x;
        double y0 = p.y;
        for (int i = 1; i < n; ++i) {
            pts.getCoordinate(i, p);
            double x1 = p.x;
            double y1 = p.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.INSTANCE.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

