/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.construct;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.queue.PriorityQueue;
import org.locationtech.jts.operation.distance.IndexedFacetDistance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 52\u00020\u0001:\u000245B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u001e\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110/H\u0002J \u00100\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00066"}, d2={"Lorg/locationtech/jts/algorithm/construct/LargestEmptyCircle;", "", "obstacles", "Lorg/locationtech/jts/geom/Geometry;", "tolerance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;D)V", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "boundary", "ptLocater", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "obstacleDistance", "Lorg/locationtech/jts/operation/distance/IndexedFacetDistance;", "boundaryDistance", "farthestCell", "Lorg/locationtech/jts/algorithm/construct/LargestEmptyCircle$Cell;", "centerCell", "centerPt", "Lorg/locationtech/jts/geom/Coordinate;", "centerPoint", "Lorg/locationtech/jts/geom/Point;", "radiusPt", "radiusPoint", "setBoundary", "", "center", "getCenter", "()Lorg/locationtech/jts/geom/Point;", "getRadiusPoint", "radiusLine", "Lorg/locationtech/jts/geom/LineString;", "getRadiusLine", "()Lorg/locationtech/jts/geom/LineString;", "distanceToConstraints", "p", "x", "y", "compute", "mayContainCircleCenter", "", "cell", "createInitialGrid", "env", "Lorg/locationtech/jts/geom/Envelope;", "cellQueue", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "createCell", "h", "createCentroidCell", "geom", "Cell", "Companion", "kts-core"})
public final class LargestEmptyCircle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry obstacles;
    private final double tolerance;
    @NotNull
    private final GeometryFactory factory;
    @Nullable
    private Geometry boundary;
    @Nullable
    private IndexedPointInAreaLocator ptLocater;
    @NotNull
    private final IndexedFacetDistance obstacleDistance;
    @Nullable
    private IndexedFacetDistance boundaryDistance;
    @Nullable
    private Cell farthestCell;
    @Nullable
    private Cell centerCell;
    @Nullable
    private Coordinate centerPt;
    @Nullable
    private Point centerPoint;
    @Nullable
    private Coordinate radiusPt;
    @Nullable
    private Point radiusPoint;

    public LargestEmptyCircle(@NotNull Geometry obstacles, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)obstacles, (String)"obstacles");
        if (obstacles.isEmpty()) {
            throw new IllegalArgumentException("Empty obstacles geometry is not supported");
        }
        this.obstacles = obstacles;
        this.factory = obstacles.getFactory();
        this.tolerance = tolerance;
        this.obstacleDistance = new IndexedFacetDistance(obstacles);
        this.setBoundary(obstacles);
    }

    private final void setBoundary(Geometry obstacles) {
        Geometry geometry = this.boundary = obstacles.convexHull();
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.getDimension() >= 2) {
            this.ptLocater = new IndexedPointInAreaLocator(this.boundary);
            Geometry geometry2 = this.boundary;
            Intrinsics.checkNotNull((Object)geometry2);
            this.boundaryDistance = new IndexedFacetDistance(geometry2);
        }
    }

    @Nullable
    public final Point getCenter() {
        this.compute();
        return this.centerPoint;
    }

    @Nullable
    public final Point getRadiusPoint() {
        this.compute();
        return this.radiusPoint;
    }

    @NotNull
    public final LineString getRadiusLine() {
        this.compute();
        Coordinate[] coordinateArray = new Coordinate[2];
        Coordinate coordinate = this.centerPt;
        Intrinsics.checkNotNull((Object)coordinate);
        coordinateArray[0] = coordinate.copy();
        Coordinate coordinate2 = this.radiusPt;
        Intrinsics.checkNotNull((Object)coordinate2);
        coordinateArray[1] = coordinate2.copy();
        return this.factory.createLineString(coordinateArray);
    }

    private final double distanceToConstraints(Point p) {
        boolean isOutide;
        IndexedPointInAreaLocator indexedPointInAreaLocator = this.ptLocater;
        Intrinsics.checkNotNull((Object)indexedPointInAreaLocator);
        Coordinate coordinate = p.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        boolean bl = isOutide = 2 == indexedPointInAreaLocator.locate(coordinate);
        if (isOutide) {
            IndexedFacetDistance indexedFacetDistance = this.boundaryDistance;
            Intrinsics.checkNotNull((Object)indexedFacetDistance);
            double boundaryDist = indexedFacetDistance.distance(p);
            return -boundaryDist;
        }
        return this.obstacleDistance.distance(p);
    }

    private final double distanceToConstraints(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point pt = this.factory.createPoint(coord);
        return this.distanceToConstraints(pt);
    }

    private final void compute() {
        if (this.centerCell != null) {
            return;
        }
        if (this.ptLocater == null) {
            Coordinate pt;
            Coordinate coordinate = pt = this.obstacles.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            this.centerPt = coordinate.copy();
            this.centerPoint = this.factory.createPoint(pt);
            this.radiusPt = pt.copy();
            this.radiusPoint = this.factory.createPoint(pt);
            return;
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(0, null, 3, null);
        this.createInitialGrid(this.obstacles.getEnvelopeInternal(), cellQueue);
        this.farthestCell = this.createCentroidCell(this.obstacles);
        while (!cellQueue.isEmpty()) {
            Cell cell;
            Cell cell2 = cell = (Cell)cellQueue.remove();
            Intrinsics.checkNotNull((Object)cell2);
            double d = cell2.getDistance();
            Cell cell3 = this.farthestCell;
            Intrinsics.checkNotNull((Object)cell3);
            if (d > cell3.getDistance()) {
                this.farthestCell = cell;
            }
            if (!this.mayContainCircleCenter(cell)) continue;
            double h2 = cell.getHSide() / (double)2;
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() - h2, h2));
            cellQueue.add(this.createCell(cell.getX() - h2, cell.getY() + h2, h2));
            cellQueue.add(this.createCell(cell.getX() + h2, cell.getY() + h2, h2));
        }
        Cell cell = this.centerCell = this.farthestCell;
        Intrinsics.checkNotNull((Object)cell);
        double d = cell.getX();
        Cell cell4 = this.centerCell;
        Intrinsics.checkNotNull((Object)cell4);
        this.centerPt = new Coordinate(d, cell4.getY());
        this.centerPoint = this.factory.createPoint(this.centerPt);
        Coordinate[] coordinateArray = this.obstacleDistance.nearestPoints(this.centerPoint);
        Intrinsics.checkNotNull((Object)coordinateArray);
        Coordinate[] nearestPts = coordinateArray;
        this.radiusPt = nearestPts[0].copy();
        this.radiusPoint = this.factory.createPoint(this.radiusPt);
    }

    private final boolean mayContainCircleCenter(Cell cell) {
        if (cell.isFullyOutside()) {
            return false;
        }
        if (cell.isOutside()) {
            return cell.getMaxDistance() > this.tolerance;
        }
        double d = cell.getMaxDistance();
        Cell cell2 = this.farthestCell;
        Intrinsics.checkNotNull((Object)cell2);
        double potentialIncrease = d - cell2.getDistance();
        return potentialIncrease > this.tolerance;
    }

    private final void createInitialGrid(Envelope env, PriorityQueue<Cell> cellQueue) {
        double minX = env.getMinX();
        double maxX = env.getMaxX();
        double minY = env.getMinY();
        double maxY = env.getMaxY();
        double width = env.getWidth();
        double height = env.getHeight();
        double cellSize = Math.INSTANCE.min(width, height);
        double hSize = cellSize / 2.0;
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(this.createCell(x + hSize, y + hSize, hSize));
            }
        }
    }

    private final Cell createCell(double x, double y, double h) {
        return new Cell(x, y, h, this.distanceToConstraints(x, y));
    }

    private final Cell createCentroidCell(Geometry geom) {
        Point p = geom.getCentroid();
        return new Cell(p.getX(), p.getY(), 0.0, this.distanceToConstraints(p));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00172\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0001\u0017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000H\u0096\u0082\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/algorithm/construct/LargestEmptyCircle$Cell;", "", "x", "", "y", "hSide", "distance", "<init>", "(DDDD)V", "getX", "()D", "getY", "getHSide", "getDistance", "maxDistance", "getMaxDistance", "isFullyOutside", "", "()Z", "isOutside", "compareTo", "", "o", "Companion", "kts-core"})
    private static final class Cell
    implements Comparable<Cell> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double x;
        private final double y;
        private final double hSide;
        private final double distance;
        private final double maxDistance;
        private static final double SQRT2 = 1.4142135623730951;

        public Cell(double x, double y, double hSide, double distance) {
            this.x = x;
            this.y = y;
            this.hSide = hSide;
            this.distance = distance;
            this.maxDistance = this.distance + this.hSide * 1.4142135623730951;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getHSide() {
            return this.hSide;
        }

        public final double getDistance() {
            return this.distance;
        }

        public final double getMaxDistance() {
            return this.maxDistance;
        }

        public final boolean isFullyOutside() {
            return this.maxDistance < 0.0;
        }

        public final boolean isOutside() {
            return this.distance < 0.0;
        }

        @Override
        public int compareTo(@Nullable Cell o) {
            Cell cell = o;
            Intrinsics.checkNotNull((Object)cell);
            return (int)(cell.maxDistance - this.maxDistance);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/algorithm/construct/LargestEmptyCircle$Cell$Companion;", "", "<init>", "()V", "SQRT2", "", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/construct/LargestEmptyCircle$Companion;", "", "<init>", "()V", "getCenter", "Lorg/locationtech/jts/geom/Point;", "obstacles", "Lorg/locationtech/jts/geom/Geometry;", "tolerance", "", "getRadiusLine", "Lorg/locationtech/jts/geom/LineString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Point getCenter(@NotNull Geometry obstacles, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)obstacles, (String)"obstacles");
            LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, tolerance);
            return lec.getCenter();
        }

        @NotNull
        public final LineString getRadiusLine(@NotNull Geometry obstacles, double tolerance) {
            Intrinsics.checkNotNullParameter((Object)obstacles, (String)"obstacles");
            LargestEmptyCircle lec = new LargestEmptyCircle(obstacles, tolerance);
            return lec.getRadiusLine();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

