/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.hull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.hull.HullTri;
import org.locationtech.jts.algorithm.hull.HullTriangulation;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.queue.PriorityQueue;
import org.locationtech.jts.triangulate.tri.Tri;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001d2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001bH\u0002J \u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0016\u0010\"\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u0010#\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010$\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u001e\u0010'\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/algorithm/hull/ConcaveHull;", "", "inputGeometry", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "maxEdgeLength", "", "maxEdgeLengthRatio", "isHolesAllowed", "", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "setMaximumEdgeLength", "", "edgeLength", "setMaximumEdgeLengthRatio", "edgeLengthRatio", "setHolesAllowed", "hull", "getHull", "()Lorg/locationtech/jts/geom/Geometry;", "computeHull", "triList", "", "Lorg/locationtech/jts/algorithm/hull/HullTri;", "computeHullBorder", "", "createBorderQueue", "Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "addBorderTri", "tri", "queue", "isBelowLengthThreshold", "computeHullHoles", "removeHole", "triHole", "isRemovableBorder", "isRemovableHole", "toGeometry", "Companion", "kts-core"})
public final class ConcaveHull {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeometry;
    private double maxEdgeLength;
    private double maxEdgeLengthRatio;
    private boolean isHolesAllowed;
    @NotNull
    private final GeometryFactory geomFactory;

    public ConcaveHull(@NotNull Geometry inputGeometry) {
        Intrinsics.checkNotNullParameter((Object)inputGeometry, (String)"inputGeometry");
        this.inputGeometry = inputGeometry;
        this.maxEdgeLengthRatio = -1.0;
        this.geomFactory = this.inputGeometry.getFactory();
    }

    public final void setMaximumEdgeLength(double edgeLength) {
        if (edgeLength < 0.0) {
            throw new IllegalArgumentException("Edge length must be non-negative");
        }
        this.maxEdgeLength = edgeLength;
        this.maxEdgeLengthRatio = -1.0;
    }

    public final void setMaximumEdgeLengthRatio(double edgeLengthRatio) {
        if (edgeLengthRatio < 0.0 || edgeLengthRatio > 1.0) {
            throw new IllegalArgumentException("Edge length ratio must be in range [0,1]");
        }
        this.maxEdgeLengthRatio = edgeLengthRatio;
    }

    public final void setHolesAllowed(boolean isHolesAllowed) {
        this.isHolesAllowed = isHolesAllowed;
    }

    @NotNull
    public final Geometry getHull() {
        if (this.inputGeometry.isEmpty()) {
            return GeometryFactory.createPolygon$default(this.geomFactory, null, null, 3, null);
        }
        List<HullTri> triList = HullTriangulation.INSTANCE.createDelaunayTriangulation(this.inputGeometry);
        if (this.maxEdgeLengthRatio >= 0.0) {
            this.maxEdgeLength = ConcaveHull.Companion.computeTargetEdgeLength(triList, this.maxEdgeLengthRatio);
        }
        if (triList.isEmpty()) {
            Geometry geometry = this.inputGeometry.convexHull();
            Intrinsics.checkNotNull((Object)geometry);
            return geometry;
        }
        this.computeHull(triList);
        return this.toGeometry(triList, this.geomFactory);
    }

    private final void computeHull(List<HullTri> triList) {
        this.computeHullBorder(triList);
        if (this.isHolesAllowed) {
            this.computeHullHoles(triList);
        }
    }

    private final void computeHullBorder(List<HullTri> triList) {
        PriorityQueue<HullTri> queue = this.createBorderQueue(triList);
        while (!queue.isEmpty()) {
            Object object = queue.poll();
            Intrinsics.checkNotNull((Object)object);
            HullTri tri = (HullTri)object;
            if (this.isBelowLengthThreshold(tri)) break;
            if (!this.isRemovableBorder(tri)) continue;
            HullTri adj0 = (HullTri)tri.getAdjacent(0);
            HullTri adj1 = (HullTri)tri.getAdjacent(1);
            HullTri adj2 = (HullTri)tri.getAdjacent(2);
            Intrinsics.checkNotNull(triList, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.locationtech.jts.triangulate.tri.Tri>");
            tri.remove(TypeIntrinsics.asMutableList(triList));
            this.addBorderTri(adj0, queue);
            this.addBorderTri(adj1, queue);
            this.addBorderTri(adj2, queue);
        }
    }

    private final PriorityQueue<HullTri> createBorderQueue(List<HullTri> triList) {
        PriorityQueue<HullTri> queue = new PriorityQueue<HullTri>(0, null, 3, null);
        Iterator<HullTri> iterator2 = triList.iterator();
        while (iterator2.hasNext()) {
            HullTri tri;
            HullTri hullTri = tri = iterator2.next();
            Intrinsics.checkNotNull((Object)hullTri);
            if (hullTri.numAdjacent() != 2) continue;
            tri.setSizeToBoundary();
            queue.add(tri);
        }
        return queue;
    }

    private final void addBorderTri(HullTri tri, PriorityQueue<HullTri> queue) {
        if (tri == null) {
            return;
        }
        if (tri.numAdjacent() != 2) {
            return;
        }
        tri.setSizeToBoundary();
        queue.add(tri);
    }

    private final boolean isBelowLengthThreshold(HullTri tri) {
        return tri.lengthOfBoundary() < this.maxEdgeLength;
    }

    private final void computeHullHoles(List<HullTri> triList) {
        List candidateHoles = ConcaveHull.Companion.findCandidateHoles(triList, this.maxEdgeLength);
        for (HullTri tri : candidateHoles) {
            if (tri.isRemoved() || tri.isBorder() || tri.hasBoundaryTouch()) continue;
            this.removeHole(triList, tri);
        }
    }

    private final void removeHole(List<HullTri> triList, HullTri triHole) {
        PriorityQueue<HullTri> queue = new PriorityQueue<HullTri>(0, null, 3, null);
        HullTri hullTri = triHole;
        Intrinsics.checkNotNull((Object)hullTri);
        queue.add(hullTri);
        while (!queue.isEmpty()) {
            Object object = queue.poll();
            Intrinsics.checkNotNull((Object)object);
            HullTri tri = (HullTri)object;
            if (tri != triHole && this.isBelowLengthThreshold(tri)) break;
            if (tri != triHole && !this.isRemovableHole(tri)) continue;
            HullTri adj0 = (HullTri)tri.getAdjacent(0);
            HullTri adj1 = (HullTri)tri.getAdjacent(1);
            HullTri adj2 = (HullTri)tri.getAdjacent(2);
            Intrinsics.checkNotNull(triList, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.locationtech.jts.triangulate.tri.Tri>");
            tri.remove(TypeIntrinsics.asMutableList(triList));
            this.addBorderTri(adj0, queue);
            this.addBorderTri(adj1, queue);
            this.addBorderTri(adj2, queue);
        }
    }

    private final boolean isRemovableBorder(HullTri tri) {
        return tri.numAdjacent() != 2 ? false : !tri.isConnecting();
    }

    private final boolean isRemovableHole(HullTri tri) {
        return tri.numAdjacent() != 2 ? false : !tri.hasBoundaryTouch();
    }

    private final Geometry toGeometry(List<HullTri> triList, GeometryFactory geomFactory) {
        return !this.isHolesAllowed ? HullTriangulation.INSTANCE.traceBoundaryPolygon(triList, geomFactory) : HullTriangulation.INSTANCE.union(triList, geomFactory);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLength(@NotNull Geometry geom, double maxLength, boolean isHolesAllowed) {
        return Companion.concaveHullByLength(geom, maxLength, isHolesAllowed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLengthRatio(@NotNull Geometry geom, double lengthRatio, boolean isHolesAllowed) {
        return Companion.concaveHullByLengthRatio(geom, lengthRatio, isHolesAllowed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLength(@NotNull Geometry geom, double maxLength) {
        return Companion.concaveHullByLength(geom, maxLength);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry concaveHullByLengthRatio(@NotNull Geometry geom, double lengthRatio) {
        return Companion.concaveHullByLengthRatio(geom, lengthRatio);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u000e\u001a\u00020\u00052\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/algorithm/hull/ConcaveHull$Companion;", "", "<init>", "()V", "uniformGridEdgeLength", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "concaveHullByLength", "maxLength", "isHolesAllowed", "", "concaveHullByLengthRatio", "lengthRatio", "computeTargetEdgeLength", "triList", "", "Lorg/locationtech/jts/algorithm/hull/HullTri;", "edgeLengthRatio", "findCandidateHoles", "", "minEdgeLen", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double uniformGridEdgeLength(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Geometry geometry = geom.convexHull();
            Intrinsics.checkNotNull((Object)geometry);
            double areaCH = geometry.getArea();
            int numPts = geom.getNumPoints();
            return Math.INSTANCE.sqrt(areaCH / (double)numPts);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLength(@NotNull Geometry geom, double maxLength, boolean isHolesAllowed) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            ConcaveHull hull = new ConcaveHull(geom);
            hull.setMaximumEdgeLength(maxLength);
            hull.setHolesAllowed(isHolesAllowed);
            return hull.getHull();
        }

        public static /* synthetic */ Geometry concaveHullByLength$default(Companion companion, Geometry geometry, double d, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.concaveHullByLength(geometry, d, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLengthRatio(@NotNull Geometry geom, double lengthRatio, boolean isHolesAllowed) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            ConcaveHull hull = new ConcaveHull(geom);
            hull.setMaximumEdgeLengthRatio(lengthRatio);
            hull.setHolesAllowed(isHolesAllowed);
            return hull.getHull();
        }

        public static /* synthetic */ Geometry concaveHullByLengthRatio$default(Companion companion, Geometry geometry, double d, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.concaveHullByLengthRatio(geometry, d, bl);
        }

        private final double computeTargetEdgeLength(List<HullTri> triList, double edgeLengthRatio) {
            if (edgeLengthRatio == 0.0) {
                return 0.0;
            }
            double maxEdgeLen = -1.0;
            double minEdgeLen = -1.0;
            for (HullTri tri : triList) {
                for (int i = 0; i < 3; ++i) {
                    HullTri hullTri = tri;
                    Intrinsics.checkNotNull((Object)hullTri);
                    double len = hullTri.getCoordinate(i).distance(tri.getCoordinate(Tri.Companion.next(i)));
                    if (len > maxEdgeLen) {
                        maxEdgeLen = len;
                    }
                    if (!(minEdgeLen < 0.0) && !(len < minEdgeLen)) continue;
                    minEdgeLen = len;
                }
            }
            return edgeLengthRatio == 1.0 ? (double)2 * maxEdgeLen : edgeLengthRatio * (maxEdgeLen - minEdgeLen) + minEdgeLen;
        }

        private final List<HullTri> findCandidateHoles(List<HullTri> triList, double minEdgeLen) {
            List candidates = new ArrayList();
            for (HullTri tri : triList) {
                boolean isTouchingBoundary;
                if (tri.getSize() < minEdgeLen || (isTouchingBoundary = tri.isBorder() || tri.hasBoundaryTouch())) continue;
                candidates.add(tri);
            }
            CollectionsKt.sort((List)candidates);
            return candidates;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLength(@NotNull Geometry geom, double maxLength) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return org.locationtech.jts.algorithm.hull.ConcaveHull$Companion.concaveHullByLength$default(this, geom, maxLength, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry concaveHullByLengthRatio(@NotNull Geometry geom, double lengthRatio) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return org.locationtech.jts.algorithm.hull.ConcaveHull$Companion.concaveHullByLengthRatio$default(this, geom, lengthRatio, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

