/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.dissolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.dissolve.DissolveEdgeGraph;
import org.locationtech.jts.dissolve.DissolveHalfEdge;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.edgegraph.MarkHalfEdge;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.legacy.StackKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0016H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u000bj\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/locationtech/jts/dissolve/LineDissolver;", "", "<init>", "()V", "result", "Lorg/locationtech/jts/geom/Geometry;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "graph", "Lorg/locationtech/jts/dissolve/DissolveEdgeGraph;", "lines", "", "Lorg/locationtech/jts/geom/LineString;", "add", "", "geometry", "geometries", "", "lineString", "getResult", "computeResult", "nodeEdgeStack", "Lorg/locationtech/jts/edgegraph/HalfEdge;", "Lorg/locationtech/jts/legacy/Stack;", "process", "e", "buildLines", "ringStartEdge", "Lorg/locationtech/jts/dissolve/DissolveHalfEdge;", "updateRingStartEdge", "buildLine", "eStart", "buildRing", "eStartRing", "addLine", "line", "Lorg/locationtech/jts/geom/CoordinateList;", "stackEdges", "node", "Companion", "kts-core"})
public final class LineDissolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Geometry result;
    @Nullable
    private GeometryFactory factory;
    @NotNull
    private final DissolveEdgeGraph graph = new DissolveEdgeGraph();
    @NotNull
    private final List<LineString> lines = new ArrayList();
    @NotNull
    private final List<HalfEdge> nodeEdgeStack = new ArrayList();
    @Nullable
    private DissolveHalfEdge ringStartEdge;

    public final void add(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        geometry.apply(new GeometryComponentFilter(this){
            final /* synthetic */ LineDissolver this$0;
            {
                this.this$0 = $receiver;
            }

            public void filter(Geometry component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                if (component instanceof LineString) {
                    LineDissolver.access$add(this.this$0, (LineString)component);
                }
            }
        });
    }

    public final void add(@NotNull Collection<?> geometries) {
        Intrinsics.checkNotNullParameter(geometries, (String)"geometries");
        for (Object obj : geometries) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geometry = (Geometry)obj;
            this.add(geometry);
        }
    }

    private final void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        CoordinateSequence seq = lineString.getCoordinateSequence();
        boolean doneStart = false;
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int n = coordinateSequence.size();
        for (int i = 1; i < n; ++i) {
            DissolveHalfEdge e;
            if ((DissolveHalfEdge)this.graph.addEdge(seq.getCoordinate(i - 1), seq.getCoordinate(i)) == null || doneStart) continue;
            e.setStart();
            doneStart = true;
        }
    }

    @Nullable
    public final Geometry getResult() {
        if (this.result == null) {
            this.computeResult();
        }
        return this.result;
    }

    private final void computeResult() {
        Collection<HalfEdge> edges = this.graph.getVertexEdges();
        Iterator<HalfEdge> i = edges.iterator();
        while (i.hasNext()) {
            HalfEdge e;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.edgegraph.HalfEdge");
            if (MarkHalfEdge.Companion.isMarked(e)) continue;
            this.process(e);
        }
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        this.result = geometryFactory.buildGeometry((Collection<? extends Geometry>)this.lines);
    }

    private final void process(HalfEdge e) {
        HalfEdge eNode = e.prevNode();
        if (eNode == null) {
            eNode = e;
        }
        this.stackEdges(eNode);
        this.buildLines();
    }

    private final void buildLines() {
        while (!StackKt.empty(this.nodeEdgeStack)) {
            HalfEdge e;
            Intrinsics.checkNotNull((Object)StackKt.pop(this.nodeEdgeStack), (String)"null cannot be cast to non-null type org.locationtech.jts.edgegraph.HalfEdge");
            if (MarkHalfEdge.Companion.isMarked(e)) continue;
            this.buildLine(e);
        }
    }

    private final void updateRingStartEdge(DissolveHalfEdge e) {
        DissolveHalfEdge e2 = e;
        if (!e2.isStart()) {
            HalfEdge halfEdge = e2.sym();
            Intrinsics.checkNotNull((Object)halfEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.dissolve.DissolveHalfEdge");
            e2 = (DissolveHalfEdge)halfEdge;
            if (!e2.isStart()) {
                return;
            }
        }
        if (this.ringStartEdge == null) {
            this.ringStartEdge = e2;
            return;
        }
        Coordinate coordinate = e2.orig();
        DissolveHalfEdge dissolveHalfEdge = this.ringStartEdge;
        Intrinsics.checkNotNull((Object)dissolveHalfEdge);
        if (coordinate.compareTo(dissolveHalfEdge.orig()) < 0) {
            this.ringStartEdge = e2;
        }
    }

    private final void buildLine(HalfEdge eStart) {
        CoordinateList line = new CoordinateList();
        Intrinsics.checkNotNull((Object)eStart, (String)"null cannot be cast to non-null type org.locationtech.jts.dissolve.DissolveHalfEdge");
        DissolveHalfEdge e = (DissolveHalfEdge)eStart;
        this.ringStartEdge = null;
        MarkHalfEdge.Companion.markBoth(e);
        line.add(e.orig().copy(), false);
        while (true) {
            HalfEdge halfEdge = e.sym();
            Intrinsics.checkNotNull((Object)halfEdge);
            if (halfEdge.degree() != 2) break;
            this.updateRingStartEdge(e);
            HalfEdge halfEdge2 = e.next();
            Intrinsics.checkNotNull((Object)halfEdge2, (String)"null cannot be cast to non-null type org.locationtech.jts.dissolve.DissolveHalfEdge");
            DissolveHalfEdge eNext = (DissolveHalfEdge)halfEdge2;
            if (eNext == eStart) {
                DissolveHalfEdge dissolveHalfEdge = this.ringStartEdge;
                Intrinsics.checkNotNull((Object)dissolveHalfEdge);
                this.buildRing(dissolveHalfEdge);
                return;
            }
            line.add(eNext.orig().copy(), false);
            e = eNext;
            MarkHalfEdge.Companion.markBoth(e);
        }
        line.add(e.dest().clone(), false);
        HalfEdge halfEdge = e.sym();
        Intrinsics.checkNotNull((Object)halfEdge);
        this.stackEdges(halfEdge);
        this.addLine(line);
    }

    private final void buildRing(HalfEdge eStartRing) {
        CoordinateList line = new CoordinateList();
        HalfEdge e = eStartRing;
        line.add(e.orig().copy(), false);
        while (true) {
            HalfEdge eNext;
            HalfEdge halfEdge = e.sym();
            Intrinsics.checkNotNull((Object)halfEdge);
            if (halfEdge.degree() != 2) break;
            Intrinsics.checkNotNull((Object)e.next());
            if (eNext == eStartRing) break;
            line.add(eNext.orig().copy(), false);
            e = eNext;
        }
        line.add(e.dest().copy(), false);
        this.addLine(line);
    }

    private final void addLine(CoordinateList line) {
        GeometryFactory geometryFactory = this.factory;
        Intrinsics.checkNotNull((Object)geometryFactory);
        this.lines.add(geometryFactory.createLineString(line.toCoordinateArray()));
    }

    private final void stackEdges(HalfEdge node) {
        HalfEdge e = node;
        do {
            if (!MarkHalfEdge.Companion.isMarked(e)) {
                this.nodeEdgeStack.add(e);
            }
            Intrinsics.checkNotNull((Object)e.oNext());
        } while (e != node);
    }

    public static final /* synthetic */ void access$add(LineDissolver $this, LineString lineString) {
        $this.add(lineString);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/dissolve/LineDissolver$Companion;", "", "<init>", "()V", "dissolve", "Lorg/locationtech/jts/geom/Geometry;", "g", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry dissolve(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            LineDissolver d = new LineDissolver();
            d.add(g);
            return d.getResult();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

