/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0000J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000e\u001a\u00020\u0003H\u0014J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0000H\u0002J\u0012\u0010\u0011\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0002J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0000H\u0086\u0002J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000H\u0002J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0000H\u0002J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0086\u0002J\u0010\u0010#\u001a\u00020!2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000J\n\u0010$\u001a\u00020%H\u0096\u0080\u0004J\u0006\u0010&\u001a\u00020%J\u0006\u0010'\u001a\u00020!J\b\u0010(\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/edgegraph/HalfEdge;", "", "orig", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "sym", "next", "link", "", "dest", "directionX", "", "directionY", "directionPt", "setSym", "e", "setNext", "prev", "oNext", "find", "equals", "", "p0", "p1", "insert", "eAdd", "insertionEdge", "insertAfter", "isEdgesSorted", "()Z", "findLowest", "compareTo", "", "obj", "compareAngularDirection", "toString", "", "toStringNode", "degree", "prevNode", "Companion", "kts-core"})
public class HalfEdge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate orig;
    @Nullable
    private HalfEdge sym;
    @Nullable
    private HalfEdge next;

    public HalfEdge(@NotNull Coordinate orig) {
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        this.orig = orig;
    }

    public final void link(@NotNull HalfEdge sym) {
        Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
        this.setSym(sym);
        sym.setSym(this);
        this.setNext(sym);
        sym.setNext(this);
    }

    @NotNull
    public final Coordinate orig() {
        return this.orig;
    }

    @NotNull
    public final Coordinate dest() {
        HalfEdge halfEdge = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge);
        return halfEdge.orig;
    }

    public final double directionX() {
        return this.directionPt().x - this.orig.x;
    }

    public final double directionY() {
        return this.directionPt().y - this.orig.y;
    }

    @NotNull
    protected Coordinate directionPt() {
        return this.dest();
    }

    @Nullable
    public final HalfEdge sym() {
        return this.sym;
    }

    private final void setSym(HalfEdge e) {
        this.sym = e;
    }

    private final void setNext(HalfEdge e) {
        this.next = e;
    }

    @Nullable
    public final HalfEdge next() {
        return this.next;
    }

    @Nullable
    public final HalfEdge prev() {
        HalfEdge halfEdge;
        HalfEdge curr = this;
        HalfEdge prev = this;
        do {
            prev = curr;
            halfEdge = curr;
            Intrinsics.checkNotNull((Object)halfEdge);
        } while ((curr = halfEdge.oNext()) != this);
        HalfEdge halfEdge2 = prev;
        Intrinsics.checkNotNull((Object)halfEdge2);
        return halfEdge2.sym;
    }

    @Nullable
    public final HalfEdge oNext() {
        HalfEdge halfEdge = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge);
        return halfEdge.next;
    }

    @Nullable
    public final HalfEdge find(@Nullable Coordinate dest) {
        HalfEdge oNext = this;
        do {
            if (oNext == null) {
                return null;
            }
            Coordinate coordinate = oNext.dest();
            Coordinate coordinate2 = dest;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (!coordinate.equals2D(coordinate2)) continue;
            return oNext;
        } while ((oNext = oNext.oNext()) != this);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Coordinate p0, @Nullable Coordinate p1) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        if (!this.orig.equals2D(coordinate)) return false;
        HalfEdge halfEdge = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge);
        if (!Intrinsics.areEqual((Object)halfEdge.orig, (Object)p1)) return false;
        return true;
    }

    public final void insert(@Nullable HalfEdge eAdd) {
        HalfEdge ePrev;
        if (this.oNext() == this) {
            this.insertAfter(eAdd);
            return;
        }
        HalfEdge halfEdge = ePrev = this.insertionEdge(eAdd);
        Intrinsics.checkNotNull((Object)halfEdge);
        halfEdge.insertAfter(eAdd);
    }

    private final HalfEdge insertionEdge(HalfEdge eAdd) {
        HalfEdge eNext;
        HalfEdge ePrev = this;
        do {
            HalfEdge halfEdge = ePrev;
            Intrinsics.checkNotNull((Object)halfEdge);
            HalfEdge halfEdge2 = eNext = halfEdge.oNext();
            Intrinsics.checkNotNull((Object)halfEdge2);
            if (halfEdge2.compareTo(ePrev) > 0) {
                HalfEdge halfEdge3 = eAdd;
                Intrinsics.checkNotNull((Object)halfEdge3);
                if (halfEdge3.compareTo(ePrev) >= 0 && eAdd.compareTo(eNext) <= 0) {
                    return ePrev;
                }
            }
            if (eNext.compareTo(ePrev) > 0) continue;
            HalfEdge halfEdge4 = eAdd;
            Intrinsics.checkNotNull((Object)halfEdge4);
            if (halfEdge4.compareTo(eNext) > 0 && eAdd.compareTo(ePrev) < 0) continue;
            return ePrev;
        } while ((ePrev = eNext) != this);
        Assert.shouldNeverReachHere$default(null, 1, null);
        return null;
    }

    private final void insertAfter(HalfEdge e) {
        HalfEdge halfEdge = e;
        Intrinsics.checkNotNull((Object)halfEdge);
        Assert.equals$default(Assert.INSTANCE, this.orig, halfEdge.orig(), null, 4, null);
        HalfEdge save = this.oNext();
        HalfEdge halfEdge2 = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge2);
        halfEdge2.setNext(e);
        HalfEdge halfEdge3 = e.sym();
        Intrinsics.checkNotNull((Object)halfEdge3);
        halfEdge3.setNext(save);
    }

    public final boolean isEdgesSorted() {
        HalfEdge eNext;
        HalfEdge lowest;
        HalfEdge e = lowest = this.findLowest();
        do {
            boolean isSorted;
            HalfEdge halfEdge = e;
            Intrinsics.checkNotNull((Object)halfEdge);
            eNext = halfEdge.oNext();
            if (eNext == lowest) break;
            HalfEdge halfEdge2 = eNext;
            Intrinsics.checkNotNull((Object)halfEdge2);
            boolean bl = isSorted = halfEdge2.compareTo(e) > 0;
            if (isSorted) continue;
            return false;
        } while ((e = eNext) != lowest);
        return true;
    }

    private final HalfEdge findLowest() {
        HalfEdge lowest = this;
        HalfEdge e = this.oNext();
        do {
            HalfEdge halfEdge = e;
            Intrinsics.checkNotNull((Object)halfEdge);
            if (halfEdge.compareTo(lowest) >= 0) continue;
            lowest = e;
        } while ((e = e.oNext()) != this);
        return lowest;
    }

    public final int compareTo(@Nullable Object obj) {
        HalfEdge e = (HalfEdge)obj;
        return this.compareAngularDirection(e);
    }

    public final int compareAngularDirection(@Nullable HalfEdge e) {
        int quadrant2;
        double dx = this.directionX();
        double dy = this.directionY();
        HalfEdge halfEdge = e;
        Intrinsics.checkNotNull((Object)halfEdge);
        double dx2 = halfEdge.directionX();
        double dy2 = e.directionY();
        if (dx == dx2 && dy == dy2) {
            return 0;
        }
        int quadrant = Quadrant.INSTANCE.quadrant(dx, dy);
        if (quadrant > (quadrant2 = Quadrant.INSTANCE.quadrant(dx2, dy2))) {
            return 1;
        }
        if (quadrant < quadrant2) {
            return -1;
        }
        Coordinate dir1 = this.directionPt();
        Coordinate dir2 = e.directionPt();
        return Orientation.index(e.orig, dir2, dir1);
    }

    @NotNull
    public String toString() {
        double d = this.orig.x;
        double d2 = this.orig.y;
        HalfEdge halfEdge = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge);
        double d3 = halfEdge.orig.x;
        HalfEdge halfEdge2 = this.sym;
        Intrinsics.checkNotNull((Object)halfEdge2);
        return "HE(" + d + " " + d2 + ", " + d3 + " " + halfEdge2.orig.y + ")";
    }

    @NotNull
    public final String toStringNode() {
        HalfEdge halfEdge;
        Coordinate orig = this.orig();
        Coordinate dest = this.dest();
        StringBuilder sb = new StringBuilder();
        sb.append("Node( " + WKTWriter.Companion.format(orig) + " )\n");
        HalfEdge e = this;
        do {
            sb.append("  -> " + e);
            sb.append("\n");
            halfEdge = e;
            Intrinsics.checkNotNull((Object)halfEdge);
        } while ((e = halfEdge.oNext()) != this);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int degree() {
        HalfEdge halfEdge;
        int degree = 0;
        HalfEdge e = this;
        do {
            ++degree;
            halfEdge = e;
            Intrinsics.checkNotNull((Object)halfEdge);
        } while ((e = halfEdge.oNext()) != this);
        return degree;
    }

    @Nullable
    public final HalfEdge prevNode() {
        HalfEdge e;
        block1: {
            e = this;
            do {
                HalfEdge halfEdge = e;
                Intrinsics.checkNotNull((Object)halfEdge);
                if (halfEdge.degree() != 2) break block1;
            } while ((e = e.prev()) != this);
            return null;
        }
        return e;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/edgegraph/HalfEdge$Companion;", "", "<init>", "()V", "create", "Lorg/locationtech/jts/edgegraph/HalfEdge;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HalfEdge create(@NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            HalfEdge e0 = new HalfEdge(p0);
            HalfEdge e1 = new HalfEdge(p1);
            e0.link(e1);
            return e0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

