/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.NumberUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 42\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u00012\u00020\u00022\u00060\u0003j\u0002`\u0004:\u000234B!\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\fB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u000e\u0010#\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010#\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010&\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0006J\u0014\u0010'\u001a\u00020!2\b\u0010\u0015\u001a\u0004\u0018\u00010(H\u0096\u0082\u0004J\u0014\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010\u0000H\u0096\u0082\u0004J\n\u0010+\u001a\u00020,H\u0096\u0080\u0004J\b\u0010-\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020\u0000H\u0016J\b\u0010/\u001a\u00020\u0000H\u0016J\u000e\u00100\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0000J\n\u00102\u001a\u00020\u001dH\u0096\u0080\u0004R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u00065"}, d2={"Lorg/locationtech/jts/geom/Coordinate;", "", "Lorg/locationtech/jts/legacy/Cloneable;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "x", "", "y", "z", "<init>", "(DDD)V", "c", "(Lorg/locationtech/jts/geom/Coordinate;)V", "()V", "(DD)V", "getZ", "()D", "setZ", "(D)V", "setCoordinate", "", "other", "m", "getM", "setM", "getX", "getY", "getOrdinate", "ordinateIndex", "", "setOrdinate", "value", "isValid", "", "()Z", "equals2D", "tolerance", "equals3D", "equalInZ", "equals", "", "compareTo", "o", "toString", "", "clone", "copy", "create", "distance", "distance3D", "hashCode", "DimensionalComparator", "Companion", "kts-core"})
public class Coordinate
implements Comparable<Coordinate>,
Cloneable,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public double x;
    @JvmField
    public double y;
    private double z;
    private static final long serialVersionUID = 6683108902428366910L;
    public static final double NULL_ORDINATE = Double.NaN;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int M = 3;

    @JvmOverloads
    public Coordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public Coordinate(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this(c.x, c.y, c.getZ());
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(double x, double y) {
        this(x, y, Double.NaN);
    }

    public void setCoordinate(@NotNull Coordinate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.x = other.x;
        this.y = other.y;
        this.setZ(other.getZ());
    }

    public double getM() {
        return Double.NaN;
    }

    public void setM(double m) {
        throw new IllegalArgumentException("Invalid ordinate index: 3");
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.getZ();
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.setZ(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    public final boolean isValid() {
        if (!Math.INSTANCE.isFinite(this.x)) {
            return false;
        }
        return Math.INSTANCE.isFinite(this.y);
    }

    public final boolean equals2D(@NotNull Coordinate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.x == other.x)) {
            return false;
        }
        return this.y == other.y;
    }

    public final boolean equals2D(@NotNull Coordinate c, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!NumberUtil.INSTANCE.equalsWithTolerance(this.x, c.x, tolerance)) {
            return false;
        }
        return NumberUtil.INSTANCE.equalsWithTolerance(this.y, c.y, tolerance);
    }

    public final boolean equals3D(@NotNull Coordinate other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x == other.x && this.y == other.y && (this.getZ() == other.getZ() || Math.INSTANCE.isNaN(this.getZ()) && Math.INSTANCE.isNaN(other.getZ()));
    }

    public final boolean equalInZ(@NotNull Coordinate c, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return NumberUtil.INSTANCE.equalsWithTolerance(this.getZ(), c.getZ(), tolerance);
    }

    public boolean equals(@Nullable Object other) {
        return !(other instanceof Coordinate) ? false : this.equals2D((Coordinate)other);
    }

    @Override
    public int compareTo(@Nullable Coordinate o) {
        if (o == null) {
            return 1;
        }
        if (this.x < o.x) {
            return -1;
        }
        if (this.x > o.x) {
            return 1;
        }
        if (this.y < o.y) {
            return -1;
        }
        return this.y > o.y ? 1 : 0;
    }

    @NotNull
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.getZ() + ")";
    }

    @Override
    @NotNull
    public Object clone() {
        return this.copy();
    }

    @NotNull
    public Coordinate copy() {
        return new Coordinate(this);
    }

    @NotNull
    public Coordinate create() {
        return new Coordinate();
    }

    public final double distance(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double dx = this.x - c.x;
        double dy = this.y - c.y;
        return Math.INSTANCE.sqrt(dx * dx + dy * dy);
    }

    public final double distance3D(@NotNull Coordinate c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double dx = this.x - c.x;
        double dy = this.y - c.y;
        double dz = this.getZ() - c.getZ();
        return Math.INSTANCE.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Companion.hashCode(this.x);
        result2 = 37 * result2 + Companion.hashCode(this.y);
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/geom/Coordinate$Companion;", "", "<init>", "()V", "serialVersionUID", "", "NULL_ORDINATE", "", "X", "", "Y", "Z", "M", "hashCode", "x", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int hashCode(double x) {
            long f = Math.INSTANCE.doubleToLongBits(x);
            return (int)(f ^ f >>> 32);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u000b2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u000bB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/geom/Coordinate$DimensionalComparator;", "Ljava/util/Comparator;", "Lorg/locationtech/jts/geom/Coordinate;", "Lkotlin/Comparator;", "dimensionsToTest", "", "<init>", "(I)V", "compare", "c1", "c2", "Companion", "kts-core"})
    public static final class DimensionalComparator
    implements Comparator<Coordinate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int dimensionsToTest;

        @JvmOverloads
        public DimensionalComparator(int dimensionsToTest) {
            this.dimensionsToTest = 2;
            if (dimensionsToTest != 2 && dimensionsToTest != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
            this.dimensionsToTest = dimensionsToTest;
        }

        public /* synthetic */ DimensionalComparator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 2;
            }
            this(n);
        }

        @Override
        public int compare(@NotNull Coordinate c1, @NotNull Coordinate c2) {
            Intrinsics.checkNotNullParameter((Object)c1, (String)"c1");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c2");
            int compX = Companion.compare(c1.x, c2.x);
            if (compX != 0) {
                return compX;
            }
            int compY = Companion.compare(c1.y, c2.y);
            if (compY != 0) {
                return compY;
            }
            return this.dimensionsToTest <= 2 ? 0 : Companion.compare(c1.getZ(), c2.getZ());
        }

        @JvmOverloads
        public DimensionalComparator() {
            this(0, 1, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geom/Coordinate$DimensionalComparator$Companion;", "", "<init>", "()V", "compare", "", "a", "", "b", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public final int compare(double a, double b) {
                if (a < b) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                if (Math.INSTANCE.isNaN(a)) {
                    return Math.INSTANCE.isNaN(b) ? 0 : -1;
                }
                return Math.INSTANCE.isNaN(b) ? 1 : 0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

