/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Coordinates;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.legacy.System;
import org.locationtech.jts.math.MathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u001e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002RSB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u0010J1\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0014J+\u0010\u0015\u001a\u0004\u0018\u00010\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0018\u001a\u00020\t2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0010\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010\u001c\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u000bJ+\u0010\u001d\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001eJ!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a2\u0006\u0002\u0010!JA\u0010\u001f\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010#\u001a\u00020\t2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0007\u00a2\u0006\u0002\u0010+J\u0019\u0010,\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0014J'\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u00101J\u001f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010!J\u0019\u00103\u001a\u00020\u00132\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0014J\u001f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010!J#\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010!J\u001b\u00106\u001a\u00020\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a2\u0006\u0002\u0010\u0010J-\u00107\u001a\u00020\u00132\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010\u001eJC\u00107\u001a\u00020\u00132\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0016\u0010:\u001a\u0012\u0012\u0004\u0012\u00020\u00060;j\b\u0012\u0004\u0012\u00020\u0006`<\u00a2\u0006\u0002\u0010=J\u001b\u0010>\u001a\u0004\u0018\u00010\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010?J!\u0010@\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010A\u001a\u00020\u0006\u00a2\u0006\u0002\u0010BJ-\u0010@\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010C\u001a\u00020\t2\b\b\u0002\u0010D\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010EJ!\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010HJ/\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010L\u001a\u00020M2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0007\u00a2\u0006\u0002\u0010NJ)\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010P\u001a\u00020MH\u0007\u00a2\u0006\u0002\u0010QR\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006T"}, d2={"Lorg/locationtech/jts/geom/CoordinateArrays;", "", "<init>", "()V", "coordArrayType", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "dimension", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)I", "measures", "enforceConsistency", "", "array", "([Lorg/locationtech/jts/geom/Coordinate;)V", "([Lorg/locationtech/jts/geom/Coordinate;II)[Lorg/locationtech/jts/geom/Coordinate;", "isRing", "", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "ptNotInList", "testPts", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "compare", "pts1", "pts2", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)I", "increasingDirection", "isEqualReversed", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Z", "copyDeep", "coordinates", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "src", "srcStart", "dest", "destStart", "length", "([Lorg/locationtech/jts/geom/Coordinate;I[Lorg/locationtech/jts/geom/Coordinate;II)V", "toCoordinateArray", "coordList", "", "(Ljava/util/Collection;)[Lorg/locationtech/jts/geom/Coordinate;", "hasRepeatedPoints", "coord", "atLeastNCoordinatesOrNothing", "n", "c", "(I[Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "removeRepeatedPoints", "hasRepeatedOrInvalidPoints", "removeRepeatedOrInvalidPoints", "removeNull", "reverse", "equals", "coord1", "coord2", "coordinateComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;Ljava/util/Comparator;)Z", "minCoordinate", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Coordinate;", "scroll", "firstCoordinate", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "indexOfFirstCoordinate", "ensureRing", "([Lorg/locationtech/jts/geom/Coordinate;IZ)V", "indexOf", "coordinate", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)I", "extract", "start", "end", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Envelope;", "intersection", "env", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Envelope;)[Lorg/locationtech/jts/geom/Coordinate;", "ForwardComparator", "BidirectionalComparator", "kts-core"})
@SourceDebugExtension(value={"SMAP\nCoordinateArrays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinateArrays.kt\norg/locationtech/jts/geom/CoordinateArrays\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 System.kt\norg/locationtech/jts/legacy/System\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,657:1\n1586#2:658\n1661#2,3:659\n37#3,2:662\n18#4:664\n18#4:666\n22#4:668\n1#5:665\n1#5:667\n1#5:669\n*S KotlinDebug\n*F\n+ 1 CoordinateArrays.kt\norg/locationtech/jts/geom/CoordinateArrays\n*L\n289#1:658\n289#1:659,3\n289#1:662,2\n498#1:664\n505#1:666\n522#1:668\n498#1:665\n505#1:667\n522#1:669\n*E\n"})
public final class CoordinateArrays {
    @NotNull
    public static final CoordinateArrays INSTANCE = new CoordinateArrays();
    @NotNull
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    private CoordinateArrays() {
    }

    @JvmStatic
    public static final int dimension(@Nullable Coordinate[] pts) {
        Coordinate[] coordinateArray = pts;
        if (coordinateArray == null || coordinateArray.length == 0) {
            return 3;
        }
        int dimension = 0;
        for (Coordinate coordinate : pts) {
            dimension = Math.max(dimension, Coordinates.INSTANCE.dimension(coordinate));
        }
        return dimension;
    }

    @JvmStatic
    public static final int measures(@Nullable Coordinate[] pts) {
        Coordinate[] coordinateArray = pts;
        if (coordinateArray == null || coordinateArray.length == 0) {
            return 0;
        }
        int measures = 0;
        for (Coordinate coordinate : pts) {
            measures = Math.max(measures, Coordinates.INSTANCE.measures(coordinate));
        }
        return measures;
    }

    @JvmStatic
    public static final void enforceConsistency(@Nullable Coordinate[] array) {
        if (array == null) {
            return;
        }
        int maxDimension = -1;
        int maxMeasures = -1;
        boolean isConsistent = true;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = array[i];
            if (coordinate == null) continue;
            int d = Coordinates.INSTANCE.dimension(coordinate);
            int m = Coordinates.INSTANCE.measures(coordinate);
            if (maxDimension == -1) {
                maxDimension = d;
                maxMeasures = m;
                continue;
            }
            if (d == maxDimension && m == maxMeasures) continue;
            isConsistent = false;
            maxDimension = Math.max(maxDimension, d);
            maxMeasures = Math.max(maxMeasures, m);
        }
        if (!isConsistent) {
            Coordinate sample = Coordinates.INSTANCE.create(maxDimension, maxMeasures);
            KClass type = Reflection.getOrCreateKotlinClass(sample.getClass());
            for (Coordinate coordinate : array) {
                if (coordinate == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(coordinate.getClass()), (Object)type)) continue;
                Coordinate duplicate = Coordinates.INSTANCE.create(maxDimension, maxMeasures);
                duplicate.setCoordinate(coordinate);
                array[i] = duplicate;
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final Coordinate[] enforceConsistency(@NotNull Coordinate[] array, int dimension, int measures) {
        Coordinate[] coordinateArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Coordinate sample = Coordinates.INSTANCE.create(dimension, measures);
        KClass type = Reflection.getOrCreateKotlinClass(sample.getClass());
        boolean isConsistent = true;
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Coordinate coordinate = array[i];
            if (coordinate == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(coordinate.getClass()), (Object)type)) continue;
            isConsistent = false;
            break;
        }
        if (isConsistent) {
            coordinateArray = array;
        } else {
            Class<?> coordinateType = sample.getClass();
            Coordinate[] coordinateArray2 = Arrays.copyOf(array, array.length);
            Intrinsics.checkNotNullExpressionValue((Object)coordinateArray2, (String)"copyOf(...)");
            Coordinate[] copy = coordinateArray2;
            int n2 = copy.length;
            for (int i = 0; i < n2; ++i) {
                Coordinate coordinate = array[i];
                if (coordinate != null && !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(coordinate.getClass()), (Object)type)) {
                    Coordinate duplicate = Coordinates.INSTANCE.create(dimension, measures);
                    duplicate.setCoordinate(coordinate);
                    copy[i] = duplicate;
                    continue;
                }
                copy[i] = coordinate;
            }
            coordinateArray = copy;
        }
        return coordinateArray;
    }

    public final boolean isRing(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        if (pts.length < 4) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    @JvmStatic
    @Nullable
    public static final Coordinate ptNotInList(@NotNull Coordinate[] testPts, @NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)testPts, (String)"testPts");
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        for (Coordinate testPt : testPts) {
            if (INSTANCE.indexOf(testPt, pts) >= 0) continue;
            return testPt;
        }
        return null;
    }

    public final int compare(@Nullable Coordinate[] pts1, @Nullable Coordinate[] pts2) {
        int i = 0;
        while (true) {
            Intrinsics.checkNotNull((Object)pts1);
            if (i >= pts1.length) break;
            Intrinsics.checkNotNull((Object)pts2);
            if (i >= pts2.length) break;
            Coordinate coordinate = pts1[i];
            Coordinate coordinate2 = pts2[i];
            Intrinsics.checkNotNull((Object)coordinate2);
            int compare = coordinate.compareTo(coordinate2);
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        Intrinsics.checkNotNull((Object)pts2);
        if (i < pts2.length) {
            return -1;
        }
        return i < pts1.length ? 1 : 0;
    }

    public final int increasingDirection(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int n = pts.length / 2;
        for (int i = 0; i < n; ++i) {
            int j = pts.length - 1 - i;
            int comp = pts[i].compareTo(pts[j]);
            if (comp == 0) continue;
            return comp;
        }
        return 1;
    }

    private final boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        int n = pts1.length;
        for (int i = 0; i < n; ++i) {
            Coordinate p1 = pts1[i];
            Coordinate p2 = pts2[pts1.length - i - 1];
            if (p1.compareTo(p2) == 0) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final Coordinate[] copyDeep(@NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Object[] copy = new Coordinate[coordinates.length];
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            copy[i] = coordinates[i].copy();
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])copy);
    }

    public final void copyDeep(@NotNull Coordinate[] src, int srcStart, @NotNull Coordinate[] dest, int destStart, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        for (int i = 0; i < length; ++i) {
            dest[destStart + i] = src[srcStart + i].copy();
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Coordinate[] toCoordinateArray(@NotNull Collection<?> coordList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(coordList, (String)"coordList");
        Iterable $this$map$iv = coordList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            collection.add((Coordinate)it);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    public final boolean hasRepeatedPoints(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int n = coord.length;
        for (int i = 1; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)coord[i - 1], (Object)coord[i])) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Coordinate[] atLeastNCoordinatesOrNothing(int n, @NotNull Coordinate[] c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return c.length >= n ? c : new Coordinate[]{};
    }

    @NotNull
    public final Coordinate[] removeRepeatedPoints(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (!this.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public final boolean hasRepeatedOrInvalidPoints(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int n = coord.length;
        for (int i = 1; i < n; ++i) {
            if (!coord[i].isValid()) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)coord[i - 1], (Object)coord[i])) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final Coordinate[] removeRepeatedOrInvalidPoints(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (!this.hasRepeatedOrInvalidPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList();
        int n = coord.length;
        for (int i = 0; i < n; ++i) {
            if (!coord[i].isValid()) continue;
            coordList.add(coord[i], false);
        }
        return coordList.toCoordinateArray();
    }

    @NotNull
    public final Coordinate[] removeNull(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        int nonNull = 0;
        int n = coord.length;
        for (int i = 0; i < n; ++i) {
            if (coord[i] == null) continue;
            ++nonNull;
        }
        Coordinate[] newCoord = new Coordinate[nonNull];
        if (nonNull == 0) {
            return newCoord;
        }
        int j = 0;
        int n2 = coord.length;
        for (int i = 0; i < n2; ++i) {
            if (coord[i] == null) continue;
            newCoord[j++] = coord[i];
        }
        return newCoord;
    }

    @JvmStatic
    public static final void reverse(@NotNull Coordinate[] coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        if (coord.length <= 1) {
            return;
        }
        int i = 0;
        int last = coord.length - 1;
        int mid = last / 2;
        if (i <= mid) {
            while (true) {
                Coordinate tmp = coord[i];
                coord[i] = coord[last - i];
                coord[last - i] = tmp;
                if (i == mid) break;
                ++i;
            }
        }
    }

    @JvmStatic
    public static final boolean equals(@Nullable Coordinate[] coord1, @Nullable Coordinate[] coord2) {
        if (Intrinsics.areEqual((Object)coord1, (Object)coord2)) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int n = coord1.length;
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)coord1[i], (Object)coord2[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(@Nullable Coordinate[] coord1, @Nullable Coordinate[] coord2, @NotNull Comparator<Coordinate> coordinateComparator) {
        Intrinsics.checkNotNullParameter(coordinateComparator, (String)"coordinateComparator");
        if (Intrinsics.areEqual((Object)coord1, (Object)coord2)) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        int n = coord1.length;
        for (int i = 0; i < n; ++i) {
            if (coordinateComparator.compare(coord1[i], coord2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final Coordinate minCoordinate(@NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Coordinate minCoord = null;
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            if (minCoord != null && minCoord.compareTo(coordinates[i]) <= 0) continue;
            minCoord = coordinates[i];
        }
        return minCoord;
    }

    public final void scroll(@NotNull Coordinate[] coordinates, @NotNull Coordinate firstCoordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)firstCoordinate, (String)"firstCoordinate");
        int i = this.indexOf(firstCoordinate, coordinates);
        CoordinateArrays.scroll$default(coordinates, i, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    public static final void scroll(@NotNull Coordinate[] coordinates, int indexOfFirstCoordinate, boolean ensureRing) {
        void src$iv;
        void this_$iv;
        int size$iv;
        int srcPos$iv;
        int dstPos$iv;
        Object[] dst$iv;
        boolean $i$f$arraycopy;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        if (indexOfFirstCoordinate <= 0) {
            return;
        }
        Object[] newCoordinates = new Coordinate[coordinates.length];
        if (!ensureRing) {
            Object[] src$iv2;
            System this_$iv2;
            System system = System.INSTANCE;
            Coordinate[] coordinateArray = coordinates;
            int n = indexOfFirstCoordinate;
            Object[] objectArray = newCoordinates;
            boolean bl = false;
            int n2 = coordinates.length - indexOfFirstCoordinate;
            $i$f$arraycopy = false;
            System $this$arraycopy_u24lambda_u240$iv = this_$iv2;
            boolean bl2 = false;
            ArraysKt.copyInto((Object[])src$iv2, (Object[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
            this_$iv2 = System.INSTANCE;
            src$iv2 = coordinates;
            srcPos$iv = 0;
            dst$iv = newCoordinates;
            dstPos$iv = coordinates.length - indexOfFirstCoordinate;
            size$iv = indexOfFirstCoordinate;
            $i$f$arraycopy = false;
            $this$arraycopy_u24lambda_u240$iv = this_$iv2;
            bl2 = false;
            ArraysKt.copyInto((Object[])src$iv2, (Object[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
        } else {
            int last = coordinates.length - 1;
            for (int j = 0; j < last; ++j) {
                newCoordinates[j] = coordinates[(indexOfFirstCoordinate + j) % last];
            }
            Coordinate coordinate = newCoordinates[0];
            Intrinsics.checkNotNull((Object)coordinate);
            newCoordinates[j] = coordinate.copy();
        }
        System last = System.INSTANCE;
        Object[] j = ArraysKt.requireNoNulls((Object[])newCoordinates);
        srcPos$iv = 0;
        dst$iv = coordinates;
        dstPos$iv = 0;
        size$iv = coordinates.length;
        $i$f$arraycopy = false;
        void $this$arraycopy_u24lambda_u241$iv = this_$iv;
        boolean bl = false;
        ArraysKt.copyInto((Object[])src$iv, (Object[])dst$iv, (int)dstPos$iv, (int)srcPos$iv, (int)(srcPos$iv + size$iv));
    }

    public static /* synthetic */ void scroll$default(Coordinate[] coordinateArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = INSTANCE.isRing(coordinateArray);
        }
        CoordinateArrays.scroll(coordinateArray, n, bl);
    }

    public final int indexOf(@NotNull Coordinate coordinate, @NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)coordinate, (Object)coordinates[i])) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public final Coordinate[] extract(@NotNull Coordinate[] pts, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        int start2 = start;
        int end2 = end;
        start2 = MathUtil.INSTANCE.clamp(start2, 0, pts.length);
        end2 = MathUtil.INSTANCE.clamp(end2, -1, pts.length);
        int npts = end2 - start2 + 1;
        if (end2 < 0) {
            npts = 0;
        }
        if (start2 >= pts.length) {
            npts = 0;
        }
        if (end2 < start2) {
            npts = 0;
        }
        Object[] extractPts = new Coordinate[npts];
        if (npts == 0) {
            return new Coordinate[0];
        }
        int iPts = 0;
        int i = start2;
        int n = end2;
        if (i <= n) {
            while (true) {
                extractPts[iPts++] = pts[i];
                if (i == n) break;
                ++i;
            }
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])extractPts);
    }

    @JvmStatic
    @NotNull
    public static final Envelope envelope(@NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Envelope env = new Envelope();
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            env.expandToInclude(coordinates[i]);
        }
        return env;
    }

    @JvmStatic
    @NotNull
    public static final Coordinate[] intersection(@NotNull Coordinate[] coordinates, @NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        CoordinateList coordList = new CoordinateList();
        int n = coordinates.length;
        for (int i = 0; i < n; ++i) {
            if (!env.intersects(coordinates[i])) continue;
            coordList.add(coordinates[i], true);
        }
        return coordList.toCoordinateArray();
    }

    @JvmStatic
    @JvmOverloads
    public static final void scroll(@NotNull Coordinate[] coordinates, int indexOfFirstCoordinate) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        CoordinateArrays.scroll$default(coordinates, indexOfFirstCoordinate, false, 4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/geom/CoordinateArrays$BidirectionalComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "OLDcompare", "kts-core"})
    public static final class BidirectionalComparator
    implements Comparator<Object> {
        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            Intrinsics.checkNotNull((Object)pts1);
            int n = pts1.length;
            Intrinsics.checkNotNull((Object)pts2);
            if (n < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = INSTANCE.compare(pts1, pts2);
            boolean isEqualRev = INSTANCE.isEqualReversed(pts1, pts2);
            return isEqualRev ? 0 : forwardComp;
        }

        public final int OLDcompare(@NotNull Object o1, @NotNull Object o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = INSTANCE.increasingDirection(pts1);
            int dir2 = INSTANCE.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            int n = pts1.length;
            for (int i = 0; i < n; ++i) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
            }
            return 0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/CoordinateArrays$ForwardComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "kts-core"})
    public static final class ForwardComparator
    implements Comparator<Object> {
        @Override
        public int compare(@Nullable Object o1, @Nullable Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return INSTANCE.compare(pts1, pts2);
        }
    }
}

