/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\r\u001a\u00020\bH\u0096\u0082\u0004J\f\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/geom/GeometryCollectionIterator;", "", "", "parent", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "atStart", "", "max", "", "index", "subcollectionIterator", "hasNext", "next", "remove", "", "Companion", "kts-core"})
public final class GeometryCollectionIterator
implements Iterator<Object>,
KMutableIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry parent;
    private boolean atStart;
    private final int max;
    private int index;
    @Nullable
    private GeometryCollectionIterator subcollectionIterator;

    public GeometryCollectionIterator(@NotNull Geometry parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.parent = parent;
        this.atStart = true;
        this.index = 0;
        this.max = parent.getNumGeometries();
    }

    @Override
    public boolean hasNext() {
        if (this.atStart) {
            return true;
        }
        if (this.subcollectionIterator != null) {
            GeometryCollectionIterator geometryCollectionIterator = this.subcollectionIterator;
            Intrinsics.checkNotNull((Object)geometryCollectionIterator);
            if (geometryCollectionIterator.hasNext()) {
                return true;
            }
            this.subcollectionIterator = null;
        }
        return this.index < this.max;
    }

    @Override
    @Nullable
    public Object next() {
        if (this.atStart) {
            this.atStart = false;
            if (GeometryCollectionIterator.Companion.isAtomic(this.parent)) {
                int n = this.index;
                this.index = n + 1;
            }
            return this.parent;
        }
        if (this.subcollectionIterator != null) {
            GeometryCollectionIterator geometryCollectionIterator = this.subcollectionIterator;
            Intrinsics.checkNotNull((Object)geometryCollectionIterator);
            if (geometryCollectionIterator.hasNext()) {
                GeometryCollectionIterator geometryCollectionIterator2 = this.subcollectionIterator;
                Intrinsics.checkNotNull((Object)geometryCollectionIterator2);
                return geometryCollectionIterator2.next();
            }
            this.subcollectionIterator = null;
        }
        if (this.index >= this.max) {
            throw new NoSuchElementException();
        }
        int n = this.index;
        this.index = n + 1;
        Geometry obj = this.parent.getGeometryN(n);
        if (obj instanceof GeometryCollection) {
            GeometryCollectionIterator geometryCollectionIterator = this.subcollectionIterator = new GeometryCollectionIterator(obj);
            Intrinsics.checkNotNull((Object)geometryCollectionIterator);
            return geometryCollectionIterator.next();
        }
        return obj;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geom/GeometryCollectionIterator$Companion;", "", "<init>", "()V", "isAtomic", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAtomic(Geometry geom) {
            return !(geom instanceof GeometryCollection);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

