/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.prep.PreparedPolygonPredicate;
import org.locationtech.jts.noding.FastSegmentSetIntersectionFinder;
import org.locationtech.jts.noding.SegmentIntersectionDetector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SegmentStringUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0018\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/geom/prep/AbstractPreparedPolygonContains;", "Lorg/locationtech/jts/geom/prep/PreparedPolygonPredicate;", "prepPoly", "Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "<init>", "(Lorg/locationtech/jts/geom/prep/PreparedPolygon;)V", "requireSomePointInInterior", "", "getRequireSomePointInInterior", "()Z", "setRequireSomePointInInterior", "(Z)V", "hasSegmentIntersection", "hasProperIntersection", "hasNonProperIntersection", "eval", "geom", "Lorg/locationtech/jts/geom/Geometry;", "evalPoints", "isProperIntersectionImpliesNotContainedSituation", "testGeom", "isSingleShell", "findAndClassifyIntersections", "", "fullTopologicalPredicate", "kts-core"})
public abstract class AbstractPreparedPolygonContains
extends PreparedPolygonPredicate {
    private boolean requireSomePointInInterior;
    private boolean hasSegmentIntersection;
    private boolean hasProperIntersection;
    private boolean hasNonProperIntersection;

    public AbstractPreparedPolygonContains(@NotNull PreparedPolygon prepPoly) {
        Intrinsics.checkNotNullParameter((Object)prepPoly, (String)"prepPoly");
        super(prepPoly);
        this.requireSomePointInInterior = true;
    }

    protected final boolean getRequireSomePointInInterior() {
        return this.requireSomePointInInterior;
    }

    protected final void setRequireSomePointInInterior(boolean bl) {
        this.requireSomePointInInterior = bl;
    }

    protected final boolean eval(@NotNull Geometry geom) {
        boolean isTargetInTestArea;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (geom.getDimension() == 0) {
            return this.evalPoints(geom);
        }
        boolean isAllInTargetArea = this.isAllTestComponentsInTarget(geom);
        if (!isAllInTargetArea) {
            return false;
        }
        boolean properIntersectionImpliesNotContained = this.isProperIntersectionImpliesNotContainedSituation(geom);
        this.findAndClassifyIntersections(geom);
        if (properIntersectionImpliesNotContained && this.hasProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection && !this.hasNonProperIntersection) {
            return false;
        }
        if (this.hasSegmentIntersection) {
            return this.fullTopologicalPredicate(geom);
        }
        return !(geom instanceof Polygonal) || !(isTargetInTestArea = this.isAnyTargetComponentInAreaTest(geom, this.getPrepPoly().getRepresentativePoints()));
    }

    private final boolean evalPoints(Geometry geom) {
        boolean isAllInTargetArea = this.isAllTestPointsInTarget(geom);
        if (!isAllInTargetArea) {
            return false;
        }
        return this.requireSomePointInInterior ? this.isAnyTestPointInTargetInterior(geom) : true;
    }

    private final boolean isProperIntersectionImpliesNotContainedSituation(Geometry testGeom) {
        if (testGeom instanceof Polygonal) {
            return true;
        }
        return this.isSingleShell(this.getPrepPoly().getGeometry());
    }

    private final boolean isSingleShell(Geometry geom) {
        if (geom.getNumGeometries() != 1) {
            return false;
        }
        Geometry geometry = geom.getGeometryN(0);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
        Polygon poly = (Polygon)geometry;
        int numHoles = poly.getNumInteriorRing();
        return numHoles == 0;
    }

    private final void findAndClassifyIntersections(Geometry geom) {
        List<SegmentString> lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        SegmentIntersectionDetector intDetector = new SegmentIntersectionDetector(null, 1, null);
        intDetector.setFindAllIntersectionTypes(true);
        FastSegmentSetIntersectionFinder fastSegmentSetIntersectionFinder = this.getPrepPoly().getIntersectionFinder();
        Intrinsics.checkNotNull((Object)fastSegmentSetIntersectionFinder);
        fastSegmentSetIntersectionFinder.intersects((Collection)lineSegStr, intDetector);
        this.hasSegmentIntersection = intDetector.hasIntersection();
        this.hasProperIntersection = intDetector.hasProperIntersection();
        this.hasNonProperIntersection = intDetector.hasNonProperIntersection();
    }

    protected abstract boolean fullTopologicalPredicate(@Nullable Geometry var1);
}

