/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.BasicPreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedPolygonContains;
import org.locationtech.jts.geom.prep.PreparedPolygonContainsProperly;
import org.locationtech.jts.geom.prep.PreparedPolygonCovers;
import org.locationtech.jts.geom.prep.PreparedPolygonIntersects;
import org.locationtech.jts.legacy.Synchronized;
import org.locationtech.jts.noding.FastSegmentSetIntersectionFinder;
import org.locationtech.jts.noding.SegmentStringUtil;
import org.locationtech.jts.operation.predicate.RectangleContains;
import org.locationtech.jts.operation.predicate.RectangleIntersects;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0012\u0010\u0016\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0017\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\t8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/geom/prep/PreparedPolygon;", "Lorg/locationtech/jts/geom/prep/BasicPreparedGeometry;", "poly", "Lorg/locationtech/jts/geom/Polygonal;", "<init>", "(Lorg/locationtech/jts/geom/Polygonal;)V", "isRectangle", "", "segIntFinder", "Lorg/locationtech/jts/noding/FastSegmentSetIntersectionFinder;", "pia", "Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "intersectionFinder", "getIntersectionFinder", "()Lorg/locationtech/jts/noding/FastSegmentSetIntersectionFinder;", "pointLocator", "getPointLocator", "()Lorg/locationtech/jts/algorithm/locate/PointOnGeometryLocator;", "intersects", "g", "Lorg/locationtech/jts/geom/Geometry;", "contains", "containsProperly", "covers", "kts-core"})
public final class PreparedPolygon
extends BasicPreparedGeometry {
    private final boolean isRectangle;
    @Nullable
    private FastSegmentSetIntersectionFinder segIntFinder;
    @Nullable
    private PointOnGeometryLocator pia;

    public PreparedPolygon(@NotNull Polygonal poly) {
        Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
        super((Geometry)((Object)poly));
        this.isRectangle = this.getGeometry().isRectangle();
    }

    @Synchronized
    @Nullable
    public final FastSegmentSetIntersectionFinder getIntersectionFinder() {
        if (this.segIntFinder == null) {
            this.segIntFinder = new FastSegmentSetIntersectionFinder((Collection)SegmentStringUtil.extractSegmentStrings(this.getGeometry()));
        }
        return this.segIntFinder;
    }

    @Synchronized
    @NotNull
    public final PointOnGeometryLocator getPointLocator() {
        if (this.pia == null) {
            this.pia = new IndexedPointInAreaLocator(this.getGeometry());
        }
        PointOnGeometryLocator pointOnGeometryLocator = this.pia;
        Intrinsics.checkNotNull((Object)pointOnGeometryLocator);
        return pointOnGeometryLocator;
    }

    @Override
    public boolean intersects(@NotNull Geometry g) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.envelopesIntersect(g)) {
            return false;
        }
        if (this.isRectangle) {
            Polygon polygon = (Polygon)this.getGeometry();
            Intrinsics.checkNotNull((Object)polygon);
            bl = RectangleIntersects.Companion.intersects(polygon, g);
        } else {
            bl = PreparedPolygonIntersects.Companion.intersects(this, g);
        }
        return bl;
    }

    @Override
    public boolean contains(@Nullable Geometry g) {
        boolean bl;
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        if (!this.envelopeCovers(geometry)) {
            return false;
        }
        if (this.isRectangle) {
            Polygon polygon = (Polygon)this.getGeometry();
            Intrinsics.checkNotNull((Object)polygon);
            bl = RectangleContains.Companion.contains(polygon, g);
        } else {
            bl = PreparedPolygonContains.Companion.contains(this, g);
        }
        return bl;
    }

    @Override
    public boolean containsProperly(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        return !this.envelopeCovers(geometry) ? false : PreparedPolygonContainsProperly.Companion.containsProperly(this, g);
    }

    @Override
    public boolean covers(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        if (!this.envelopeCovers(geometry)) {
            return false;
        }
        return this.isRectangle ? true : PreparedPolygonCovers.Companion.covers(this, g);
    }
}

