/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Position;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.Label;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u0016\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020*2\u0006\u0010.\u001a\u00020*J\u000e\u00102\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u0005J\b\u00105\u001a\u00020-H\u0002J\u0016\u00106\u001a\u00020-2\u0006\u0010+\u001a\u00020*2\u0006\u0010'\u001a\u00020*R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00103\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\fR\u0011\u00104\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\f\u00a8\u00068"}, d2={"Lorg/locationtech/jts/geomgraph/DirectedEdge;", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "isForward", "", "<init>", "(Lorg/locationtech/jts/geomgraph/Edge;Z)V", "getEdge", "()Lorg/locationtech/jts/geomgraph/Edge;", "setEdge", "(Lorg/locationtech/jts/geomgraph/Edge;)V", "()Z", "setForward", "(Z)V", "isInResult", "setInResult", "isVisited", "setVisited", "sym", "getSym", "()Lorg/locationtech/jts/geomgraph/DirectedEdge;", "setSym", "(Lorg/locationtech/jts/geomgraph/DirectedEdge;)V", "next", "getNext", "setNext", "nextMin", "getNextMin", "setNextMin", "edgeRing", "Lorg/locationtech/jts/geomgraph/EdgeRing;", "getEdgeRing", "()Lorg/locationtech/jts/geomgraph/EdgeRing;", "setEdgeRing", "(Lorg/locationtech/jts/geomgraph/EdgeRing;)V", "minEdgeRing", "getMinEdgeRing", "setMinEdgeRing", "depth", "", "getDepth", "", "position", "setDepth", "", "depthVal", "depthDelta", "getDepthDelta", "()I", "setVisitedEdge", "isLineEdge", "isInteriorAreaEdge", "computeDirectedLabel", "setEdgeDepths", "Companion", "kts-core"})
public final class DirectedEdge
extends EdgeEnd {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Edge edge;
    private boolean isForward;
    private boolean isInResult;
    private boolean isVisited;
    @Nullable
    private DirectedEdge sym;
    @Nullable
    private DirectedEdge next;
    @Nullable
    private DirectedEdge nextMin;
    @Nullable
    private EdgeRing edgeRing;
    @Nullable
    private EdgeRing minEdgeRing;
    @NotNull
    private final int[] depth;

    public DirectedEdge(@NotNull Edge edge, boolean isForward) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        super(edge);
        this.edge = edge;
        this.isForward = isForward;
        int[] nArray = new int[]{0, -999, -999};
        this.depth = nArray;
        if (this.isForward) {
            this.init(this.getEdge().getCoordinate(0), this.getEdge().getCoordinate(1));
        } else {
            int n = this.getEdge().getNumPoints() - 1;
            this.init(this.getEdge().getCoordinate(n), this.getEdge().getCoordinate(n - 1));
        }
        this.computeDirectedLabel();
    }

    @Override
    @NotNull
    public Edge getEdge() {
        return this.edge;
    }

    @Override
    public void setEdge(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"<set-?>");
        this.edge = edge;
    }

    public final boolean isForward() {
        return this.isForward;
    }

    public final void setForward(boolean bl) {
        this.isForward = bl;
    }

    public final boolean isInResult() {
        return this.isInResult;
    }

    public final void setInResult(boolean bl) {
        this.isInResult = bl;
    }

    public final boolean isVisited() {
        return this.isVisited;
    }

    public final void setVisited(boolean bl) {
        this.isVisited = bl;
    }

    @Nullable
    public final DirectedEdge getSym() {
        return this.sym;
    }

    public final void setSym(@Nullable DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    @Nullable
    public final DirectedEdge getNext() {
        return this.next;
    }

    public final void setNext(@Nullable DirectedEdge directedEdge) {
        this.next = directedEdge;
    }

    @Nullable
    public final DirectedEdge getNextMin() {
        return this.nextMin;
    }

    public final void setNextMin(@Nullable DirectedEdge directedEdge) {
        this.nextMin = directedEdge;
    }

    @Nullable
    public final EdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public final void setEdgeRing(@Nullable EdgeRing edgeRing) {
        this.edgeRing = edgeRing;
    }

    @Nullable
    public final EdgeRing getMinEdgeRing() {
        return this.minEdgeRing;
    }

    public final void setMinEdgeRing(@Nullable EdgeRing edgeRing) {
        this.minEdgeRing = edgeRing;
    }

    public final int getDepth(int position) {
        return this.depth[position];
    }

    public final void setDepth(int position, int depthVal) {
        if (this.depth[position] != -999 && this.depth[position] != depthVal) {
            throw new TopologyException("assigned depths do not match", this.getCoordinate());
        }
        this.depth[position] = depthVal;
    }

    public final int getDepthDelta() {
        int depthDelta = this.getEdge().getDepthDelta();
        if (!this.isForward) {
            depthDelta = -depthDelta;
        }
        return depthDelta;
    }

    public final void setVisitedEdge(boolean isVisited) {
        this.isVisited = isVisited;
        Intrinsics.checkNotNull((Object)this.sym);
        this.sym.isVisited = isVisited;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isLineEdge() {
        v0 = this.getLabel();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.isLine(0)) ** GOTO lbl-1000
        v1 = this.getLabel();
        Intrinsics.checkNotNull((Object)v1);
        if (v1.isLine(1)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        isLine = v2;
        v3 = this.getLabel();
        Intrinsics.checkNotNull((Object)v3);
        if (!v3.isArea(0)) ** GOTO lbl-1000
        v4 = this.getLabel();
        Intrinsics.checkNotNull((Object)v4);
        if (v4.allPositionsEqual(0, 2)) lbl-1000:
        // 2 sources

        {
            v5 = true;
        } else {
            v5 = false;
        }
        isExteriorIfArea0 = v5;
        v6 = this.getLabel();
        Intrinsics.checkNotNull((Object)v6);
        if (!v6.isArea(1)) ** GOTO lbl-1000
        v7 = this.getLabel();
        Intrinsics.checkNotNull((Object)v7);
        if (v7.allPositionsEqual(1, 2)) lbl-1000:
        // 2 sources

        {
            v8 = true;
        } else {
            v8 = false;
        }
        isExteriorIfArea1 = v8;
        return isLine != false && isExteriorIfArea0 != false && isExteriorIfArea1 != false;
    }

    public final boolean isInteriorAreaEdge() {
        boolean isInteriorAreaEdge = true;
        for (int i = 0; i < 2; ++i) {
            Label label = this.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (label.isArea(i)) {
                Label label2 = this.getLabel();
                Intrinsics.checkNotNull((Object)label2);
                if (label2.getLocation(i, 1) == 0) {
                    Label label3 = this.getLabel();
                    Intrinsics.checkNotNull((Object)label3);
                    if (label3.getLocation(i, 2) == 0) continue;
                }
            }
            isInteriorAreaEdge = false;
        }
        return isInteriorAreaEdge;
    }

    private final void computeDirectedLabel() {
        Label label = this.getEdge().getLabel();
        Intrinsics.checkNotNull((Object)label);
        this.setLabel(new Label(label));
        if (!this.isForward) {
            Label label2 = this.getLabel();
            Intrinsics.checkNotNull((Object)label2);
            label2.flip();
        }
    }

    public final void setEdgeDepths(int position, int depth) {
        int depthDelta = this.getEdge().getDepthDelta();
        if (!this.isForward) {
            depthDelta = -depthDelta;
        }
        int directionFactor = 1;
        if (position == 1) {
            directionFactor = -1;
        }
        int oppositePos = Position.INSTANCE.opposite(position);
        int delta = depthDelta * directionFactor;
        int oppositeDepth = depth + delta;
        this.setDepth(position, depth);
        this.setDepth(oppositePos, oppositeDepth);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/geomgraph/DirectedEdge$Companion;", "", "<init>", "()V", "depthFactor", "", "currLocation", "nextLocation", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int depthFactor(int currLocation, int nextLocation) {
            if (currLocation == 2 && nextLocation == 0) {
                return 1;
            }
            if (currLocation == 0 && nextLocation == 2) {
                return -1;
            }
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

