/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.Depth;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.EdgeIntersectionList;
import org.locationtech.jts.geomgraph.GraphComponent;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.index.MonotoneChainEdge;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 H2\u00020\u0001:\u0001HB#\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010'\u001a\u00020&J\u0010\u0010(\u001a\u00020)2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0011\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020&J\n\u0010+\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010-\u001a\u00020\u0013J\u0006\u0010.\u001a\u00020$J\u0006\u0010/\u001a\u00020&J\u000e\u00100\u001a\u00020)2\u0006\u0010%\u001a\u00020&J\u0006\u00101\u001a\u00020&J\u0006\u00102\u001a\u00020\u0015J\u0006\u00103\u001a\u00020\u001dJ\u0006\u00104\u001a\u00020\u001fJ\u0006\u00105\u001a\u00020\u001fJ\u0006\u00106\u001a\u00020\u0000J\u001e\u00107\u001a\u00020)2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020&J&\u0010<\u001a\u00020)2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020&2\u0006\u0010=\u001a\u00020&J\u0010\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020@H\u0014J\u0014\u0010A\u001a\u00020\u001f2\b\u0010B\u001a\u0004\u0018\u00010CH\u0096\u0082\u0004J\n\u0010D\u001a\u00020&H\u0096\u0080\u0004J\u000e\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u0000J\n\u0010G\u001a\u00020\u001bH\u0096\u0080\u0004R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/locationtech/jts/geomgraph/Edge;", "Lorg/locationtech/jts/geomgraph/GraphComponent;", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "label", "Lorg/locationtech/jts/geomgraph/Label;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geomgraph/Label;)V", "getPts", "()[Lorg/locationtech/jts/geom/Coordinate;", "setPts", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "getLabel", "()Lorg/locationtech/jts/geomgraph/Label;", "setLabel", "(Lorg/locationtech/jts/geomgraph/Label;)V", "env", "Lorg/locationtech/jts/geom/Envelope;", "eiList", "Lorg/locationtech/jts/geomgraph/EdgeIntersectionList;", "getEiList", "()Lorg/locationtech/jts/geomgraph/EdgeIntersectionList;", "setEiList", "(Lorg/locationtech/jts/geomgraph/EdgeIntersectionList;)V", "name", "", "mce", "Lorg/locationtech/jts/geomgraph/index/MonotoneChainEdge;", "isIsolated", "", "()Z", "setIsolated", "(Z)V", "depth", "Lorg/locationtech/jts/geomgraph/Depth;", "depthDelta", "", "getNumPoints", "setName", "", "getCoordinates", "getCoordinate", "i", "getEnvelope", "getDepth", "getDepthDelta", "setDepthDelta", "getMaximumSegmentIndex", "getEdgeIntersectionList", "getMonotoneChainEdge", "isClosed", "isCollapsed", "getCollapsedEdge", "addIntersections", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "segmentIndex", "geomIndex", "addIntersection", "intIndex", "computeIM", "im", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "equals", "o", "", "hashCode", "isPointwiseEqual", "e", "toString", "Companion", "kts-core"})
public final class Edge
extends GraphComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Coordinate[] pts;
    @Nullable
    private Label label;
    @Nullable
    private Envelope env;
    @NotNull
    private EdgeIntersectionList eiList;
    @Nullable
    private String name;
    @Nullable
    private MonotoneChainEdge mce;
    private boolean isIsolated;
    @NotNull
    private final Depth depth;
    private int depthDelta;

    @JvmOverloads
    public Edge(@NotNull Coordinate[] pts, @Nullable Label label) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.label = label;
        this.eiList = new EdgeIntersectionList(this);
        this.isIsolated = true;
        this.depth = new Depth();
    }

    public /* synthetic */ Edge(Coordinate[] coordinateArray, Label label, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            label = null;
        }
        this(coordinateArray, label);
    }

    @NotNull
    public final Coordinate[] getPts() {
        return this.pts;
    }

    public final void setPts(@NotNull Coordinate[] coordinateArray) {
        Intrinsics.checkNotNullParameter((Object)coordinateArray, (String)"<set-?>");
        this.pts = coordinateArray;
    }

    @Override
    @Nullable
    public Label getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(@Nullable Label label) {
        this.label = label;
    }

    @NotNull
    public final EdgeIntersectionList getEiList() {
        return this.eiList;
    }

    public final void setEiList(@NotNull EdgeIntersectionList edgeIntersectionList) {
        Intrinsics.checkNotNullParameter((Object)edgeIntersectionList, (String)"<set-?>");
        this.eiList = edgeIntersectionList;
    }

    @Override
    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void setIsolated(boolean bl) {
        this.isIsolated = bl;
    }

    public final int getNumPoints() {
        return this.pts.length;
    }

    public final void setName(@Nullable String name) {
        this.name = name;
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.pts;
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    @Override
    @Nullable
    public Coordinate getCoordinate() {
        return !(this.pts.length == 0) ? this.pts[0] : null;
    }

    @NotNull
    public final Envelope getEnvelope() {
        if (this.env == null) {
            this.env = new Envelope();
            int n = this.pts.length;
            for (int i = 0; i < n; ++i) {
                Envelope envelope = this.env;
                Intrinsics.checkNotNull((Object)envelope);
                envelope.expandToInclude(this.pts[i]);
            }
        }
        Envelope envelope = this.env;
        Intrinsics.checkNotNull((Object)envelope);
        return envelope;
    }

    @NotNull
    public final Depth getDepth() {
        return this.depth;
    }

    public final int getDepthDelta() {
        return this.depthDelta;
    }

    public final void setDepthDelta(int depthDelta) {
        this.depthDelta = depthDelta;
    }

    public final int getMaximumSegmentIndex() {
        return this.pts.length - 1;
    }

    @NotNull
    public final EdgeIntersectionList getEdgeIntersectionList() {
        return this.eiList;
    }

    @NotNull
    public final MonotoneChainEdge getMonotoneChainEdge() {
        if (this.mce == null) {
            this.mce = new MonotoneChainEdge(this);
        }
        MonotoneChainEdge monotoneChainEdge = this.mce;
        Intrinsics.checkNotNull((Object)monotoneChainEdge);
        return monotoneChainEdge;
    }

    public final boolean isClosed() {
        return Intrinsics.areEqual((Object)this.pts[0], (Object)this.pts[this.pts.length - 1]);
    }

    public final boolean isCollapsed() {
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        if (!label.isArea()) {
            return false;
        }
        if (this.pts.length != 3) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pts[0], (Object)this.pts[2]);
    }

    @NotNull
    public final Edge getCollapsedEdge() {
        Object[] newPts = new Coordinate[]{this.pts[0], this.pts[1]};
        Coordinate[] coordinateArray = (Coordinate[])ArraysKt.requireNoNulls((Object[])newPts);
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        return new Edge(coordinateArray, Label.Companion.toLineLabel(label));
    }

    public final void addIntersections(@NotNull LineIntersector li, int segmentIndex, int geomIndex) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        int n = li.getIntersectionNum();
        for (int i = 0; i < n; ++i) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
        }
    }

    public final void addIntersection(@NotNull LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate nextPt;
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        int normalizedSegmentIndex = segmentIndex;
        double dist = li.getEdgeDistance(geomIndex, intIndex);
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
            dist = 0.0;
        }
        EdgeIntersection ei = this.eiList.add(intPt, normalizedSegmentIndex, dist);
    }

    @Override
    protected void computeIM(@NotNull IntersectionMatrix im) {
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Companion.updateIM(label, im);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Object e = o;
        if (this.pts.length != ((Edge)e).pts.length) {
            return false;
        }
        boolean isEqualForward = true;
        boolean isEqualReverse = true;
        int iRev = this.pts.length;
        int n = this.pts.length;
        for (int i = 0; i < n; ++i) {
            if (!this.pts[i].equals2D(((Edge)e).pts[i])) {
                isEqualForward = false;
            }
            if (!this.pts[i].equals2D(((Edge)e).pts[--iRev])) {
                isEqualReverse = false;
            }
            if (isEqualForward || isEqualReverse) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = prime * result2 + this.pts.length;
        if (!(this.pts.length == 0)) {
            Coordinate p0 = this.pts[0];
            Coordinate p1 = this.pts[this.pts.length - 1];
            if (1 == p0.compareTo(p1)) {
                p0 = this.pts[this.pts.length - 1];
                p1 = this.pts[0];
            }
            result2 = prime * result2 + p0.hashCode();
            result2 = prime * result2 + p1.hashCode();
        }
        return result2;
    }

    public final boolean isPointwiseEqual(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.pts.length != e.pts.length) {
            return false;
        }
        int n = this.pts.length;
        for (int i = 0; i < n; ++i) {
            if (this.pts[i].equals2D(e.pts[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("edge " + this.name + ": ");
        builder.append("LINESTRING (");
        int n = this.pts.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(this.pts[i].x + " " + this.pts[i].y);
        }
        builder.append(")  " + this.getLabel() + " " + this.depthDelta);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public Edge(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this(pts, null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geomgraph/Edge$Companion;", "", "<init>", "()V", "updateIM", "", "label", "Lorg/locationtech/jts/geomgraph/Label;", "im", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateIM(@NotNull Label label, @NotNull IntersectionMatrix im) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)im, (String)"im");
            im.setAtLeastIfValid(label.getLocation(0, 0), label.getLocation(1, 0), 1);
            if (label.isArea()) {
                im.setAtLeastIfValid(label.getLocation(0, 1), label.getLocation(1, 1), 2);
                im.setAtLeastIfValid(label.getLocation(0, 2), label.getLocation(1, 2), 2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

