/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geomgraph.TopologyLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\nB)\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\rJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010#\u001a\u00020!J\u000e\u0010#\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u0003J\u0016\u0010%\u001a\u00020!2\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003J\u0016\u0010'\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0003J\n\u0010*\u001a\u00020+H\u0096\u0080\u0004R$\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/locationtech/jts/geomgraph/Label;", "", "onLoc", "", "<init>", "(I)V", "geomIndex", "(II)V", "leftLoc", "rightLoc", "(III)V", "(IIII)V", "lbl", "(Lorg/locationtech/jts/geomgraph/Label;)V", "elt", "", "Lorg/locationtech/jts/geomgraph/TopologyLocation;", "getElt", "()[Lorg/locationtech/jts/geomgraph/TopologyLocation;", "setElt", "([Lorg/locationtech/jts/geomgraph/TopologyLocation;)V", "[Lorg/locationtech/jts/geomgraph/TopologyLocation;", "flip", "", "getLocation", "posIndex", "setLocation", "location", "setAllLocations", "setAllLocationsIfNull", "merge", "getGeometryCount", "isNull", "", "isAnyNull", "isArea", "isLine", "isEqualOnSide", "side", "allPositionsEqual", "loc", "toLine", "toString", "", "Companion", "kts-core"})
public final class Label {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TopologyLocation[] elt;

    @NotNull
    public final TopologyLocation[] getElt() {
        return this.elt;
    }

    public final void setElt(@NotNull TopologyLocation[] topologyLocationArray) {
        Intrinsics.checkNotNullParameter((Object)topologyLocationArray, (String)"<set-?>");
        this.elt = topologyLocationArray;
    }

    public Label(int onLoc) {
        this.elt = new TopologyLocation[2];
        this.elt[0] = new TopologyLocation(onLoc);
        this.elt[1] = new TopologyLocation(onLoc);
    }

    public Label(int geomIndex, int onLoc) {
        this.elt = new TopologyLocation[2];
        this.elt[0] = new TopologyLocation(-1);
        this.elt[1] = new TopologyLocation(-1);
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setLocation(onLoc);
    }

    public Label(int onLoc, int leftLoc, int rightLoc) {
        this.elt = new TopologyLocation[2];
        this.elt[0] = new TopologyLocation(onLoc, leftLoc, rightLoc);
        this.elt[1] = new TopologyLocation(onLoc, leftLoc, rightLoc);
    }

    public Label(int geomIndex, int onLoc, int leftLoc, int rightLoc) {
        this.elt = new TopologyLocation[2];
        this.elt[0] = new TopologyLocation(-1, -1, -1);
        this.elt[1] = new TopologyLocation(-1, -1, -1);
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setLocations(onLoc, leftLoc, rightLoc);
    }

    public Label(@NotNull Label lbl) {
        Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
        this.elt = new TopologyLocation[2];
        this.elt[0] = new TopologyLocation(lbl.elt[0]);
        this.elt[1] = new TopologyLocation(lbl.elt[1]);
    }

    public final void flip() {
        TopologyLocation topologyLocation = this.elt[0];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.flip();
        TopologyLocation topologyLocation2 = this.elt[1];
        Intrinsics.checkNotNull((Object)topologyLocation2);
        topologyLocation2.flip();
    }

    public final int getLocation(int geomIndex, int posIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.get(posIndex);
    }

    public final int getLocation(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.get(0);
    }

    public final void setLocation(int geomIndex, int posIndex, int location) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setLocation(posIndex, location);
    }

    public final void setLocation(int geomIndex, int location) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setLocation(0, location);
    }

    public final void setAllLocations(int geomIndex, int location) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setAllLocations(location);
    }

    public final void setAllLocationsIfNull(int geomIndex, int location) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        topologyLocation.setAllLocationsIfNull(location);
    }

    public final void setAllLocationsIfNull(int location) {
        this.setAllLocationsIfNull(0, location);
        this.setAllLocationsIfNull(1, location);
    }

    public final void merge(@NotNull Label lbl) {
        Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
        for (int i = 0; i < 2; ++i) {
            if (this.elt[i] == null && lbl.elt[i] != null) {
                this.elt[i] = new TopologyLocation(lbl.elt[i]);
                continue;
            }
            TopologyLocation topologyLocation = this.elt[i];
            Intrinsics.checkNotNull((Object)topologyLocation);
            topologyLocation.merge(lbl.elt[i]);
        }
    }

    public final int getGeometryCount() {
        int count = 0;
        TopologyLocation topologyLocation = this.elt[0];
        Intrinsics.checkNotNull((Object)topologyLocation);
        if (!topologyLocation.isNull()) {
            ++count;
        }
        TopologyLocation topologyLocation2 = this.elt[1];
        Intrinsics.checkNotNull((Object)topologyLocation2);
        if (!topologyLocation2.isNull()) {
            ++count;
        }
        return count;
    }

    public final boolean isNull(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.isNull();
    }

    public final boolean isAnyNull(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.isAnyNull();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isArea() {
        TopologyLocation topologyLocation = this.elt[0];
        Intrinsics.checkNotNull((Object)topologyLocation);
        if (topologyLocation.isArea()) return true;
        TopologyLocation topologyLocation2 = this.elt[1];
        Intrinsics.checkNotNull((Object)topologyLocation2);
        if (!topologyLocation2.isArea()) return false;
        return true;
    }

    public final boolean isArea(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.isArea();
    }

    public final boolean isLine(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.isLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEqualOnSide(@NotNull Label lbl, int side) {
        Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
        TopologyLocation topologyLocation = this.elt[0];
        Intrinsics.checkNotNull((Object)topologyLocation);
        if (!topologyLocation.isEqualOnSide(lbl.elt[0], side)) return false;
        TopologyLocation topologyLocation2 = this.elt[1];
        Intrinsics.checkNotNull((Object)topologyLocation2);
        if (!topologyLocation2.isEqualOnSide(lbl.elt[1], side)) return false;
        return true;
    }

    public final boolean allPositionsEqual(int geomIndex, int loc) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        return topologyLocation.allPositionsEqual(loc);
    }

    public final void toLine(int geomIndex) {
        TopologyLocation topologyLocation = this.elt[geomIndex];
        Intrinsics.checkNotNull((Object)topologyLocation);
        if (topologyLocation.isArea()) {
            TopologyLocation topologyLocation2 = this.elt[geomIndex];
            Intrinsics.checkNotNull((Object)topologyLocation2);
            this.elt[geomIndex] = new TopologyLocation(topologyLocation2.getLocation()[0]);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.elt[0] != null) {
            buf.append("A:");
            buf.append(String.valueOf(this.elt[0]));
        }
        if (this.elt[1] != null) {
            buf.append(" B:");
            buf.append(String.valueOf(this.elt[1]));
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/locationtech/jts/geomgraph/Label$Companion;", "", "<init>", "()V", "toLineLabel", "Lorg/locationtech/jts/geomgraph/Label;", "label", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Label toLineLabel(@NotNull Label label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Label lineLabel = new Label(-1);
            for (int i = 0; i < 2; ++i) {
                lineLabel.setLocation(i, label.getLocation(i));
            }
            return lineLabel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

