/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeFactory;
import org.locationtech.jts.legacy.map.TreeMap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\r\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0086\u0002J\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u0012\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001e\u001a\u00020\u001fR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0005\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/geomgraph/NodeMap;", "", "nodeFact", "Lorg/locationtech/jts/geomgraph/NodeFactory;", "<init>", "(Lorg/locationtech/jts/geomgraph/NodeFactory;)V", "nodeMap", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/geomgraph/Node;", "getNodeMap", "()Ljava/util/Map;", "setNodeMap", "(Ljava/util/Map;)V", "getNodeFact", "()Lorg/locationtech/jts/geomgraph/NodeFactory;", "setNodeFact", "addNode", "coord", "n", "add", "", "e", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "find", "iterator", "", "values", "", "getBoundaryNodes", "geomIndex", "", "kts-core"})
public final class NodeMap {
    @NotNull
    private Map<Coordinate, Node> nodeMap;
    @NotNull
    private NodeFactory nodeFact;

    public NodeMap(@NotNull NodeFactory nodeFact) {
        Intrinsics.checkNotNullParameter((Object)nodeFact, (String)"nodeFact");
        this.nodeMap = new TreeMap(null, 1, null);
        this.nodeFact = nodeFact;
    }

    @NotNull
    public final Map<Coordinate, Node> getNodeMap() {
        return this.nodeMap;
    }

    public final void setNodeMap(@NotNull Map<Coordinate, Node> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.nodeMap = map;
    }

    @NotNull
    public final NodeFactory getNodeFact() {
        return this.nodeFact;
    }

    public final void setNodeFact(@NotNull NodeFactory nodeFactory) {
        Intrinsics.checkNotNullParameter((Object)nodeFactory, (String)"<set-?>");
        this.nodeFact = nodeFactory;
    }

    @NotNull
    public final Node addNode(@NotNull Coordinate coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Node node = this.nodeMap.get(coord);
        if (node == null) {
            node = this.nodeFact.createNode(coord);
            this.nodeMap.put(coord, node);
        }
        return node;
    }

    @NotNull
    public final Node addNode(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Node node = this.nodeMap.get(n.getCoordinate());
        if (node == null) {
            Coordinate coordinate = n.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            this.nodeMap.put(coordinate, n);
            return n;
        }
        node.mergeLabel(n);
        return node;
    }

    public final void add(@NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Coordinate coordinate = e.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate p = coordinate;
        Node n = this.addNode(p);
        n.add(e);
    }

    @Nullable
    public final Node find(@Nullable Coordinate coord) {
        return this.nodeMap.get(coord);
    }

    @NotNull
    public final Iterator<?> iterator() {
        return this.nodeMap.values().iterator();
    }

    @NotNull
    public final Collection<?> values() {
        return this.nodeMap.values();
    }

    @NotNull
    public final Collection<?> getBoundaryNodes(int geomIndex) {
        Collection bdyNodes = new ArrayList();
        Iterator<?> i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            Label label = node.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (label.getLocation(geomIndex) != 1) continue;
            bdyNodes.add(node);
        }
        return bdyNodes;
    }
}

