/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph.index;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.index.MonotoneChainIndexer;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J8\u0010!\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020 H\u0002J0\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lorg/locationtech/jts/geomgraph/index/MonotoneChainEdge;", "", "e", "Lorg/locationtech/jts/geomgraph/Edge;", "<init>", "(Lorg/locationtech/jts/geomgraph/Edge;)V", "getE", "()Lorg/locationtech/jts/geomgraph/Edge;", "setE", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "setCoordinates", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "startIndexes", "", "getStartIndexes", "()[I", "setStartIndexes", "([I)V", "getMinX", "", "chainIndex", "", "getMaxX", "computeIntersects", "", "mce", "si", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "computeIntersectsForChain", "chainIndex0", "chainIndex1", "start0", "end0", "start1", "end1", "ei", "overlaps", "", "kts-core"})
public final class MonotoneChainEdge {
    @NotNull
    private Edge e;
    @NotNull
    private Coordinate[] coordinates;
    @NotNull
    private int[] startIndexes;

    public MonotoneChainEdge(@NotNull Edge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.e = e;
        this.coordinates = e.getCoordinates();
        MonotoneChainIndexer mcb = new MonotoneChainIndexer();
        this.startIndexes = mcb.getChainStartIndices(this.coordinates);
    }

    @NotNull
    public final Edge getE() {
        return this.e;
    }

    public final void setE(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"<set-?>");
        this.e = edge;
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    public final void setCoordinates(@NotNull Coordinate[] coordinateArray) {
        Intrinsics.checkNotNullParameter((Object)coordinateArray, (String)"<set-?>");
        this.coordinates = coordinateArray;
    }

    @NotNull
    public final int[] getStartIndexes() {
        return this.startIndexes;
    }

    public final void setStartIndexes(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.startIndexes = nArray;
    }

    public final double getMinX(int chainIndex) {
        double x1 = this.coordinates[this.startIndexes[chainIndex]].x;
        double x2 = this.coordinates[this.startIndexes[chainIndex + 1]].x;
        return x1 < x2 ? x1 : x2;
    }

    public final double getMaxX(int chainIndex) {
        double x1 = this.coordinates[this.startIndexes[chainIndex]].x;
        double x2 = this.coordinates[this.startIndexes[chainIndex + 1]].x;
        return x1 > x2 ? x1 : x2;
    }

    public final void computeIntersects(@NotNull MonotoneChainEdge mce, @NotNull SegmentIntersector si) {
        Intrinsics.checkNotNullParameter((Object)mce, (String)"mce");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        int n = this.startIndexes.length - 1;
        for (int i = 0; i < n; ++i) {
            int n2 = mce.startIndexes.length - 1;
            for (int j = 0; j < n2; ++j) {
                this.computeIntersectsForChain(i, mce, j, si);
            }
        }
    }

    public final void computeIntersectsForChain(int chainIndex0, @NotNull MonotoneChainEdge mce, int chainIndex1, @NotNull SegmentIntersector si) {
        Intrinsics.checkNotNullParameter((Object)mce, (String)"mce");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        this.computeIntersectsForChain(this.startIndexes[chainIndex0], this.startIndexes[chainIndex0 + 1], mce, mce.startIndexes[chainIndex1], mce.startIndexes[chainIndex1 + 1], si);
    }

    private final void computeIntersectsForChain(int start0, int end0, MonotoneChainEdge mce, int start1, int end1, SegmentIntersector ei) {
        if (end0 - start0 == 1 && end1 - start1 == 1) {
            ei.addIntersections(this.e, start0, mce.e, start1);
            return;
        }
        if (!this.overlaps(start0, end0, mce, start1, end1)) {
            return;
        }
        int mid0 = (start0 + end0) / 2;
        int mid1 = (start1 + end1) / 2;
        if (start0 < mid0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(start0, mid0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(start0, mid0, mce, mid1, end1, ei);
            }
        }
        if (mid0 < end0) {
            if (start1 < mid1) {
                this.computeIntersectsForChain(mid0, end0, mce, start1, mid1, ei);
            }
            if (mid1 < end1) {
                this.computeIntersectsForChain(mid0, end0, mce, mid1, end1, ei);
            }
        }
    }

    private final boolean overlaps(int start0, int end0, MonotoneChainEdge mce, int start1, int end1) {
        return Envelope.Companion.intersects(this.coordinates[start0], this.coordinates[end0], mce.coordinates[start1], mce.coordinates[end1]);
    }
}

