/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Node;
import org.locationtech.jts.index.bintree.NodeBase;
import org.locationtech.jts.index.quadtree.IntervalSize;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/index/bintree/Root;", "Lorg/locationtech/jts/index/bintree/NodeBase;", "<init>", "()V", "insert", "", "itemInterval", "Lorg/locationtech/jts/index/bintree/Interval;", "item", "Lorg/locationtech/jts/index/bintree/Node;", "insertContained", "tree", "isSearchMatch", "", "interval", "Companion", "kts-core"})
public final class Root
extends NodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double origin = 0.0;

    public final void insert(@NotNull Interval itemInterval, @NotNull Node item) {
        int index;
        block5: {
            Node largerNode;
            Node node;
            block4: {
                Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                index = NodeBase.Companion.getSubnodeIndex(itemInterval, 0.0);
                if (index == -1) {
                    this.add(item);
                    return;
                }
                node = this.getSubnode()[index];
                if (node == null) break block4;
                Interval interval = node.getInterval();
                Intrinsics.checkNotNull((Object)interval);
                if (interval.contains(itemInterval)) break block5;
            }
            this.getSubnode()[index] = largerNode = Node.Companion.createExpanded(node, itemInterval);
        }
        Node node = this.getSubnode()[index];
        Intrinsics.checkNotNull((Object)node);
        this.insertContained(node, itemInterval, item);
    }

    private final void insertContained(Node tree, Interval itemInterval, Node item) {
        Interval interval = tree.getInterval();
        Intrinsics.checkNotNull((Object)interval);
        Assert.isTrue(interval.contains(itemInterval));
        boolean isZeroArea = IntervalSize.INSTANCE.isZeroWidth(itemInterval.getMin(), itemInterval.getMax());
        NodeBase node = isZeroArea ? tree.find(itemInterval) : (NodeBase)tree.getNode(itemInterval);
        node.add(item);
    }

    @Override
    protected boolean isSearchMatch(@Nullable Interval interval) {
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/index/bintree/Root$Companion;", "", "<init>", "()V", "origin", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

