/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.Boundable;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.legacy.Synchronized;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 D2\u00060\u0001j\u0002`\u0002:\u0002CDB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0005\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0004H$J(\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J\u0014\u0010 \u001a\u00020\b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0004J\u001e\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u0004H\u0014J\u0012\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\bH\u0004J\b\u0010(\u001a\u00020\u0004H\u0014J\u0012\u0010(\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\bH\u0004J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u001dH\u0004J\u0018\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u001dJ\u001c\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010.\u001a\u0004\u0018\u00010/H\u0004J,\u00104\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010'\u001a\u0004\u0018\u00010\b2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000bH\u0002J$\u00104\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010.\u001a\u00020/H\u0002J\n\u00106\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u0018\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\b\u0010'\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u00107\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u0010+\u001a\u00020\u001dH\u0004J\u001a\u00108\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\u001dH\u0002J$\u00107\u001a\u00020\u00142\b\u0010-\u001a\u0004\u0018\u00010\u001d2\b\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010+\u001a\u00020\u001dH\u0002J\u0014\u00109\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001a\u001a\u00020\u0004H\u0014J*\u00109\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010:\u001a\u0004\u0018\u00010\b2\u000e\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0<H\u0002J\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bR*\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b8V@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010$\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0012\u00100\u001a\u000201X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R*\u0010=\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010>j\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u0001`?X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010A\u00a8\u0006E"}, d2={"Lorg/locationtech/jts/index/strtree/AbstractSTRtree;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "nodeCapacity", "", "<init>", "(I)V", "root", "Lorg/locationtech/jts/index/strtree/AbstractNode;", "(ILorg/locationtech/jts/index/strtree/AbstractNode;)V", "itemBoundables", "", "Lorg/locationtech/jts/index/strtree/ItemBoundable;", "(ILjava/util/List;)V", "value", "getRoot", "()Lorg/locationtech/jts/index/strtree/AbstractNode;", "setRoot", "(Lorg/locationtech/jts/index/strtree/AbstractNode;)V", "built", "", "getNodeCapacity", "()I", "build", "", "createNode", "level", "createParentBoundables", "", "", "childBoundables", "newLevel", "lastNode", "nodes", "createHigherLevels", "boundablesOfALevel", "isEmpty", "()Z", "size", "node", "depth", "insert", "bounds", "item", "query", "searchBounds", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "intersectsOp", "Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "getIntersectsOp", "()Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "queryInternal", "matches", "itemsTree", "remove", "removeItem", "boundablesAtLevel", "top", "boundables", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "getItemBoundables", "IntersectsOp", "Companion", "kts-core"})
public abstract class AbstractSTRtree
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AbstractNode root;
    private boolean built;
    @Nullable
    private List<ItemBoundable> itemBoundables;
    private final int nodeCapacity;
    private static final long serialVersionUID = -3886435814360241337L;
    public static final int DEFAULT_NODE_CAPACITY = 10;

    @JvmOverloads
    public AbstractSTRtree(int nodeCapacity) {
        this.itemBoundables = new ArrayList();
        Assert.INSTANCE.isTrue(nodeCapacity > 1, "Node capacity must be greater than 1");
        this.nodeCapacity = nodeCapacity;
    }

    public /* synthetic */ AbstractSTRtree(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @Nullable
    public AbstractNode getRoot() {
        this.build();
        return this.root;
    }

    protected void setRoot(@Nullable AbstractNode abstractNode) {
        this.root = abstractNode;
    }

    public final int getNodeCapacity() {
        return this.nodeCapacity;
    }

    public AbstractSTRtree(int nodeCapacity, @Nullable AbstractNode root) {
        this(nodeCapacity);
        this.built = true;
        this.setRoot(root);
        this.itemBoundables = null;
    }

    public AbstractSTRtree(int nodeCapacity, @Nullable List<ItemBoundable> itemBoundables) {
        this(nodeCapacity);
        this.itemBoundables = itemBoundables;
    }

    @Synchronized
    public final void build() {
        if (this.built) {
            return;
        }
        List<ItemBoundable> list = this.itemBoundables;
        Intrinsics.checkNotNull(list);
        this.setRoot(list.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1));
        this.itemBoundables = null;
        this.built = true;
    }

    @Nullable
    protected abstract AbstractNode createNode(int var1);

    @NotNull
    protected List<Object> createParentBoundables(@NotNull List<? extends Object> childBoundables, int newLevel) {
        Intrinsics.checkNotNullParameter(childBoundables, (String)"childBoundables");
        Assert.isTrue(!((Collection)childBoundables).isEmpty());
        ArrayList<AbstractNode> parentBoundables = new ArrayList<AbstractNode>();
        parentBoundables.add(this.createNode(newLevel));
        ArrayList sortedChildBoundables = new ArrayList(childBoundables);
        List list = sortedChildBoundables;
        Comparator<Object> comparator = this.getComparator();
        Intrinsics.checkNotNull(comparator);
        CollectionsKt.sortWith((List)list, comparator);
        Iterator iterator2 = sortedChildBoundables.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator i = iterator2;
        while (i.hasNext()) {
            Object e = i.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            Boundable childBoundable = (Boundable)e;
            if (this.lastNode((List)parentBoundables).getChildBoundables().size() == this.nodeCapacity) {
                parentBoundables.add(this.createNode(newLevel));
            }
            this.lastNode((List)parentBoundables).addChildBoundable(childBoundable);
        }
        return parentBoundables;
    }

    @NotNull
    protected final AbstractNode lastNode(@NotNull List<?> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Object obj = nodes.get(nodes.size() - 1);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.AbstractNode");
        return (AbstractNode)obj;
    }

    private final AbstractNode createHigherLevels(List<?> boundablesOfALevel, int level) {
        AbstractNode abstractNode;
        List<?> list = boundablesOfALevel;
        Intrinsics.checkNotNull(list);
        Assert.isTrue(!((Collection)list).isEmpty());
        List<Object> parentBoundables = this.createParentBoundables(boundablesOfALevel, level + 1);
        if (parentBoundables.size() == 1) {
            Object object = parentBoundables.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.AbstractNode");
            abstractNode = (AbstractNode)object;
        } else {
            abstractNode = this.createHigherLevels(parentBoundables, level + 1);
        }
        return abstractNode;
    }

    public final boolean isEmpty() {
        boolean bl;
        if (!this.built) {
            List<ItemBoundable> list = this.itemBoundables;
            Intrinsics.checkNotNull(list);
            bl = list.isEmpty();
        } else {
            AbstractNode abstractNode = this.getRoot();
            Intrinsics.checkNotNull((Object)abstractNode);
            bl = abstractNode.isEmpty();
        }
        return bl;
    }

    protected int size() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.size(this.getRoot());
    }

    protected final int size(@Nullable AbstractNode node) {
        int size = 0;
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        Iterator<Boundable> i = abstractNode.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (childBoundable instanceof AbstractNode) {
                size += this.size((AbstractNode)childBoundable);
                continue;
            }
            if (!(childBoundable instanceof ItemBoundable)) continue;
            ++size;
        }
        return size;
    }

    protected int depth() {
        if (this.isEmpty()) {
            return 0;
        }
        this.build();
        return this.depth(this.getRoot());
    }

    protected final int depth(@Nullable AbstractNode node) {
        int maxChildDepth = 0;
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        Iterator<Boundable> i = abstractNode.getChildBoundables().iterator();
        while (i.hasNext()) {
            int childDepth;
            Boundable childBoundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (!(childBoundable instanceof AbstractNode) || (childDepth = this.depth((AbstractNode)childBoundable)) <= maxChildDepth) continue;
            maxChildDepth = childDepth;
        }
        return maxChildDepth + 1;
    }

    protected final void insert(@NotNull Object bounds, @NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Assert.INSTANCE.isTrue(!this.built, "Cannot insert items into an STR packed R-tree after it has been built.");
        List<ItemBoundable> list = this.itemBoundables;
        Intrinsics.checkNotNull(list);
        list.add(new ItemBoundable(bounds, item));
    }

    @NotNull
    public final List<Object> query(@Nullable Object searchBounds) {
        this.build();
        ArrayList matches = new ArrayList();
        if (this.isEmpty()) {
            return matches;
        }
        IntersectsOp intersectsOp2 = this.getIntersectsOp();
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        if (intersectsOp2.intersects(abstractNode.getBounds(), searchBounds)) {
            this.queryInternal(searchBounds, this.getRoot(), matches);
        }
        return matches;
    }

    protected final void query(@Nullable Object searchBounds, @Nullable ItemVisitor visitor) {
        this.build();
        if (this.isEmpty()) {
            return;
        }
        IntersectsOp intersectsOp2 = this.getIntersectsOp();
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        if (intersectsOp2.intersects(abstractNode.getBounds(), searchBounds)) {
            AbstractNode abstractNode2 = this.getRoot();
            ItemVisitor itemVisitor = visitor;
            Intrinsics.checkNotNull((Object)itemVisitor);
            this.queryInternal(searchBounds, abstractNode2, itemVisitor);
        }
    }

    @NotNull
    protected abstract IntersectsOp getIntersectsOp();

    private final void queryInternal(Object searchBounds, AbstractNode node, List<Object> matches) {
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        List<Boundable> childBoundables = abstractNode.getChildBoundables();
        int n = ((Collection)childBoundables).size();
        for (int i = 0; i < n; ++i) {
            Boundable childBoundable = childBoundables.get(i);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            Boundable boundable = childBoundable;
            if (boundable instanceof AbstractNode) {
                this.queryInternal(searchBounds, (AbstractNode)childBoundable, matches);
                continue;
            }
            if (boundable instanceof ItemBoundable) {
                matches.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
    }

    private final void queryInternal(Object searchBounds, AbstractNode node, ItemVisitor visitor) {
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        List<Boundable> childBoundables = abstractNode.getChildBoundables();
        int n = ((Collection)childBoundables).size();
        for (int i = 0; i < n; ++i) {
            Boundable childBoundable = childBoundables.get(i);
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds)) continue;
            Boundable boundable = childBoundable;
            if (boundable instanceof AbstractNode) {
                this.queryInternal(searchBounds, (AbstractNode)childBoundable, visitor);
                continue;
            }
            if (boundable instanceof ItemBoundable) {
                visitor.visitItem(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
    }

    @NotNull
    public final List<?> itemsTree() {
        this.build();
        List<?> list = this.itemsTree(this.getRoot());
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    private final List<?> itemsTree(AbstractNode node) {
        List valuesTreeForNode = new ArrayList();
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        Iterator<Boundable> i = abstractNode.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (childBoundable instanceof AbstractNode) {
                List<?> valuesTreeForChild = this.itemsTree((AbstractNode)childBoundable);
                if (valuesTreeForChild == null) continue;
                valuesTreeForNode.add(valuesTreeForChild);
                continue;
            }
            if (childBoundable instanceof ItemBoundable) {
                valuesTreeForNode.add(((ItemBoundable)childBoundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
        return valuesTreeForNode.size() <= 0 ? null : valuesTreeForNode;
    }

    protected final boolean remove(@Nullable Object searchBounds, @NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.build();
        IntersectsOp intersectsOp2 = this.getIntersectsOp();
        AbstractNode abstractNode = this.getRoot();
        Intrinsics.checkNotNull((Object)abstractNode);
        return intersectsOp2.intersects(abstractNode.getBounds(), searchBounds) ? this.remove(searchBounds, this.getRoot(), item) : false;
    }

    private final boolean removeItem(AbstractNode node, Object item) {
        Boundable childToRemove = null;
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        Iterator<Boundable> i = abstractNode.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (!(childBoundable instanceof ItemBoundable) || ((ItemBoundable)childBoundable).getItem() != item) continue;
            childToRemove = childBoundable;
        }
        if (childToRemove != null) {
            node.getChildBoundables().remove(childToRemove);
            return true;
        }
        return false;
    }

    private final boolean remove(Object searchBounds, AbstractNode node, Object item) {
        boolean found = this.removeItem(node, item);
        if (found) {
            return true;
        }
        AbstractNode childToPrune = null;
        AbstractNode abstractNode = node;
        Intrinsics.checkNotNull((Object)abstractNode);
        Iterator<Boundable> i = abstractNode.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable childBoundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (!this.getIntersectsOp().intersects(childBoundable.getBounds(), searchBounds) || !(childBoundable instanceof AbstractNode) || !(found = this.remove(searchBounds, (AbstractNode)childBoundable, item))) continue;
            childToPrune = (AbstractNode)childBoundable;
            break;
        }
        if (childToPrune != null && childToPrune.getChildBoundables().isEmpty()) {
            node.getChildBoundables().remove(childToPrune);
        }
        return found;
    }

    @NotNull
    protected List<?> boundablesAtLevel(int level) {
        ArrayList boundables = new ArrayList();
        this.boundablesAtLevel(level, this.getRoot(), boundables);
        return boundables;
    }

    private final void boundablesAtLevel(int level, AbstractNode top, Collection<Object> boundables) {
        Assert.isTrue(level > -2);
        AbstractNode abstractNode = top;
        Intrinsics.checkNotNull((Object)abstractNode);
        if (abstractNode.getLevel() == level) {
            boundables.add(top);
            return;
        }
        Iterator<Boundable> i = top.getChildBoundables().iterator();
        while (i.hasNext()) {
            Boundable boundable;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.strtree.Boundable");
            if (boundable instanceof AbstractNode) {
                this.boundablesAtLevel(level, (AbstractNode)boundable, boundables);
                continue;
            }
            Assert.isTrue(boundable instanceof ItemBoundable);
            if (level != -1) continue;
            boundables.add(boundable);
        }
    }

    @Nullable
    protected abstract Comparator<Object> getComparator();

    @Nullable
    public final List<ItemBoundable> getItemBoundables() {
        return this.itemBoundables;
    }

    @JvmOverloads
    public AbstractSTRtree() {
        this(0, 1, null);
    }

    @JvmStatic
    protected static final int compareDoubles(double a, double b) {
        return Companion.compareDoubles(a, b);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/index/strtree/AbstractSTRtree$Companion;", "", "<init>", "()V", "serialVersionUID", "", "DEFAULT_NODE_CAPACITY", "", "compareDoubles", "a", "", "b", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final int compareDoubles(double a, double b) {
            return a > b ? 1 : (a < b ? -1 : 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/locationtech/jts/index/strtree/AbstractSTRtree$IntersectsOp;", "", "intersects", "", "aBounds", "bBounds", "kts-core"})
    public static interface IntersectsOp {
        public boolean intersects(@Nullable Object var1, @Nullable Object var2);
    }
}

