/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0000J\u0014\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/index/strtree/Interval;", "", "min", "", "max", "<init>", "(DD)V", "other", "(Lorg/locationtech/jts/index/strtree/Interval;)V", "centre", "getCentre", "()D", "expandToInclude", "intersects", "", "equals", "o", "hashCode", "", "kts-core"})
public final class Interval {
    private double min;
    private double max;

    public Interval(double min, double max) {
        Assert.isTrue(min <= max);
        this.min = min;
        this.max = max;
    }

    public Interval(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this(other.min, other.max);
    }

    public final double getCentre() {
        return (this.min + this.max) / (double)2;
    }

    @NotNull
    public final Interval expandToInclude(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.max = Math.INSTANCE.max(this.max, other.max);
        this.min = Math.INSTANCE.min(this.min, other.min);
        return this;
    }

    public final boolean intersects(@NotNull Interval other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !(other.min > this.max) && !(other.max < this.min);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof Interval)) {
            return false;
        }
        Object other = o;
        return this.min == ((Interval)other).min && this.max == ((Interval)other).max;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Math.INSTANCE.doubleToLongBits(this.max);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        temp = Math.INSTANCE.doubleToLongBits(this.min);
        result2 = prime * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }
}

