/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0014\u0018\u0000 ;2\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015J\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001eJ\u0006\u0010,\u001a\u00020\u0015J\u000e\u0010-\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001eJ\u0006\u0010.\u001a\u00020\u0015J\u000e\u0010/\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015J\u0016\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0015J\u0006\u00103\u001a\u00020(J\u0006\u00104\u001a\u00020(J\u000e\u00105\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015J\b\u00106\u001a\u00020\u0015H\u0002J\u0006\u00107\u001a\u00020(J\u000e\u0010!\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020(2\u0006\u0010+\u001a\u00020\u001eJ\n\u00108\u001a\u00020\u000fH\u0096\u0080\u0004J\u0016\u00109\u001a\u00020(2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0015J\u0016\u0010:\u001a\u00020(2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/locationtech/jts/io/StreamTokenizer;", "", "<init>", "()V", "r", "Ljava/io/Reader;", "Lorg/locationtech/jts/io/Reader;", "(Ljava/io/Reader;)V", "nval", "", "getNval", "()D", "setNval", "(D)V", "sval", "", "getSval", "()Ljava/lang/String;", "setSval", "(Ljava/lang/String;)V", "ttype", "", "getTtype", "()I", "setTtype", "(I)V", "tokenTypes", "", "lineNumber", "forceLowercase", "", "isEOLSignificant", "slashStarComments", "slashSlashComments", "pushBackToken", "lastCr", "inReader", "Ljava/io/Reader;", "peekChar", "commentChar", "", "ch", "eolIsSignificant", "flag", "lineno", "lowerCaseMode", "nextToken", "ordinaryChar", "ordinaryChars", "low", "hi", "parseNumbers", "pushBack", "quoteChar", "read", "resetSyntax", "toString", "whitespaceChars", "wordChars", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nStreamTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamTokenizer.kt\norg/locationtech/jts/io/StreamTokenizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1#2:634\n*E\n"})
public final class StreamTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double nval;
    @Nullable
    private String sval;
    private int ttype = -4;
    @NotNull
    private final byte[] tokenTypes = new byte[256];
    private int lineNumber = 1;
    private boolean forceLowercase;
    private boolean isEOLSignificant;
    private boolean slashStarComments;
    private boolean slashSlashComments;
    private boolean pushBackToken;
    private boolean lastCr;
    @Nullable
    private Reader inReader;
    private int peekChar = -2;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_UNKNOWN = -4;
    private static final byte TOKEN_COMMENT = 1;
    private static final byte TOKEN_QUOTE = 2;
    private static final byte TOKEN_WHITE = 4;
    private static final byte TOKEN_WORD = 8;
    private static final byte TOKEN_DIGIT = 16;

    private StreamTokenizer() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    public final double getNval() {
        return this.nval;
    }

    public final void setNval(double d) {
        this.nval = d;
    }

    @Nullable
    public final String getSval() {
        return this.sval;
    }

    public final void setSval(@Nullable String string) {
        this.sval = string;
    }

    public final int getTtype() {
        return this.ttype;
    }

    public final void setTtype(int n) {
        this.ttype = n;
    }

    public StreamTokenizer(@Nullable Reader r) {
        this();
        if (r == null) {
            throw new NullPointerException("r == null");
        }
        this.inReader = r;
    }

    public final void commentChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 1;
        }
    }

    public final void eolIsSignificant(boolean flag) {
        this.isEOLSignificant = flag;
    }

    public final int lineno() {
        return this.lineNumber;
    }

    public final void lowerCaseMode(boolean flag) {
        this.forceLowercase = flag;
    }

    public final int nextToken() throws IOException {
        int n;
        int matchQuote;
        int it;
        int haveDecimal;
        int it2;
        int currentType;
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int currentChar = 0;
        int n2 = currentChar = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && currentChar == 10) {
            this.lastCr = false;
            currentChar = this.read();
        }
        if (currentChar == -1) {
            int n3;
            int it3 = n3 = -1;
            boolean bl = false;
            this.ttype = it3;
            return n3;
        }
        int n4 = currentType = currentChar > 255 ? 8 : this.tokenTypes[currentChar];
        while ((byte)(currentType & 4) != 0) {
            int it3;
            if (currentChar == 13) {
                it3 = this.lineNumber;
                this.lineNumber = it3 + 1;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    it2 = it3 = 10;
                    boolean bl = false;
                    this.ttype = it2;
                    return it3;
                }
                it2 = it3 = this.read();
                boolean bl = false;
                currentChar = it2;
                if (it3 == 10) {
                    currentChar = this.read();
                }
            } else if (currentChar == 10) {
                it3 = this.lineNumber;
                this.lineNumber = it3 + 1;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    it2 = it3 = 10;
                    boolean bl = false;
                    this.ttype = it2;
                    return it3;
                }
                currentChar = this.read();
            } else {
                currentChar = this.read();
            }
            if (currentChar == -1) {
                it2 = it3 = -1;
                boolean bl = false;
                this.ttype = it2;
                return it3;
            }
            currentType = currentChar > 255 ? 8 : this.tokenTypes[currentChar];
        }
        if ((byte)(currentType & 0x10) != 0) {
            double number22;
            StreamTokenizer streamTokenizer;
            StringBuilder digits = new StringBuilder(20);
            haveDecimal = 0;
            boolean checkJustNegative = currentChar == 45;
            do {
                if (currentChar == 46) {
                    haveDecimal = 1;
                }
                digits.append((char)currentChar);
            } while ((currentChar = this.read()) >= 48 && currentChar <= 57 || haveDecimal == 0 && currentChar == 46);
            this.peekChar = currentChar;
            if (checkJustNegative && digits.length() == 1) {
                int n5;
                int it4 = n5 = 45;
                boolean bl = false;
                this.ttype = it4;
                return n5;
            }
            StreamTokenizer streamTokenizer2 = this;
            try {
                Double number22;
                streamTokenizer = streamTokenizer2;
                String string = digits.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Double d = number22 = StringsKt.toDoubleOrNull((String)string);
                if (d == null) {
                    throw new NumberFormatException();
                }
                number22 = d;
            }
            catch (NumberFormatException bl) {
                streamTokenizer = streamTokenizer2;
                number22 = 0.0;
            }
            streamTokenizer.nval = number22;
            int it5 = number22 = -2;
            boolean bl = false;
            this.ttype = it5;
            return number22;
        }
        if ((byte)(currentType & 8) != 0) {
            StringBuilder word = new StringBuilder(20);
            do {
                word.append((char)currentChar);
            } while ((currentChar = this.read()) != -1 && (currentChar >= 256 || (byte)(this.tokenTypes[currentChar] & (byte)(8 | 0x10)) != 0));
            this.peekChar = currentChar;
            this.sval = word.toString();
            if (this.forceLowercase) {
                String string = this.sval;
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                this.sval = string2;
            }
            it = haveDecimal = -3;
            boolean bl = false;
            this.ttype = it;
            return haveDecimal;
        }
        if (currentType == 2) {
            matchQuote = currentChar;
            StringBuilder quoteString = new StringBuilder();
            int peekOne = this.read();
            while (peekOne >= 0 && peekOne != matchQuote && peekOne != 13 && peekOne != 10) {
                boolean readPeek = true;
                if (peekOne == 92) {
                    int c1 = this.read();
                    if (c1 <= 55 && c1 >= 48) {
                        int n6;
                        int digitValue = c1 - 48;
                        c1 = this.read();
                        if (c1 > 55 || c1 < 48) {
                            readPeek = false;
                        } else {
                            digitValue = digitValue * 8 + (c1 - 48);
                            c1 = this.read();
                            if (digitValue > 31 || c1 > 55 || c1 < 48) {
                                readPeek = false;
                            } else {
                                digitValue = digitValue * 8 + (c1 - 48);
                            }
                        }
                        if (!readPeek) {
                            quoteString.append((char)digitValue);
                            n6 = c1;
                        } else {
                            n6 = digitValue;
                        }
                        peekOne = n6;
                    } else {
                        switch ((char)c1) {
                            case 'a': {
                                int n7 = 7;
                                break;
                            }
                            case 'b': {
                                int n7 = 8;
                                break;
                            }
                            case 'f': {
                                int n7 = 12;
                                break;
                            }
                            case 'n': {
                                int n7 = 10;
                                break;
                            }
                            case 'r': {
                                int n7 = 13;
                                break;
                            }
                            case 't': {
                                int n7 = 9;
                                break;
                            }
                            case 'v': {
                                int n7 = 11;
                                break;
                            }
                            default: {
                                int n7 = peekOne = c1;
                            }
                        }
                    }
                }
                if (!readPeek) continue;
                quoteString.append((char)peekOne);
                peekOne = this.read();
            }
            if (peekOne == matchQuote) {
                peekOne = this.read();
            }
            this.peekChar = peekOne;
            this.ttype = matchQuote;
            this.sval = quoteString.toString();
            return this.ttype;
        }
        if (currentChar == 47 && (this.slashSlashComments || this.slashStarComments)) {
            it2 = matchQuote = this.read();
            boolean bl = false;
            currentChar = it2;
            if (matchQuote == 42 && this.slashStarComments) {
                int peekOne = this.read();
                while (true) {
                    currentChar = peekOne;
                    peekOne = this.read();
                    if (currentChar == -1) {
                        this.peekChar = -1;
                        it = it2 = -1;
                        boolean bl2 = false;
                        this.ttype = it;
                        return it2;
                    }
                    if (currentChar == 13) {
                        if (peekOne == 10) {
                            peekOne = this.read();
                        }
                        it2 = this.lineNumber;
                        this.lineNumber = it2 + 1;
                        continue;
                    }
                    if (currentChar == 10) {
                        it2 = this.lineNumber;
                        this.lineNumber = it2 + 1;
                        continue;
                    }
                    if (currentChar == 42 && peekOne == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (currentChar == 47 && this.slashSlashComments) {
                do {
                    it2 = n = this.read();
                    boolean bl3 = false;
                    currentChar = it2;
                } while (n >= 0 && currentChar != 13 && currentChar != 10);
                this.peekChar = currentChar;
                return this.nextToken();
            }
            if (currentType != 1) {
                this.peekChar = currentChar;
                it2 = n = 47;
                boolean bl4 = false;
                this.ttype = it2;
                return n;
            }
        }
        if (currentType == 1) {
            do {
                it2 = n = this.read();
                boolean bl = false;
                currentChar = it2;
            } while (n >= 0 && currentChar != 13 && currentChar != 10);
            this.peekChar = currentChar;
            return this.nextToken();
        }
        this.peekChar = this.read();
        it2 = n = currentChar;
        boolean bl = false;
        this.ttype = it2;
        return n;
    }

    public final void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 0;
        }
    }

    public final void ordinaryChars(int low, int hi) {
        int n;
        int i;
        int low2 = low;
        int hi2 = hi;
        if (low2 < 0) {
            low2 = 0;
        }
        if (hi2 > this.tokenTypes.length) {
            hi2 = this.tokenTypes.length - 1;
        }
        if ((i = low2) <= (n = hi2)) {
            while (true) {
                this.tokenTypes[i] = 0;
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void parseNumbers() {
        for (int i = 48; i <= 57; ++i) {
            this.tokenTypes[i] = (byte)(this.tokenTypes[i] | 0x10);
        }
        this.tokenTypes[46] = (byte)(this.tokenTypes[46] | 0x10);
        this.tokenTypes[45] = (byte)(this.tokenTypes[45] | 0x10);
    }

    public final void pushBack() {
        this.pushBackToken = true;
    }

    public final void quoteChar(int ch) {
        if (ch >= 0 && ch < this.tokenTypes.length) {
            this.tokenTypes[ch] = 2;
        }
    }

    private final int read() throws IOException {
        Reader reader = this.inReader;
        Intrinsics.checkNotNull((Object)reader);
        return reader.read();
    }

    public final void resetSyntax() {
        for (int i = 0; i < 256; ++i) {
            this.tokenTypes[i] = 0;
        }
    }

    public final void slashSlashComments(boolean flag) {
        this.slashSlashComments = flag;
    }

    public final void slashStarComments(boolean flag) {
        this.slashStarComments = flag;
    }

    @NotNull
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("Token[");
        switch (this.ttype) {
            case -1: {
                StringBuilder stringBuilder = result2.append("EOF");
                break;
            }
            case 10: {
                StringBuilder stringBuilder = result2.append("EOL");
                break;
            }
            case -2: {
                result2.append("n=");
                StringBuilder stringBuilder = result2.append(this.nval);
                break;
            }
            case -3: {
                StringBuilder stringBuilder = result2.append(this.sval);
                break;
            }
            default: {
                StringBuilder stringBuilder;
                if (this.ttype == -4 || this.tokenTypes[this.ttype] == 2) {
                    stringBuilder = result2.append(this.sval);
                    break;
                }
                result2.append('\'');
                result2.append((char)this.ttype);
                stringBuilder = result2.append('\'');
            }
        }
        result2.append("], line ");
        result2.append(this.lineNumber);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void whitespaceChars(int low, int hi) {
        int n;
        int i;
        int low2 = low;
        int hi2 = hi;
        if (low2 < 0) {
            low2 = 0;
        }
        if (hi2 > this.tokenTypes.length) {
            hi2 = this.tokenTypes.length - 1;
        }
        if ((i = low2) <= (n = hi2)) {
            while (true) {
                this.tokenTypes[i] = 4;
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void wordChars(int low, int hi) {
        int n;
        int i;
        int low2 = low;
        int hi2 = hi;
        if (low2 < 0) {
            low2 = 0;
        }
        if (hi2 > this.tokenTypes.length) {
            hi2 = this.tokenTypes.length - 1;
        }
        if ((i = low2) <= (n = hi2)) {
            while (true) {
                this.tokenTypes[i] = (byte)(this.tokenTypes[i] | 8);
                if (i == n) break;
                ++i;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/io/StreamTokenizer$Companion;", "", "<init>", "()V", "TT_EOF", "", "TT_EOL", "TT_NUMBER", "TT_WORD", "TT_UNKNOWN", "TOKEN_COMMENT", "", "TOKEN_QUOTE", "TOKEN_WHITE", "TOKEN_WORD", "TOKEN_DIGIT", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

