/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 42\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u00014B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\u000bB)\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0003\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010'\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001bJ\u0014\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\u001e\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\bJ\u000e\u0010.\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u00101\u001a\u00020\u0000J\n\u00102\u001a\u000203H\u0096\u0080\u0004R\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lorg/locationtech/jts/linearref/LinearLocation;", "", "", "<init>", "()V", "segmentIndex", "", "segmentFraction", "", "(ID)V", "componentIndex", "(IID)V", "doNormalize", "", "(IIDZ)V", "loc", "(Lorg/locationtech/jts/linearref/LinearLocation;)V", "value", "getComponentIndex", "()I", "getSegmentIndex", "getSegmentFraction", "()D", "normalize", "", "clamp", "linear", "Lorg/locationtech/jts/geom/Geometry;", "snapToVertex", "linearGeom", "minDistance", "getSegmentLength", "setToEnd", "isVertex", "()Z", "getCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "getSegment", "Lorg/locationtech/jts/geom/LineSegment;", "isValid", "compareTo", "o", "compareLocationValues", "componentIndex1", "segmentIndex1", "segmentFraction1", "isOnSameSegment", "isEndpoint", "toLowest", "copy", "toString", "", "Companion", "kts-core"})
public final class LinearLocation
implements Comparable<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int componentIndex;
    private int segmentIndex;
    private double segmentFraction;

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    public final int getSegmentIndex() {
        return this.segmentIndex;
    }

    public final double getSegmentFraction() {
        return this.segmentFraction;
    }

    public LinearLocation() {
    }

    public LinearLocation(int segmentIndex, double segmentFraction) {
        this(0, segmentIndex, segmentFraction);
    }

    public LinearLocation(int componentIndex, int segmentIndex, double segmentFraction) {
        this.componentIndex = componentIndex;
        this.segmentIndex = segmentIndex;
        this.segmentFraction = segmentFraction;
        this.normalize();
    }

    private LinearLocation(int componentIndex, int segmentIndex, double segmentFraction, boolean doNormalize) {
        this.componentIndex = componentIndex;
        this.segmentIndex = segmentIndex;
        this.segmentFraction = segmentFraction;
        if (doNormalize) {
            this.normalize();
        }
    }

    public LinearLocation(@NotNull LinearLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.componentIndex = loc.componentIndex;
        this.segmentIndex = loc.segmentIndex;
        this.segmentFraction = loc.segmentFraction;
    }

    private final void normalize() {
        if (this.segmentFraction < 0.0) {
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction > 1.0) {
            this.segmentFraction = 1.0;
        }
        if (this.componentIndex < 0) {
            this.componentIndex = 0;
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentIndex < 0) {
            this.segmentIndex = 0;
            this.segmentFraction = 0.0;
        }
        if (this.segmentFraction == 1.0) {
            this.segmentFraction = 0.0;
            ++this.segmentIndex;
        }
    }

    public final void clamp(@NotNull Geometry linear) {
        Intrinsics.checkNotNullParameter((Object)linear, (String)"linear");
        if (this.componentIndex >= linear.getNumGeometries()) {
            this.setToEnd(linear);
            return;
        }
        if (this.segmentIndex >= linear.getNumPoints()) {
            Geometry geometry = linear.getGeometryN(this.componentIndex);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            this.segmentIndex = LinearLocation.Companion.numSegments(line);
            this.segmentFraction = 1.0;
        }
    }

    public final void snapToVertex(@NotNull Geometry linearGeom, double minDistance) {
        double lenToEnd;
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        if (this.segmentFraction <= 0.0 || this.segmentFraction >= 1.0) {
            return;
        }
        double segLen = this.getSegmentLength(linearGeom);
        double lenToStart = this.segmentFraction * segLen;
        if (lenToStart <= (lenToEnd = segLen - lenToStart) && lenToStart < minDistance) {
            this.segmentFraction = 0.0;
        } else if (lenToEnd <= lenToStart && lenToEnd < minDistance) {
            this.segmentFraction = 1.0;
        }
    }

    public final double getSegmentLength(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        int segIndex = this.segmentIndex;
        if (this.segmentIndex >= LinearLocation.Companion.numSegments(lineComp)) {
            segIndex = lineComp.getNumPoints() - 2;
        }
        Coordinate p0 = lineComp.getCoordinateN(segIndex);
        Coordinate p1 = lineComp.getCoordinateN(segIndex + 1);
        return p0.distance(p1);
    }

    public final void setToEnd(@NotNull Geometry linear) {
        Intrinsics.checkNotNullParameter((Object)linear, (String)"linear");
        this.componentIndex = linear.getNumGeometries() - 1;
        Geometry geometry = linear.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lastLine = (LineString)geometry;
        this.segmentIndex = LinearLocation.Companion.numSegments(lastLine);
        this.segmentFraction = 0.0;
    }

    public final boolean isVertex() {
        return this.segmentFraction <= 0.0 || this.segmentFraction >= 1.0;
    }

    @NotNull
    public final Coordinate getCoordinate(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        Coordinate p0 = lineComp.getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= LinearLocation.Companion.numSegments(lineComp)) {
            return p0;
        }
        Coordinate p1 = lineComp.getCoordinateN(this.segmentIndex + 1);
        return Companion.pointAlongSegmentByFraction(p0, p1, this.segmentFraction);
    }

    @NotNull
    public final LineSegment getSegment(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        Coordinate p0 = lineComp.getCoordinateN(this.segmentIndex);
        if (this.segmentIndex >= LinearLocation.Companion.numSegments(lineComp)) {
            Coordinate prev = lineComp.getCoordinateN(lineComp.getNumPoints() - 2);
            return new LineSegment(prev, p0);
        }
        Coordinate p1 = lineComp.getCoordinateN(this.segmentIndex + 1);
        return new LineSegment(p0, p1);
    }

    public final boolean isValid(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        if (this.componentIndex < 0 || this.componentIndex >= linearGeom.getNumGeometries()) {
            return false;
        }
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        if (this.segmentIndex < 0 || this.segmentIndex > lineComp.getNumPoints()) {
            return false;
        }
        if (this.segmentIndex == lineComp.getNumPoints() && !(this.segmentFraction == 0.0)) {
            return false;
        }
        return !(this.segmentFraction < 0.0) && !(this.segmentFraction > 1.0);
    }

    @Override
    public int compareTo(@Nullable Object o) {
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type org.locationtech.jts.linearref.LinearLocation");
        LinearLocation other = (LinearLocation)o;
        if (this.componentIndex < other.componentIndex) {
            return -1;
        }
        if (this.componentIndex > other.componentIndex) {
            return 1;
        }
        if (this.segmentIndex < other.segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > other.segmentIndex) {
            return 1;
        }
        if (this.segmentFraction < other.segmentFraction) {
            return -1;
        }
        return this.segmentFraction > other.segmentFraction ? 1 : 0;
    }

    public final int compareLocationValues(int componentIndex1, int segmentIndex1, double segmentFraction1) {
        if (this.componentIndex < componentIndex1) {
            return -1;
        }
        if (this.componentIndex > componentIndex1) {
            return 1;
        }
        if (this.segmentIndex < segmentIndex1) {
            return -1;
        }
        if (this.segmentIndex > segmentIndex1) {
            return 1;
        }
        if (this.segmentFraction < segmentFraction1) {
            return -1;
        }
        return this.segmentFraction > segmentFraction1 ? 1 : 0;
    }

    public final boolean isOnSameSegment(@NotNull LinearLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        if (this.componentIndex != loc.componentIndex) {
            return false;
        }
        if (this.segmentIndex == loc.segmentIndex) {
            return true;
        }
        if (loc.segmentIndex - this.segmentIndex == 1 && loc.segmentFraction == 0.0) {
            return true;
        }
        return this.segmentIndex - loc.segmentIndex == 1 && this.segmentFraction == 0.0;
    }

    public final boolean isEndpoint(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        int nseg = LinearLocation.Companion.numSegments(lineComp);
        return this.segmentIndex >= nseg || this.segmentIndex == nseg - 1 && this.segmentFraction >= 1.0;
    }

    @NotNull
    public final LinearLocation toLowest(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        Geometry geometry = linearGeom.getGeometryN(this.componentIndex);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lineComp = (LineString)geometry;
        int nseg = LinearLocation.Companion.numSegments(lineComp);
        return this.segmentIndex < nseg ? this : new LinearLocation(this.componentIndex, nseg - 1, 1.0, false);
    }

    @NotNull
    public final LinearLocation copy() {
        return new LinearLocation(this.componentIndex, this.segmentIndex, this.segmentFraction);
    }

    @NotNull
    public String toString() {
        return "LinearLoc[" + this.componentIndex + ", " + this.segmentIndex + ", " + this.segmentFraction + "]";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/linearref/LinearLocation$Companion;", "", "<init>", "()V", "getEndLocation", "Lorg/locationtech/jts/linearref/LinearLocation;", "linear", "Lorg/locationtech/jts/geom/Geometry;", "pointAlongSegmentByFraction", "Lorg/locationtech/jts/geom/Coordinate;", "p0", "p1", "frac", "", "compareLocationValues", "", "componentIndex0", "segmentIndex0", "segmentFraction0", "componentIndex1", "segmentIndex1", "segmentFraction1", "numSegments", "line", "Lorg/locationtech/jts/geom/LineString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinearLocation getEndLocation(@NotNull Geometry linear) {
            Intrinsics.checkNotNullParameter((Object)linear, (String)"linear");
            LinearLocation loc = new LinearLocation();
            loc.setToEnd(linear);
            return loc;
        }

        @NotNull
        public final Coordinate pointAlongSegmentByFraction(@NotNull Coordinate p0, @NotNull Coordinate p1, double frac) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            if (frac <= 0.0) {
                return p0;
            }
            if (frac >= 1.0) {
                return p1;
            }
            double x = (p1.x - p0.x) * frac + p0.x;
            double y = (p1.y - p0.y) * frac + p0.y;
            double z = (p1.getZ() - p0.getZ()) * frac + p0.getZ();
            return new Coordinate(x, y, z);
        }

        public final int compareLocationValues(int componentIndex0, int segmentIndex0, double segmentFraction0, int componentIndex1, int segmentIndex1, double segmentFraction1) {
            if (componentIndex0 < componentIndex1) {
                return -1;
            }
            if (componentIndex0 > componentIndex1) {
                return 1;
            }
            if (segmentIndex0 < segmentIndex1) {
                return -1;
            }
            if (segmentIndex0 > segmentIndex1) {
                return 1;
            }
            if (segmentFraction0 < segmentFraction1) {
                return -1;
            }
            return segmentFraction0 > segmentFraction1 ? 1 : 0;
        }

        private final int numSegments(LineString line) {
            int npts = line.getNumPoints();
            return npts <= 1 ? 0 : npts - 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

