/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Character;
import org.locationtech.jts.legacy.Cloneable;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u0000 M2\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u00032\u00020\u0004:\u0001MB\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0005\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0000H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\bJ\u0018\u0010#\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020\u0000J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020(J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u00103\u001a\u00020\bJ\u0006\u00104\u001a\u00020(J\u000e\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020\u0000J\u000e\u0010=\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010>\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010?\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010@\u001a\u0002062\u0006\u0010\u0019\u001a\u00020\u0000J\u0012\u0010A\u001a\u00020(2\u0006\u0010<\u001a\u00020\u0000H\u0096\u0082\u0004J\u0006\u0010B\u001a\u00020\u0010J\n\u0010C\u001a\u00020\u0010H\u0096\u0080\u0004J\u0006\u0010D\u001a\u00020\u0010J\u0006\u0010E\u001a\u00020\u0010J\u0018\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u0002062\u0006\u0010H\u001a\u00020IH\u0002R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b5\u00107R\u0011\u00108\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b8\u00107R\u0011\u00109\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b9\u00107R\u0011\u0010:\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b:\u00107R\u0016\u0010J\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006N"}, d2={"Lorg/locationtech/jts/math/DD;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "", "Lorg/locationtech/jts/legacy/Cloneable;", "<init>", "()V", "x", "", "(D)V", "hi", "lo", "(DD)V", "dd", "(Lorg/locationtech/jts/math/DD;)V", "str", "", "(Ljava/lang/String;)V", "clone", "", "init", "", "setValue", "value", "add", "y", "selfAdd", "yhi", "ylo", "subtract", "selfSubtract", "negate", "multiply", "selfMultiply", "divide", "selfDivide", "reciprocal", "floor", "ceil", "signum", "", "rint", "trunc", "abs", "sqr", "selfSqr", "sqrt", "pow", "exp", "min", "max", "doubleValue", "intValue", "isZero", "", "()Z", "isNegative", "isPositive", "isNaN", "equals", "other", "gt", "ge", "lt", "le", "compareTo", "dump", "toString", "toStandardNotation", "toSciNotation", "extractSignificantDigits", "insertDecimalPoint", "magnitude", "", "specialNumberString", "getSpecialNumberString", "()Ljava/lang/String;", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nDD.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DD.kt\norg/locationtech/jts/math/DD\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1356:1\n1#2:1357\n*E\n"})
public final class DD
implements Serializable,
Comparable<DD>,
Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double hi;
    private double lo;
    @NotNull
    private static final DD PI = new DD(java.lang.Math.PI, 1.2246467991473532E-16);
    @NotNull
    private static final DD TWO_PI = new DD(java.lang.Math.PI * 2, 2.4492935982947064E-16);
    @NotNull
    private static final DD PI_2 = new DD(1.5707963267948966, 6.123233995736766E-17);
    @NotNull
    private static final DD E = new DD(java.lang.Math.E, 1.4456468917292502E-16);
    @NotNull
    private static final DD NaN = new DD(Double.NaN, Double.NaN);
    public static final double EPS = 1.23259516440783E-32;
    private static final double SPLIT = 1.34217729E8;
    private static final int MAX_PRINT_DIGITS = 32;
    @NotNull
    private static final DD TEN = Companion.valueOf(10.0);
    @NotNull
    private static final DD ONE = Companion.valueOf(1.0);
    @NotNull
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    @NotNull
    private static final String SCI_NOT_ZERO = "0.0E0";

    public DD() {
        this.init(0.0);
    }

    public DD(double x) {
        this.init(x);
    }

    public DD(double hi, double lo) {
        this.init(hi, lo);
    }

    public DD(@NotNull DD dd) {
        Intrinsics.checkNotNullParameter((Object)dd, (String)"dd");
        this.init(dd);
    }

    public DD(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this(Companion.parse(str));
    }

    @Override
    @NotNull
    public Object clone() {
        return Companion.copy(this);
    }

    private final void init(double x) {
        this.hi = x;
        this.lo = 0.0;
    }

    private final void init(double hi, double lo) {
        this.hi = hi;
        this.lo = lo;
    }

    private final void init(DD dd) {
        this.hi = dd.hi;
        this.lo = dd.lo;
    }

    @NotNull
    public final DD setValue(@NotNull DD value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.init(value);
        return this;
    }

    @NotNull
    public final DD setValue(double value) {
        this.init(value);
        return this;
    }

    @NotNull
    public final DD add(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return Companion.copy(this).selfAdd(y);
    }

    @NotNull
    public final DD add(double y) {
        return Companion.copy(this).selfAdd(y);
    }

    @NotNull
    public final DD selfAdd(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.selfAdd(y.hi, y.lo);
    }

    @NotNull
    public final strictfp DD selfAdd(double y) {
        double H = 0.0;
        double h = 0.0;
        double s = 0.0;
        double e = 0.0;
        double S = this.hi + y;
        e = S - this.hi;
        s = S - e;
        s = y - e + (this.hi - s);
        double f = s + this.lo;
        H = S + f;
        h = f + (S - H);
        this.hi = H + h;
        this.lo = h + (H - this.hi);
        return this;
    }

    private final strictfp DD selfAdd(double yhi, double ylo) {
        double H = 0.0;
        double h = 0.0;
        double t = 0.0;
        double s = 0.0;
        double e = 0.0;
        double f = 0.0;
        double S = this.hi + yhi;
        double T = this.lo + ylo;
        e = S - this.hi;
        f = T - this.lo;
        s = S - e;
        t = T - f;
        s = yhi - e + (this.hi - s);
        t = ylo - f + (this.lo - t);
        e = s + T;
        H = S + e;
        h = e + (S - H);
        e = t + h;
        double zhi = H + e;
        double zlo = e + (H - zhi);
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    @NotNull
    public final DD subtract(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.add(y.negate());
    }

    @NotNull
    public final DD subtract(double y) {
        return this.add(-y);
    }

    @NotNull
    public final DD selfSubtract(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.isNaN() ? this : this.selfAdd(-y.hi, -y.lo);
    }

    @NotNull
    public final DD selfSubtract(double y) {
        return this.isNaN() ? this : this.selfAdd(-y, 0.0);
    }

    @NotNull
    public final DD negate() {
        return this.isNaN() ? this : new DD(-this.hi, -this.lo);
    }

    @NotNull
    public final DD multiply(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return y.isNaN() ? DD.Companion.createNaN() : Companion.copy(this).selfMultiply(y);
    }

    @NotNull
    public final DD multiply(double y) {
        return Math.INSTANCE.isNaN(y) ? DD.Companion.createNaN() : Companion.copy(this).selfMultiply(y, 0.0);
    }

    @NotNull
    public final DD selfMultiply(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.selfMultiply(y.hi, y.lo);
    }

    @NotNull
    public final DD selfMultiply(double y) {
        return this.selfMultiply(y, 0.0);
    }

    private final strictfp DD selfMultiply(double yhi, double ylo) {
        double hx = 0.0;
        double hy = 0.0;
        double C = 1.34217729E8 * this.hi;
        hx = C - this.hi;
        double c = 1.34217729E8 * yhi;
        hx = C - hx;
        double tx = this.hi - hx;
        hy = c - yhi;
        C = this.hi * yhi;
        hy = c - hy;
        double ty = yhi - hy;
        c = hx * hy - C + hx * ty + tx * hy + tx * ty + (this.hi * ylo + this.lo * yhi);
        double zhi = C + c;
        hx = C - zhi;
        double zlo = c + hx;
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    @NotNull
    public final strictfp DD divide(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        double hc = 0.0;
        double tc = 0.0;
        double hy = 0.0;
        double c = 0.0;
        double U = 0.0;
        double C = this.hi / y.hi;
        c = 1.34217729E8 * C;
        hc = c - C;
        double u = 1.34217729E8 * y.hi;
        hc = c - hc;
        tc = C - hc;
        hy = u - y.hi;
        U = C * y.hi;
        hy = u - hy;
        double ty = y.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.hi - U - u + this.lo - C * y.lo) / y.hi;
        double zhi = u = C + c;
        double zlo = C - u + c;
        return new DD(zhi, zlo);
    }

    @NotNull
    public final DD divide(double y) {
        return Math.INSTANCE.isNaN(y) ? DD.Companion.createNaN() : Companion.copy(this).selfDivide(y, 0.0);
    }

    @NotNull
    public final DD selfDivide(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.selfDivide(y.hi, y.lo);
    }

    @NotNull
    public final DD selfDivide(double y) {
        return this.selfDivide(y, 0.0);
    }

    private final strictfp DD selfDivide(double yhi, double ylo) {
        double hc = 0.0;
        double tc = 0.0;
        double hy = 0.0;
        double c = 0.0;
        double U = 0.0;
        double C = this.hi / yhi;
        c = 1.34217729E8 * C;
        hc = c - C;
        double u = 1.34217729E8 * yhi;
        hc = c - hc;
        tc = C - hc;
        hy = u - yhi;
        U = C * yhi;
        hy = u - hy;
        double ty = yhi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.hi - U - u + this.lo - C * ylo) / yhi;
        this.hi = u = C + c;
        this.lo = C - u + c;
        return this;
    }

    @NotNull
    public final strictfp DD reciprocal() {
        double hc = 0.0;
        double tc = 0.0;
        double hy = 0.0;
        double c = 0.0;
        double U = 0.0;
        double C = 1.0 / this.hi;
        c = 1.34217729E8 * C;
        hc = c - C;
        double u = 1.34217729E8 * this.hi;
        hc = c - hc;
        tc = C - hc;
        hy = u - this.hi;
        U = C * this.hi;
        hy = u - hy;
        double ty = this.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (1.0 - U - u - C * this.lo) / this.hi;
        double zhi = C + c;
        double zlo = C - zhi + c;
        return new DD(zhi, zlo);
    }

    @NotNull
    public final strictfp DD floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.INSTANCE.floor(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.INSTANCE.floor(this.lo);
        }
        return new DD(fhi, flo);
    }

    @NotNull
    public final strictfp DD ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.INSTANCE.ceil(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.INSTANCE.ceil(this.lo);
        }
        return new DD(fhi, flo);
    }

    public final strictfp int signum() {
        if (this.hi > 0.0) {
            return 1;
        }
        if (this.hi < 0.0) {
            return -1;
        }
        if (this.lo > 0.0) {
            return 1;
        }
        return this.lo < 0.0 ? -1 : 0;
    }

    @NotNull
    public final strictfp DD rint() {
        if (this.isNaN()) {
            return this;
        }
        DD plus5 = this.add(0.5);
        return plus5.floor();
    }

    @NotNull
    public final DD trunc() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.isPositive() ? this.floor() : this.ceil();
    }

    @NotNull
    public final DD abs() {
        if (this.isNaN()) {
            return NaN;
        }
        return this.isNegative() ? this.negate() : new DD(this);
    }

    @NotNull
    public final DD sqr() {
        return this.multiply(this);
    }

    @NotNull
    public final DD selfSqr() {
        return this.selfMultiply(this);
    }

    @NotNull
    public final strictfp DD sqrt() {
        if (this.isZero()) {
            return Companion.valueOf(0.0);
        }
        if (this.isNegative()) {
            return NaN;
        }
        double x = 1.0 / Math.INSTANCE.sqrt(this.hi);
        double ax = this.hi * x;
        DD axdd = Companion.valueOf(ax);
        DD diffSq = this.subtract(axdd.sqr());
        double d2 = diffSq.hi * (x * 0.5);
        return axdd.add(d2);
    }

    @NotNull
    public final strictfp DD pow(int exp) {
        if ((double)exp == 0.0) {
            return Companion.valueOf(1.0);
        }
        DD r = new DD(this);
        DD s = Companion.valueOf(1.0);
        int n = Math.INSTANCE.abs(exp);
        if (n > 1) {
            while (n > 0) {
                if (n % 2 == 1) {
                    s.selfMultiply(r);
                }
                if ((n /= 2) <= 0) continue;
                r = r.sqr();
            }
        } else {
            s = r;
        }
        return exp < 0 ? s.reciprocal() : s;
    }

    @NotNull
    public final strictfp DD min(@NotNull DD x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.le(x) ? this : x;
    }

    @NotNull
    public final DD max(@NotNull DD x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.ge(x) ? this : x;
    }

    public final strictfp double doubleValue() {
        return this.hi + this.lo;
    }

    public final int intValue() {
        return (int)this.hi;
    }

    public final strictfp boolean isZero() {
        return this.hi == 0.0 && this.lo == 0.0;
    }

    public final strictfp boolean isNegative() {
        return this.hi < 0.0 || this.hi == 0.0 && this.lo < 0.0;
    }

    public final strictfp boolean isPositive() {
        return this.hi > 0.0 || this.hi == 0.0 && this.lo > 0.0;
    }

    public final strictfp boolean isNaN() {
        return Math.INSTANCE.isNaN(this.hi);
    }

    public final strictfp boolean equals(@NotNull DD other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.hi == other.hi && this.lo == other.lo;
    }

    public final strictfp boolean gt(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.hi > y.hi || this.hi == y.hi && this.lo > y.lo;
    }

    public final strictfp boolean ge(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.hi > y.hi || this.hi == y.hi && this.lo >= y.lo;
    }

    public final strictfp boolean lt(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.hi < y.hi || this.hi == y.hi && this.lo < y.lo;
    }

    public final strictfp boolean le(@NotNull DD y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.hi < y.hi || this.hi == y.hi && this.lo <= y.lo;
    }

    @Override
    public strictfp int compareTo(@NotNull DD other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.hi < other.hi) {
            return -1;
        }
        if (this.hi > other.hi) {
            return 1;
        }
        if (this.lo < other.lo) {
            return -1;
        }
        return this.lo > other.lo ? 1 : 0;
    }

    @NotNull
    public final String dump() {
        return "DD<" + this.hi + ", " + this.lo + ">";
    }

    @NotNull
    public String toString() {
        int mag = DD.Companion.magnitude(this.hi);
        return mag >= -3 && mag <= 20 ? this.toStandardNotation() : this.toSciNotation();
    }

    @NotNull
    public final strictfp String toStandardNotation() {
        String specialStr;
        String string = specialStr = this.getSpecialNumberString();
        if (string != null) {
            return string;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        Object num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + DD.Companion.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (StringsKt.indexOf$default((CharSequence)sigDigits, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = DD.Companion.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        return this.isNegative() ? "-" + (String)num : num;
    }

    @NotNull
    public final strictfp String toSciNotation() {
        String specialStr;
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String string = specialStr = this.getSpecialNumberString();
        if (string != null) {
            return string;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (!(digits.charAt(0) != '0')) {
            boolean $i$a$-check-DD$toSciNotation$22 = false;
            String $i$a$-check-DD$toSciNotation$22 = "Found leading zero: " + digits;
            throw new IllegalStateException($i$a$-check-DD$toSciNotation$22.toString());
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            String string2 = digits.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            trailingDigits = string2;
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        return this.isNegative() ? "-" + digitsWithDecimal + expStr : digitsWithDecimal + expStr;
    }

    private final strictfp String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        DD y = this.abs();
        int mag = DD.Companion.magnitude(y.hi);
        DD scale = TEN.pow(mag);
        if ((y = y.divide(scale)).gt(TEN)) {
            y = y.divide(TEN);
            ++mag;
        } else if (y.lt(ONE)) {
            y = y.multiply(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuilder buf = new StringBuilder();
        int numDigits = 31;
        int i = 0;
        while (true) {
            int digit;
            if (insertDecimalPoint && i == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y.hi) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y = y.subtract(Companion.valueOf(digit)).multiply(TEN);
            if (rebiasBy10) {
                y.selfAdd(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = DD.Companion.magnitude(y.hi);
            if (remMag < 0 && Math.INSTANCE.abs(remMag) >= numDigits - i) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits || i == numDigits) break;
            ++i;
        }
        magnitude[0] = mag;
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        return this.isNaN() ? "NaN " : null;
    }

    @JvmStatic
    @NotNull
    public static final DD valueOf(@NotNull String str) throws NumberFormatException {
        return Companion.valueOf(str);
    }

    @JvmStatic
    @NotNull
    public static final DD valueOf(double x) {
        return Companion.valueOf(x);
    }

    @JvmStatic
    @NotNull
    public static final DD copy(@NotNull DD dd) {
        return Companion.copy(dd);
    }

    @JvmStatic
    @NotNull
    public static final DD sqr(double x) {
        return Companion.sqr(x);
    }

    @JvmStatic
    @NotNull
    public static final DD sqrt(double x) {
        return Companion.sqrt(x);
    }

    @JvmStatic
    @NotNull
    public static final DD determinant(double x1, double y1, double x2, double y2) {
        return Companion.determinant(x1, y1, x2, y2);
    }

    @JvmStatic
    @NotNull
    public static final DD determinant(@NotNull DD x1, @NotNull DD y1, @NotNull DD x2, @NotNull DD y2) {
        return Companion.determinant(x1, y1, x2, y2);
    }

    @JvmStatic
    @NotNull
    public static final DD parse(@NotNull String str) throws NumberFormatException {
        return Companion.parse(str);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0007J(\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"H\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010,\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/locationtech/jts/math/DD$Companion;", "", "<init>", "()V", "PI", "Lorg/locationtech/jts/math/DD;", "getPI", "()Lorg/locationtech/jts/math/DD;", "TWO_PI", "getTWO_PI", "PI_2", "getPI_2", "E", "getE", "NaN", "getNaN", "EPS", "", "createNaN", "valueOf", "str", "", "x", "SPLIT", "copy", "dd", "sqr", "sqrt", "determinant", "x1", "y1", "x2", "y2", "MAX_PRINT_DIGITS", "", "TEN", "ONE", "SCI_NOT_EXPONENT_CHAR", "SCI_NOT_ZERO", "stringOfChar", "ch", "", "len", "magnitude", "parse", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DD getPI() {
            return PI;
        }

        @NotNull
        public final DD getTWO_PI() {
            return TWO_PI;
        }

        @NotNull
        public final DD getPI_2() {
            return PI_2;
        }

        @NotNull
        public final DD getE() {
            return E;
        }

        @NotNull
        public final DD getNaN() {
            return NaN;
        }

        private final DD createNaN() {
            return new DD(Double.NaN, Double.NaN);
        }

        @JvmStatic
        @NotNull
        public final DD valueOf(@NotNull String str) throws NumberFormatException {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return this.parse(str);
        }

        @JvmStatic
        @NotNull
        public final DD valueOf(double x) {
            return new DD(x);
        }

        @JvmStatic
        @NotNull
        public final DD copy(@NotNull DD dd) {
            Intrinsics.checkNotNullParameter((Object)dd, (String)"dd");
            return new DD(dd);
        }

        @JvmStatic
        @NotNull
        public final DD sqr(double x) {
            return this.valueOf(x).selfMultiply(x);
        }

        @JvmStatic
        @NotNull
        public final DD sqrt(double x) {
            return this.valueOf(x).sqrt();
        }

        @JvmStatic
        @NotNull
        public final DD determinant(double x1, double y1, double x2, double y2) {
            return this.determinant(this.valueOf(x1), this.valueOf(y1), this.valueOf(x2), this.valueOf(y2));
        }

        @JvmStatic
        @NotNull
        public final DD determinant(@NotNull DD x1, @NotNull DD y1, @NotNull DD x2, @NotNull DD y2) {
            Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
            Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
            Intrinsics.checkNotNullParameter((Object)x2, (String)"x2");
            Intrinsics.checkNotNullParameter((Object)y2, (String)"y2");
            return x1.multiply(y2).selfSubtract(y1.multiply(x2));
        }

        private final String stringOfChar(char ch, int len) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                buf.append(ch);
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final int magnitude(double x) {
            double xAbs = Math.INSTANCE.abs(x);
            double xLog10 = Math.INSTANCE.log(xAbs) / Math.INSTANCE.log(10.0);
            int xMag = (int)Math.INSTANCE.floor(xLog10);
            double xApprox = Math.INSTANCE.pow(10.0, xMag);
            if (xApprox * (double)10 <= xAbs) {
                ++xMag;
            }
            return xMag;
        }

        @JvmStatic
        @NotNull
        public final DD parse(@NotNull String str) throws NumberFormatException {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            int i = 0;
            int strlen = str.length();
            while (Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
            boolean isNegative = false;
            if (i < strlen) {
                char signCh = str.charAt(i);
                switch (signCh) {
                    case '+': 
                    case '-': {
                        ++i;
                        if (signCh != '-') break;
                        isNegative = true;
                    }
                }
            }
            DD val = new DD();
            int numDigits = 0;
            int numBeforeDec = 0;
            int exp = 0;
            boolean hasDecimalChar = false;
            block9: while (i < strlen) {
                char ch = str.charAt(i);
                ++i;
                if (Character.isDigit(ch)) {
                    double d = (double)ch - 48.0;
                    val.selfMultiply(TEN);
                    val.selfAdd(d);
                    ++numDigits;
                    continue;
                }
                if (ch == '.') {
                    numBeforeDec = numDigits;
                    hasDecimalChar = true;
                    continue;
                }
                switch (ch) {
                    case 'E': 
                    case 'e': {
                        int n;
                        String string = str.substring(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String expStr = string;
                        try {
                            n = Integer.parseInt(expStr);
                        }
                        catch (NumberFormatException ex) {
                            throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                        }
                        exp = n;
                        break block9;
                    }
                    default: {
                        throw new NumberFormatException("Unexpected character '" + ch + "' at position " + i + " in string " + str);
                    }
                }
            }
            DD val2 = val;
            if (!hasDecimalChar) {
                numBeforeDec = numDigits;
            }
            int numDecPlaces = numDigits - numBeforeDec - exp;
            if (numDecPlaces == 0) {
                val2 = val;
            } else if (numDecPlaces > 0) {
                DD scale = TEN.pow(numDecPlaces);
                val2 = val.divide(scale);
            } else if (numDecPlaces < 0) {
                DD scale = TEN.pow(-numDecPlaces);
                val2 = val.multiply(scale);
            }
            return isNegative ? val2.negate() : val2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

