/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.Vector3D;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/math/Plane3D;", "", "normal", "Lorg/locationtech/jts/math/Vector3D;", "basePt", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/math/Vector3D;Lorg/locationtech/jts/geom/Coordinate;)V", "orientedDistance", "", "p", "closestAxisPlane", "", "Companion", "kts-core"})
public final class Plane3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3D normal;
    @NotNull
    private final Coordinate basePt;
    public static final int XY_PLANE = 1;
    public static final int YZ_PLANE = 2;
    public static final int XZ_PLANE = 3;

    public Plane3D(@NotNull Vector3D normal, @NotNull Coordinate basePt) {
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Intrinsics.checkNotNullParameter((Object)basePt, (String)"basePt");
        this.normal = normal;
        this.basePt = basePt;
    }

    public final double orientedDistance(@Nullable Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        Vector3D pb = new Vector3D(coordinate, this.basePt);
        double pbdDotNormal = pb.dot(this.normal);
        if (Math.INSTANCE.isNaN(pbdDotNormal)) {
            throw new IllegalArgumentException("3D Coordinate has NaN ordinate");
        }
        return pbdDotNormal / this.normal.length();
    }

    public final int closestAxisPlane() {
        double xmag = Math.INSTANCE.abs(this.normal.getX());
        double ymag = Math.INSTANCE.abs(this.normal.getY());
        double zmag = Math.INSTANCE.abs(this.normal.getZ());
        if (xmag > ymag) {
            return xmag > zmag ? 2 : 1;
        }
        if (zmag > ymag) {
            return 1;
        }
        return 3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/math/Plane3D$Companion;", "", "<init>", "()V", "XY_PLANE", "", "YZ_PLANE", "XZ_PLANE", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

