/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.legacy.map.TreeMap;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentNode;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\r\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0086\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0014\u0010#\u001a\u00020\u00132\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010)J\u0011\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0(\u00a2\u0006\u0002\u0010+J \u0010.\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010/\u001a\u000200H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0(8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010+\u00a8\u00061"}, d2={"Lorg/locationtech/jts/noding/SegmentNodeList;", "", "edge", "Lorg/locationtech/jts/noding/NodedSegmentString;", "<init>", "(Lorg/locationtech/jts/noding/NodedSegmentString;)V", "getEdge", "()Lorg/locationtech/jts/noding/NodedSegmentString;", "nodeMap", "", "Lorg/locationtech/jts/noding/SegmentNode;", "add", "intPt", "Lorg/locationtech/jts/geom/Coordinate;", "segmentIndex", "", "iterator", "", "addEndpoints", "", "addCollapsedNodes", "findCollapsesFromExistingVertices", "collapsedVertexIndexes", "", "findCollapsesFromInsertedNodes", "findCollapseIndex", "", "ei0", "ei1", "collapsedVertexIndex", "", "addSplitEdges", "edgeList", "", "Lorg/locationtech/jts/noding/SegmentString;", "checkSplitEdgesCorrectness", "splitEdges", "", "createSplitEdge", "createSplitEdgePts", "", "(Lorg/locationtech/jts/noding/SegmentNode;Lorg/locationtech/jts/noding/SegmentNode;)[Lorg/locationtech/jts/geom/Coordinate;", "getSplitCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "nodedCoordinates", "getNodedCoordinates", "addEdgeCoordinates", "coordList", "Lorg/locationtech/jts/geom/CoordinateList;", "kts-core"})
public final class SegmentNodeList {
    @NotNull
    private final NodedSegmentString edge;
    @NotNull
    private final Map<SegmentNode, Object> nodeMap;

    public SegmentNodeList(@NotNull NodedSegmentString edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.edge = edge;
        this.nodeMap = new TreeMap(null, 1, null);
    }

    @NotNull
    public final NodedSegmentString getEdge() {
        return this.edge;
    }

    @NotNull
    public final SegmentNode add(@NotNull Coordinate intPt, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)intPt, (String)"intPt");
        SegmentNode eiNew = new SegmentNode(this.edge, intPt, segmentIndex, this.edge.getSegmentOctant(segmentIndex));
        SegmentNode ei = (SegmentNode)this.nodeMap.get(eiNew);
        if (ei != null) {
            Assert.INSTANCE.isTrue(ei.getCoord().equals2D(intPt), "Found equal nodes with different coordinates");
            return ei;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    @NotNull
    public final Iterator<?> iterator() {
        return this.nodeMap.values().iterator();
    }

    private final void addEndpoints() {
        int maxSegIndex = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0);
        this.add(this.edge.getCoordinate(maxSegIndex), maxSegIndex);
    }

    private final void addCollapsedNodes() {
        List collapsedVertexIndexes = new ArrayList();
        this.findCollapsesFromInsertedNodes(collapsedVertexIndexes);
        this.findCollapsesFromExistingVertices(collapsedVertexIndexes);
        for (Object e : collapsedVertexIndexes) {
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
            int vertexIndex = (Integer)e;
            this.add(this.edge.getCoordinate(vertexIndex), vertexIndex);
        }
    }

    private final void findCollapsesFromExistingVertices(List<Object> collapsedVertexIndexes) {
        int n = this.edge.size() - 2;
        for (int i = 0; i < n; ++i) {
            Coordinate p0 = this.edge.getCoordinate(i);
            Coordinate p1 = this.edge.getCoordinate(i + 1);
            Coordinate p2 = this.edge.getCoordinate(i + 2);
            if (!p0.equals2D(p2)) continue;
            collapsedVertexIndexes.add(i + 1);
        }
    }

    private final void findCollapsesFromInsertedNodes(List<Object> collapsedVertexIndexes) {
        int[] collapsedVertexIndex = new int[1];
        Iterator<?> it = this.iterator();
        Object obj = it.next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
        SegmentNode eiPrev = (SegmentNode)obj;
        while (it.hasNext()) {
            Object obj2 = it.next();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
            SegmentNode ei = (SegmentNode)obj2;
            boolean isCollapsed = this.findCollapseIndex(eiPrev, ei, collapsedVertexIndex);
            if (isCollapsed) {
                collapsedVertexIndexes.add(collapsedVertexIndex[0]);
            }
            eiPrev = ei;
        }
    }

    private final boolean findCollapseIndex(SegmentNode ei0, SegmentNode ei1, int[] collapsedVertexIndex) {
        if (!ei0.getCoord().equals2D(ei1.getCoord())) {
            return false;
        }
        int numVerticesBetween = ei1.getSegmentIndex() - ei0.getSegmentIndex();
        if (!ei1.isInterior()) {
            --numVerticesBetween;
        }
        if (numVerticesBetween == 1) {
            collapsedVertexIndex[0] = ei0.getSegmentIndex() + 1;
            return true;
        }
        return false;
    }

    public final void addSplitEdges(@NotNull Collection<SegmentString> edgeList) {
        Intrinsics.checkNotNullParameter(edgeList, (String)"edgeList");
        this.addEndpoints();
        this.addCollapsedNodes();
        Iterator<?> it = this.iterator();
        Object obj = it.next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
        SegmentNode eiPrev = (SegmentNode)obj;
        while (it.hasNext()) {
            Object obj2 = it.next();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
            SegmentNode ei = (SegmentNode)obj2;
            SegmentString newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    private final void checkSplitEdgesCorrectness(List<?> splitEdges) {
        Coordinate[] edgePts = this.edge.getCoordinates();
        Object obj = splitEdges.get(0);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
        SegmentString split0 = (SegmentString)obj;
        Coordinate pt0 = split0.getCoordinate(0);
        if (!pt0.equals2D(edgePts[0])) {
            throw new RuntimeException("bad split edge start point at " + pt0);
        }
        Object obj2 = splitEdges.get(splitEdges.size() - 1);
        Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
        SegmentString splitn = (SegmentString)obj2;
        Coordinate[] splitnPts = splitn.getCoordinates();
        Coordinate ptn = splitnPts[splitnPts.length - 1];
        if (!ptn.equals2D(edgePts[edgePts.length - 1])) {
            throw new RuntimeException("bad split edge end point at " + ptn);
        }
    }

    private final SegmentString createSplitEdge(SegmentNode ei0, SegmentNode ei1) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        return new NodedSegmentString(pts, this.edge.getData());
    }

    private final Coordinate[] createSplitEdgePts(SegmentNode ei0, SegmentNode ei1) {
        int n;
        boolean useIntPt1;
        int npts = ei1.getSegmentIndex() - ei0.getSegmentIndex() + 2;
        if (npts == 2) {
            Coordinate[] coordinateArray = new Coordinate[]{new Coordinate(ei0.getCoord()), new Coordinate(ei1.getCoord())};
            return coordinateArray;
        }
        Coordinate lastSegStartPt = this.edge.getCoordinate(ei1.getSegmentIndex());
        boolean bl = useIntPt1 = ei1.isInterior() || !ei1.getCoord().equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Object[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.getCoord());
        int i = ei0.getSegmentIndex() + 1;
        if (i <= (n = ei1.getSegmentIndex())) {
            while (true) {
                pts[ipt++] = this.edge.getCoordinate(i);
                if (i == n) break;
                ++i;
            }
        }
        if (useIntPt1) {
            pts[ipt] = new Coordinate(ei1.getCoord());
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])pts);
    }

    @NotNull
    public final Coordinate[] getSplitCoordinates() {
        CoordinateList coordList = new CoordinateList();
        this.addEndpoints();
        Iterator<?> it = this.iterator();
        SegmentNode eiPrev = (SegmentNode)it.next();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
            SegmentNode ei = (SegmentNode)obj;
            SegmentNode segmentNode = eiPrev;
            Intrinsics.checkNotNull((Object)segmentNode);
            this.addEdgeCoordinates(segmentNode, ei, coordList);
            eiPrev = ei;
        }
        return coordList.toCoordinateArray();
    }

    @NotNull
    public final Coordinate[] getNodedCoordinates() {
        CoordinateList coordList = new CoordinateList();
        this.addEndpoints();
        Iterator<?> it = this.iterator();
        Object obj = it.next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
        SegmentNode eiPrev = (SegmentNode)obj;
        while (it.hasNext()) {
            Object obj2 = it.next();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentNode");
            SegmentNode ei = (SegmentNode)obj2;
            this.addEdgeCoordinates(eiPrev, ei, coordList);
            eiPrev = ei;
        }
        return coordList.toCoordinateArray();
    }

    private final void addEdgeCoordinates(SegmentNode ei0, SegmentNode ei1, CoordinateList coordList) {
        Coordinate[] pts = this.createSplitEdgePts(ei0, ei1);
        coordList.add(pts, false);
    }
}

