/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.noding.InteriorIntersectionFinderAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.HotPixel;
import org.locationtech.jts.noding.snapround.MCIndexPointSnapper;

@Deprecated(message="Not robust. Use {@link SnapRoundingNoder} instead.\n \n  ")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001e\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u001c\u001a\u00020\u00152\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0012\u0010\u001e\u001a\u00020\u00152\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/noding/snapround/MCIndexSnapRounder;", "Lorg/locationtech/jts/noding/Noder;", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "scaleFactor", "", "noder", "Lorg/locationtech/jts/noding/MCIndexNoder;", "pointSnapper", "Lorg/locationtech/jts/noding/snapround/MCIndexPointSnapper;", "nodedSegStrings", "", "nodedSubstrings", "Lorg/locationtech/jts/noding/SegmentString;", "getNodedSubstrings", "()Ljava/util/Collection;", "computeNodes", "", "inputSegmentStrings", "snapRound", "segStrings", "findInteriorIntersections", "", "Lorg/locationtech/jts/geom/Coordinate;", "computeIntersectionSnaps", "snapPts", "computeVertexSnaps", "edges", "e", "Lorg/locationtech/jts/noding/NodedSegmentString;", "kts-core"})
public final class MCIndexSnapRounder
implements Noder {
    @NotNull
    private final PrecisionModel pm;
    @NotNull
    private final LineIntersector li;
    private final double scaleFactor;
    @Nullable
    private MCIndexNoder noder;
    @Nullable
    private MCIndexPointSnapper pointSnapper;
    @Nullable
    private Collection<?> nodedSegStrings;

    public MCIndexSnapRounder(@NotNull PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(this.pm);
        this.scaleFactor = this.pm.getScale();
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        return NodedSegmentString.Companion.getNodedSubstrings(this.nodedSegStrings);
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> inputSegmentStrings) {
        Intrinsics.checkNotNullParameter(inputSegmentStrings, (String)"inputSegmentStrings");
        this.nodedSegStrings = inputSegmentStrings;
        MCIndexNoder mCIndexNoder = this.noder = new MCIndexNoder();
        Intrinsics.checkNotNull((Object)mCIndexNoder);
        this.pointSnapper = new MCIndexPointSnapper(mCIndexNoder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private final void snapRound(Collection<? extends SegmentString> segStrings, LineIntersector li) {
        List<Coordinate> intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps((Collection)intersections);
        this.computeVertexSnaps(segStrings);
    }

    private final List<Coordinate> findInteriorIntersections(Collection<? extends SegmentString> segStrings, LineIntersector li) {
        InteriorIntersectionFinderAdder intFinderAdder = new InteriorIntersectionFinderAdder(li);
        MCIndexNoder mCIndexNoder = this.noder;
        Intrinsics.checkNotNull((Object)mCIndexNoder);
        mCIndexNoder.setSegmentIntersector(intFinderAdder);
        MCIndexNoder mCIndexNoder2 = this.noder;
        Intrinsics.checkNotNull((Object)mCIndexNoder2);
        mCIndexNoder2.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private final void computeIntersectionSnaps(Collection<?> snapPts) {
        for (Object obj : snapPts) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
            Coordinate snapPt = (Coordinate)obj;
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor);
            MCIndexPointSnapper mCIndexPointSnapper = this.pointSnapper;
            Intrinsics.checkNotNull((Object)mCIndexPointSnapper);
            MCIndexPointSnapper.snap$default(mCIndexPointSnapper, hotPixel, null, 0, 6, null);
        }
    }

    public final void computeVertexSnaps(@NotNull Collection<?> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        for (Object obj : edges) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.NodedSegmentString");
            NodedSegmentString edge0 = (NodedSegmentString)obj;
            this.computeVertexSnaps(edge0);
        }
    }

    private final void computeVertexSnaps(NodedSegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        int n = pts0.length;
        for (int i = 0; i < n; ++i) {
            HotPixel hotPixel = new HotPixel(pts0[i], this.scaleFactor);
            MCIndexPointSnapper mCIndexPointSnapper = this.pointSnapper;
            Intrinsics.checkNotNull((Object)mCIndexPointSnapper);
            boolean isNodeAdded = mCIndexPointSnapper.snap(hotPixel, e, i);
            if (!isNodeAdded) continue;
            e.addIntersection(pts0[i], i);
        }
    }
}

