/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.legacy.TreeSet;
import org.locationtech.jts.legacy.map.TreeMap;

@Deprecated(message="Replaced by org.locationtech.jts.operation.valid.IsSimpleOp")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0017\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0015H\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0016H\u0007J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J.\u0010!\u001a\u00020\"2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010%0$2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\fH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/operation/IsSimpleOp;", "", "<init>", "()V", "geom", "Lorg/locationtech/jts/geom/Geometry;", "(Lorg/locationtech/jts/geom/Geometry;)V", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "inputGeom", "isClosedEndpointsInInterior", "", "value", "Lorg/locationtech/jts/geom/Coordinate;", "nonSimpleLocation", "getNonSimpleLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "isSimple", "()Z", "computeSimple", "Lorg/locationtech/jts/geom/LineString;", "Lorg/locationtech/jts/geom/MultiLineString;", "mp", "Lorg/locationtech/jts/geom/MultiPoint;", "isSimpleMultiPoint", "isSimplePolygonal", "isSimpleGeometryCollection", "isSimpleLinearGeometry", "hasNonEndpointIntersection", "graph", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "hasClosedEndpointIntersection", "addEndpoint", "", "endPoints", "", "Lorg/locationtech/jts/operation/IsSimpleOp$EndpointInfo;", "p", "isClosed", "EndpointInfo", "kts-core"})
public final class IsSimpleOp {
    @Nullable
    private Geometry inputGeom;
    private boolean isClosedEndpointsInInterior;
    @Nullable
    private Coordinate nonSimpleLocation;

    @Nullable
    public final Coordinate getNonSimpleLocation() {
        return this.nonSimpleLocation;
    }

    @Deprecated(message="use IsSimpleOp(Geometry)")
    public IsSimpleOp() {
        this.isClosedEndpointsInInterior = true;
    }

    public IsSimpleOp(@Nullable Geometry geom) {
        this.isClosedEndpointsInInterior = true;
        this.inputGeom = geom;
    }

    public IsSimpleOp(@Nullable Geometry geom, @NotNull BoundaryNodeRule boundaryNodeRule) {
        Intrinsics.checkNotNullParameter((Object)boundaryNodeRule, (String)"boundaryNodeRule");
        this.isClosedEndpointsInInterior = true;
        this.inputGeom = geom;
        this.isClosedEndpointsInInterior = !boundaryNodeRule.isInBoundary(2);
    }

    public final boolean isSimple() {
        this.nonSimpleLocation = null;
        return this.computeSimple(this.inputGeom);
    }

    private final boolean computeSimple(Geometry geom) {
        boolean bl;
        this.nonSimpleLocation = null;
        Geometry geometry = geom;
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.isEmpty()) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            bl = this.isSimplePolygonal(geom);
        } else {
            Geometry geometry2 = geom;
            GeometryCollection geometryCollection = geometry2 instanceof GeometryCollection ? (GeometryCollection)geometry2 : null;
            if (geometryCollection != null) {
                GeometryCollection it = geometryCollection;
                boolean bl2 = false;
                bl = this.isSimpleGeometryCollection(it);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    @Deprecated(message="use isSimple()")
    public final boolean isSimple(@NotNull LineString geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.isSimpleLinearGeometry(geom);
    }

    @Deprecated(message="use isSimple()")
    public final boolean isSimple(@NotNull MultiLineString geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        return this.isSimpleLinearGeometry(geom);
    }

    @Deprecated(message="use isSimple()")
    public final boolean isSimple(@NotNull MultiPoint mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        return this.isSimpleMultiPoint(mp);
    }

    private final boolean isSimpleMultiPoint(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        Set points = (Set)((Object)new TreeSet(null, null, 3, null));
        int n = mp.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = mp.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt = (Point)geometry;
            Coordinate p = pt.getCoordinate();
            if (CollectionsKt.contains((Iterable)points, (Object)p)) {
                this.nonSimpleLocation = p;
                return false;
            }
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            points.add(coordinate);
        }
        return true;
    }

    private final boolean isSimplePolygonal(Geometry geom) {
        List<Geometry> rings = LinearComponentExtracter.Companion.getLines(geom);
        for (Geometry geometry : rings) {
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LinearRing");
            LinearRing ring = (LinearRing)geometry;
            if (this.isSimpleLinearGeometry(ring)) continue;
            return false;
        }
        return true;
    }

    private final boolean isSimpleGeometryCollection(Geometry geom) {
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.computeSimple(comp)) continue;
            return false;
        }
        return true;
    }

    private final boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        GeometryGraph graph = new GeometryGraph(0, geom, null, 4, null);
        LineIntersector li = new RobustLineIntersector();
        SegmentIntersector si = graph.computeSelfNodes(li, true);
        if (!si.hasIntersection()) {
            return true;
        }
        if (si.hasProperIntersection()) {
            this.nonSimpleLocation = si.getProperIntersectionPoint();
            return false;
        }
        if (this.hasNonEndpointIntersection(graph)) {
            return false;
        }
        return !this.isClosedEndpointsInInterior || !this.hasClosedEndpointIntersection(graph);
    }

    private final boolean hasNonEndpointIntersection(GeometryGraph graph) {
        Iterator<?> i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            int maxSegmentIndex = e.getMaximumSegmentIndex();
            Iterator<?> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                Object obj2 = eiIt.next();
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
                EdgeIntersection ei = (EdgeIntersection)obj2;
                if (ei.isEndPoint(maxSegmentIndex)) continue;
                this.nonSimpleLocation = ei.getCoordinate();
                return true;
            }
        }
        return false;
    }

    private final boolean hasClosedEndpointIntersection(GeometryGraph graph) {
        Map endPoints = new TreeMap(null, 1, null);
        IsSimpleOp $this$hasClosedEndpointIntersection_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<?> i = graph.getEdgeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            boolean isClosed = e.isClosed();
            Coordinate p0 = e.getCoordinate(0);
            $this$hasClosedEndpointIntersection_u24lambda_u240.addEndpoint(endPoints, p0, isClosed);
            Coordinate p1 = e.getCoordinate(e.getNumPoints() - 1);
            $this$hasClosedEndpointIntersection_u24lambda_u240.addEndpoint(endPoints, p1, isClosed);
        }
        for (Object v : endPoints.values()) {
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.IsSimpleOp.EndpointInfo");
            EndpointInfo eiInfo = (EndpointInfo)v;
            if (!eiInfo.isClosed() || eiInfo.getDegree() == 2) continue;
            this.nonSimpleLocation = eiInfo.getCoordinate();
            return true;
        }
        return false;
    }

    private final void addEndpoint(Map<Coordinate, EndpointInfo> endPoints, Coordinate p, boolean isClosed) {
        EndpointInfo eiInfo = endPoints.get(p);
        if (eiInfo == null) {
            eiInfo = new EndpointInfo(p);
            endPoints.put(p, eiInfo);
        }
        eiInfo.addEndpoint(isClosed);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/IsSimpleOp$EndpointInfo;", "", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "setCoordinate", "isClosed", "", "()Z", "setClosed", "(Z)V", "degree", "", "getDegree", "()I", "setDegree", "(I)V", "addEndpoint", "", "kts-core"})
    private static final class EndpointInfo {
        @Nullable
        private Coordinate coordinate;
        private boolean isClosed;
        private int degree;

        public EndpointInfo(@Nullable Coordinate coordinate) {
            this.coordinate = coordinate;
        }

        @Nullable
        public final Coordinate getCoordinate() {
            return this.coordinate;
        }

        public final void setCoordinate(@Nullable Coordinate coordinate) {
            this.coordinate = coordinate;
        }

        public final boolean isClosed() {
            return this.isClosed;
        }

        public final void setClosed(boolean bl) {
            this.isClosed = bl;
        }

        public final int getDegree() {
            return this.degree;
        }

        public final void setDegree(int n) {
            this.degree = n;
        }

        public final void addEndpoint(boolean isClosed) {
            int n = this.degree;
            this.degree = n + 1;
            this.isClosed |= isClosed;
        }
    }
}

