/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 !2\u00020\u0001:\u0001!B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/buffer/BufferInputLineSimplifier;", "", "inputLine", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "distanceTol", "", "isDeleted", "", "angleOrientation", "", "simplify", "(D)[Lorg/locationtech/jts/geom/Coordinate;", "deleteShallowConcavities", "", "findNextNonDeletedIndex", "index", "collapseLine", "()[Lorg/locationtech/jts/geom/Coordinate;", "isDeletable", "i0", "i1", "i2", "isShallowConcavity", "p0", "p1", "p2", "isShallowSampled", "isShallow", "isConcave", "Companion", "kts-core"})
public final class BufferInputLineSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] inputLine;
    private double distanceTol;
    @Nullable
    private byte[] isDeleted;
    private int angleOrientation;
    private static final byte INIT = 0;
    private static final byte DELETE = 1;
    private static final byte KEEP = 1;
    private static final byte NUM_PTS_TO_CHECK = 10;

    public BufferInputLineSimplifier(@NotNull Coordinate[] inputLine) {
        Intrinsics.checkNotNullParameter((Object)inputLine, (String)"inputLine");
        this.inputLine = inputLine;
        this.angleOrientation = 1;
    }

    @NotNull
    public final Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.INSTANCE.abs(distanceTol);
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new byte[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private final boolean deleteShallowConcavities() {
        int index = 1;
        int midIndex = this.findNextNonDeletedIndex(index);
        int lastIndex = this.findNextNonDeletedIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < this.inputLine.length) {
            boolean isMiddleVertexDeleted = false;
            if (this.isDeletable(index, midIndex, lastIndex, this.distanceTol)) {
                Intrinsics.checkNotNull((Object)this.isDeleted);
                this.isDeleted[midIndex] = 1;
                isMiddleVertexDeleted = true;
                isChanged = true;
            }
            index = isMiddleVertexDeleted ? lastIndex : midIndex;
            midIndex = this.findNextNonDeletedIndex(index);
            lastIndex = this.findNextNonDeletedIndex(midIndex);
        }
        return isChanged;
    }

    private final int findNextNonDeletedIndex(int index) {
        int next;
        for (next = index + 1; next < this.inputLine.length; ++next) {
            Intrinsics.checkNotNull((Object)this.isDeleted);
            if (this.isDeleted[next] != 1) break;
        }
        return next;
    }

    private final Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        int n = this.inputLine.length;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNull((Object)this.isDeleted);
            if (this.isDeleted[i] == 1) continue;
            coordList.add(this.inputLine[i]);
        }
        return coordList.toCoordinateArray();
    }

    private final boolean isDeletable(int i0, int i1, int i2, double distanceTol) {
        Coordinate p0 = this.inputLine[i0];
        Coordinate p1 = this.inputLine[i1];
        Coordinate p2 = this.inputLine[i2];
        if (!this.isConcave(p0, p1, p2)) {
            return false;
        }
        return !this.isShallow(p0, p1, p2, distanceTol) ? false : this.isShallowSampled(p0, p1, i0, i2, distanceTol);
    }

    private final boolean isShallowConcavity(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        boolean isAngleToSimplify;
        int orientation = Orientation.index(p0, p1, p2);
        boolean bl = isAngleToSimplify = orientation == this.angleOrientation;
        if (!isAngleToSimplify) {
            return false;
        }
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private final boolean isShallowSampled(Coordinate p0, Coordinate p2, int i0, int i2, double distanceTol) {
        int inc = (i2 - i0) / 10;
        if (inc <= 0) {
            inc = 1;
        }
        for (int i = i0; i < i2; i += inc) {
            if (this.isShallow(p0, p2, this.inputLine[i], distanceTol)) continue;
            return false;
        }
        return true;
    }

    private final boolean isShallow(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        double dist = Distance.pointToSegment(p1, p0, p2);
        return dist < distanceTol;
    }

    private final boolean isConcave(Coordinate p0, Coordinate p1, Coordinate p2) {
        int orientation = Orientation.index(p0, p1, p2);
        return orientation == this.angleOrientation;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferInputLineSimplifier$Companion;", "", "<init>", "()V", "simplify", "", "Lorg/locationtech/jts/geom/Coordinate;", "inputLine", "distanceTol", "", "([Lorg/locationtech/jts/geom/Coordinate;D)[Lorg/locationtech/jts/geom/Coordinate;", "INIT", "", "DELETE", "KEEP", "NUM_PTS_TO_CHECK", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Coordinate[] simplify(@NotNull Coordinate[] inputLine, double distanceTol) {
            Intrinsics.checkNotNullParameter((Object)inputLine, (String)"inputLine");
            BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
            return simp.simplify(distanceTol);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

