/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.ScaledNoder;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;
import org.locationtech.jts.operation.buffer.BufferBuilder;
import org.locationtech.jts.operation.buffer.BufferParameters;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferOp;", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/operation/buffer/BufferParameters;)V", "argGeom", "distance", "", "resultGeometry", "saveException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "isInvertOrientation", "", "setEndCapStyle", "", "endCapStyle", "", "setQuadrantSegments", "quadrantSegments", "getResultGeometry", "computeGeometry", "bufferReducedPrecision", "precisionDigits", "bufferOriginalPrecision", "createBufferBullder", "Lorg/locationtech/jts/operation/buffer/BufferBuilder;", "bufferFixedPrecision", "fixedPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "Companion", "kts-core"})
public final class BufferOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Geometry argGeom;
    private double distance;
    @NotNull
    private BufferParameters bufParams;
    @Nullable
    private Geometry resultGeometry;
    @Nullable
    private RuntimeException saveException;
    private boolean isInvertOrientation;
    private static final int CAP_ROUND = 1;
    private static final int CAP_BUTT = 2;
    private static final int CAP_FLAT = 2;
    private static final int CAP_SQUARE = 3;
    private static final int MAX_PRECISION_DIGITS = 12;

    public BufferOp(@Nullable Geometry g) {
        this.bufParams = new BufferParameters();
        this.argGeom = g;
    }

    public BufferOp(@Nullable Geometry g, @NotNull BufferParameters bufParams) {
        Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
        this.bufParams = new BufferParameters();
        this.argGeom = g;
        this.bufParams = bufParams;
    }

    public final void setEndCapStyle(int endCapStyle) {
        this.bufParams.setEndCapStyle(endCapStyle);
    }

    public final void setQuadrantSegments(int quadrantSegments) {
        this.bufParams.setQuadrantSegments(quadrantSegments);
    }

    @NotNull
    public final Geometry getResultGeometry(double distance) {
        this.distance = distance;
        this.computeGeometry();
        Geometry geometry = this.resultGeometry;
        Intrinsics.checkNotNull((Object)geometry);
        return geometry;
    }

    private final void computeGeometry() {
        this.bufferOriginalPrecision();
        if (this.resultGeometry != null) {
            return;
        }
        Geometry geometry = this.argGeom;
        Intrinsics.checkNotNull((Object)geometry);
        PrecisionModel argPM = geometry.getFactory().getPrecisionModel();
        if (Intrinsics.areEqual((Object)argPM.getType(), (Object)PrecisionModel.FIXED)) {
            this.bufferFixedPrecision(argPM);
        } else {
            this.bufferReducedPrecision();
        }
    }

    private final void bufferReducedPrecision() {
        for (int precDigits = 12; -1 < precDigits; --precDigits) {
            try {
                this.bufferReducedPrecision(precDigits);
            }
            catch (TopologyException ex) {
                this.saveException = ex;
            }
            if (this.resultGeometry == null) continue;
            return;
        }
        RuntimeException runtimeException = this.saveException;
        Intrinsics.checkNotNull((Object)runtimeException);
        throw runtimeException;
    }

    private final void bufferReducedPrecision(int precisionDigits) {
        double sizeBasedScaleFactor = BufferOp.Companion.precisionScaleFactor(this.argGeom, this.distance, precisionDigits);
        PrecisionModel fixedPM = new PrecisionModel(sizeBasedScaleFactor);
        this.bufferFixedPrecision(fixedPM);
    }

    private final void bufferOriginalPrecision() {
        try {
            BufferBuilder bufBuilder = this.createBufferBullder();
            this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
        }
        catch (RuntimeException ex) {
            this.saveException = ex;
        }
    }

    private final BufferBuilder createBufferBullder() {
        BufferBuilder bufBuilder = new BufferBuilder(this.bufParams);
        bufBuilder.setInvertOrientation(this.isInvertOrientation);
        return bufBuilder;
    }

    private final void bufferFixedPrecision(PrecisionModel fixedPM) {
        Noder snapNoder = new SnapRoundingNoder(new PrecisionModel(1.0));
        Noder noder = new ScaledNoder(snapNoder, fixedPM.getScale(), 0.0, 0.0, 12, null);
        BufferBuilder bufBuilder = this.createBufferBullder();
        bufBuilder.setWorkingPrecisionModel(fixedPM);
        bufBuilder.setNoder(noder);
        this.resultGeometry = bufBuilder.buffer(this.argGeom, this.distance);
    }

    @JvmStatic
    @NotNull
    public static final Geometry bufferOp(@NotNull Geometry g, double distance) {
        return Companion.bufferOp(g, distance);
    }

    @JvmStatic
    @NotNull
    public static final Geometry bufferOp(@Nullable Geometry g, double distance, @NotNull BufferParameters params) {
        return Companion.bufferOp(g, distance, params);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0007J\"\u0010\u0019\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0005J&\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!J\u001a\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0016H\u0002J \u0010%\u001a\u00020&2\b\u0010#\u001a\u0004\u0018\u00010\u00162\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\bR\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferOp$Companion;", "", "<init>", "()V", "CAP_ROUND", "", "getCAP_ROUND$annotations", "getCAP_ROUND", "()I", "CAP_BUTT", "getCAP_BUTT$annotations", "getCAP_BUTT", "CAP_FLAT", "getCAP_FLAT$annotations", "getCAP_FLAT", "CAP_SQUARE", "getCAP_SQUARE$annotations", "getCAP_SQUARE", "MAX_PRECISION_DIGITS", "precisionScaleFactor", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "distance", "maxPrecisionDigits", "bufferOp", "params", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "quadrantSegments", "endCapStyle", "bufferByZero", "geom", "isBothOrientations", "", "combine", "poly0", "poly1", "extractPolygons", "", "polys", "", "Lorg/locationtech/jts/geom/Polygon;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCAP_ROUND() {
            return CAP_ROUND;
        }

        @Deprecated(message="use BufferParameters")
        public static /* synthetic */ void getCAP_ROUND$annotations() {
        }

        public final int getCAP_BUTT() {
            return CAP_BUTT;
        }

        @Deprecated(message="use BufferParameters")
        public static /* synthetic */ void getCAP_BUTT$annotations() {
        }

        public final int getCAP_FLAT() {
            return CAP_FLAT;
        }

        @Deprecated(message="use BufferParameters")
        public static /* synthetic */ void getCAP_FLAT$annotations() {
        }

        public final int getCAP_SQUARE() {
            return CAP_SQUARE;
        }

        @Deprecated(message="use BufferParameters")
        public static /* synthetic */ void getCAP_SQUARE$annotations() {
        }

        private final double precisionScaleFactor(Geometry g, double distance, int maxPrecisionDigits) {
            Geometry geometry = g;
            Intrinsics.checkNotNull((Object)geometry);
            Envelope env = geometry.getEnvelopeInternal();
            double envMax = MathUtil.INSTANCE.max(java.lang.Math.abs(env.getMaxX()), java.lang.Math.abs(env.getMaxY()), java.lang.Math.abs(env.getMinX()), java.lang.Math.abs(env.getMinY()));
            double expandByDistance = distance > 0.0 ? distance : 0.0;
            double bufEnvMax = envMax + (double)2 * expandByDistance;
            int bufEnvPrecisionDigits = (int)(Math.INSTANCE.log(bufEnvMax) / Math.INSTANCE.log(10.0) + 1.0);
            int minUnitLog10 = maxPrecisionDigits - bufEnvPrecisionDigits;
            return Math.INSTANCE.pow(10.0, minUnitLog10);
        }

        @JvmStatic
        @NotNull
        public final Geometry bufferOp(@NotNull Geometry g, double distance) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            BufferOp gBuf = new BufferOp(g);
            return gBuf.getResultGeometry(distance);
        }

        @JvmStatic
        @NotNull
        public final Geometry bufferOp(@Nullable Geometry g, double distance, @NotNull BufferParameters params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            BufferOp bufOp = new BufferOp(g, params);
            return bufOp.getResultGeometry(distance);
        }

        @NotNull
        public final Geometry bufferOp(@NotNull Geometry g, double distance, int quadrantSegments) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            BufferOp bufOp = new BufferOp(g);
            bufOp.setQuadrantSegments(quadrantSegments);
            return bufOp.getResultGeometry(distance);
        }

        @NotNull
        public final Geometry bufferOp(@NotNull Geometry g, double distance, int quadrantSegments, int endCapStyle) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            BufferOp bufOp = new BufferOp(g);
            bufOp.setQuadrantSegments(quadrantSegments);
            bufOp.setEndCapStyle(endCapStyle);
            return bufOp.getResultGeometry(distance);
        }

        @NotNull
        public final Geometry bufferByZero(@NotNull Geometry geom, boolean isBothOrientations) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Geometry buf0 = geom.buffer(0.0);
            if (!isBothOrientations) {
                return buf0;
            }
            BufferOp op = new BufferOp(geom);
            op.isInvertOrientation = true;
            Geometry buf0Inv = op.getResultGeometry(0.0);
            return this.combine(buf0, buf0Inv);
        }

        private final Geometry combine(Geometry poly0, Geometry poly1) {
            Geometry geometry = poly1;
            Intrinsics.checkNotNull((Object)geometry);
            if (geometry.isEmpty()) {
                return poly0;
            }
            if (poly0.isEmpty()) {
                return poly1;
            }
            List polys = new ArrayList();
            this.extractPolygons(poly0, polys);
            this.extractPolygons(poly1, polys);
            return polys.size() == 1 ? (Geometry)polys.get(0) : (Geometry)poly0.getFactory().createMultiPolygon(GeometryFactory.Companion.toPolygonArray(polys));
        }

        private final void extractPolygons(Geometry poly0, List<Polygon> polys) {
            Geometry geometry = poly0;
            Intrinsics.checkNotNull((Object)geometry);
            int n = geometry.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry2 = poly0.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                polys.add((Polygon)geometry2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

