/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0018\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/operation/buffer/RightmostEdgeFinder;", "", "<init>", "()V", "minIndex", "", "value", "Lorg/locationtech/jts/geom/Coordinate;", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "minDe", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "edge", "getEdge", "()Lorg/locationtech/jts/geomgraph/DirectedEdge;", "findEdge", "", "dirEdgeList", "", "findRightmostEdgeAtNode", "findRightmostEdgeAtVertex", "checkForRightmostCoordinate", "de", "getRightmostSide", "index", "getRightmostSideOfSegment", "i", "kts-core"})
public final class RightmostEdgeFinder {
    private int minIndex = -1;
    @Nullable
    private Coordinate coordinate;
    @Nullable
    private DirectedEdge minDe;
    @Nullable
    private DirectedEdge edge;

    @Nullable
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    @Nullable
    public final DirectedEdge getEdge() {
        return this.edge;
    }

    /*
     * Unable to fully structure code
     */
    public final void findEdge(@NotNull List<DirectedEdge> dirEdgeList) {
        Intrinsics.checkNotNullParameter(dirEdgeList, (String)"dirEdgeList");
        i = dirEdgeList.iterator();
        while (i.hasNext()) {
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            if (!de.isForward()) continue;
            this.checkForRightmostCoordinate(de);
        }
        if (this.minIndex != 0) ** GOTO lbl-1000
        v0 = this.coordinate;
        Intrinsics.checkNotNull((Object)v0);
        v1 = this.minDe;
        Intrinsics.checkNotNull((Object)v1);
        if (Intrinsics.areEqual((Object)v0, (Object)v1.getCoordinate())) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assert.INSTANCE.isTrue(v2, "inconsistency in rightmost processing");
        if (this.minIndex == 0) {
            this.findRightmostEdgeAtNode();
        } else {
            this.findRightmostEdgeAtVertex();
        }
        this.edge = this.minDe;
        rightmostSide = this.getRightmostSide(this.minDe, this.minIndex);
        if (rightmostSide == 1) {
            v3 = this.minDe;
            Intrinsics.checkNotNull((Object)v3);
            this.edge = v3.getSym();
        }
    }

    private final void findRightmostEdgeAtNode() {
        DirectedEdgeStar star;
        DirectedEdge directedEdge = this.minDe;
        Intrinsics.checkNotNull((Object)directedEdge);
        Node node = directedEdge.getNode();
        Intrinsics.checkNotNull((Object)node);
        Node node2 = node;
        DirectedEdgeStar directedEdgeStar = star = (DirectedEdgeStar)node2.getEdges();
        Intrinsics.checkNotNull((Object)directedEdgeStar);
        DirectedEdge directedEdge2 = this.minDe = directedEdgeStar.getRightmostEdge();
        Intrinsics.checkNotNull((Object)directedEdge2);
        if (!directedEdge2.isForward()) {
            DirectedEdge directedEdge3 = this.minDe;
            Intrinsics.checkNotNull((Object)directedEdge3);
            DirectedEdge directedEdge4 = this.minDe = directedEdge3.getSym();
            Intrinsics.checkNotNull((Object)directedEdge4);
            this.minIndex = directedEdge4.getEdge().getCoordinates().length - 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void findRightmostEdgeAtVertex() {
        v0 = this.minDe;
        Intrinsics.checkNotNull((Object)v0);
        pts = v0.getEdge().getCoordinates();
        Assert.INSTANCE.isTrue(this.minIndex > 0 && this.minIndex < pts.length, "rightmost point expected to be interior vertex of edge");
        pPrev = pts[this.minIndex - 1];
        pNext = pts[this.minIndex + 1];
        orientation = Orientation.index(this.coordinate, pNext, pPrev);
        usePrev = false;
        v1 = pPrev.y;
        v2 = this.coordinate;
        Intrinsics.checkNotNull((Object)v2);
        if (!(v1 < v2.y)) ** GOTO lbl-1000
        v3 = pNext.y;
        v4 = this.coordinate;
        Intrinsics.checkNotNull((Object)v4);
        if (v3 < v4.y && orientation == 1) {
            usePrev = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = pPrev.y;
            v6 = this.coordinate;
            Intrinsics.checkNotNull((Object)v6);
            if (v5 > v6.y) {
                v7 = pNext.y;
                v8 = this.coordinate;
                Intrinsics.checkNotNull((Object)v8);
                if (v7 > v8.y && orientation == -1) {
                    usePrev = true;
                }
            }
        }
        if (usePrev) {
            --this.minIndex;
        }
    }

    private final void checkForRightmostCoordinate(DirectedEdge de) {
        DirectedEdge directedEdge = de;
        Intrinsics.checkNotNull((Object)directedEdge);
        Coordinate[] coord = directedEdge.getEdge().getCoordinates();
        int n = coord.length - 1;
        for (int i = 0; i < n; ++i) {
            if (this.coordinate != null) {
                double d = coord[i].x;
                Coordinate coordinate = this.coordinate;
                Intrinsics.checkNotNull((Object)coordinate);
                if (!(d > coordinate.x)) continue;
            }
            this.minDe = de;
            this.minIndex = i;
            this.coordinate = coord[i];
        }
    }

    private final int getRightmostSide(DirectedEdge de, int index) {
        int side = this.getRightmostSideOfSegment(de, index);
        if (side < 0) {
            side = this.getRightmostSideOfSegment(de, index - 1);
        }
        if (side < 0) {
            this.coordinate = null;
            this.checkForRightmostCoordinate(de);
        }
        return side;
    }

    private final int getRightmostSideOfSegment(DirectedEdge de, int i) {
        DirectedEdge directedEdge = de;
        Intrinsics.checkNotNull((Object)directedEdge);
        Edge e = directedEdge.getEdge();
        Coordinate[] coord = e.getCoordinates();
        if (i < 0 || i + 1 >= coord.length) {
            return -1;
        }
        if (coord[i].y == coord[i + 1].y) {
            return -1;
        }
        int pos = 1;
        if (coord[i].y < coord[i + 1].y) {
            pos = 2;
        }
        return pos;
    }
}

