/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.operation.distance.GeometryLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0000J\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001a\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010!JU\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010*J/\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00002\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010-JE\u0010.\u001a\u00020#2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010/J\n\u00100\u001a\u000201H\u0096\u0080\u0004R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u00062"}, d2={"Lorg/locationtech/jts/operation/distance/FacetSequence;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "pts", "Lorg/locationtech/jts/geom/CoordinateSequence;", "start", "", "end", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/CoordinateSequence;II)V", "(Lorg/locationtech/jts/geom/CoordinateSequence;II)V", "(Lorg/locationtech/jts/geom/CoordinateSequence;I)V", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "size", "getCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "index", "isPoint", "", "()Z", "distance", "", "facetSeq", "nearestLocations", "", "Lorg/locationtech/jts/operation/distance/GeometryLocation;", "(Lorg/locationtech/jts/operation/distance/FacetSequence;)[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "computeDistanceLineLine", "locs", "(Lorg/locationtech/jts/operation/distance/FacetSequence;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)D", "updateNearestLocationsLineLine", "", "i", "p0", "p1", "j", "q0", "q1", "(ILorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/distance/FacetSequence;ILorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "computeDistancePointLine", "pt", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/distance/FacetSequence;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)D", "updateNearestLocationsPointLine", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/distance/FacetSequence;ILorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/operation/distance/GeometryLocation;)V", "toString", "", "kts-core"})
@SourceDebugExtension(value={"SMAP\nFacetSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetSequence.kt\norg/locationtech/jts/operation/distance/FacetSequence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1#2:231\n*E\n"})
public final class FacetSequence {
    @Nullable
    private Geometry geom;
    @NotNull
    private CoordinateSequence pts;
    private int start;
    private int end;

    public FacetSequence(@Nullable Geometry geom, @NotNull CoordinateSequence pts, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.geom = geom;
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(@NotNull CoordinateSequence pts, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.start = start;
        this.end = end;
    }

    public FacetSequence(@NotNull CoordinateSequence pts, int start) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        this.pts = pts;
        this.start = start;
        this.end = start + 1;
    }

    @NotNull
    public final Envelope getEnvelope() {
        Envelope env = new Envelope();
        int n = this.end;
        for (int i = this.start; i < n; ++i) {
            env.expandToInclude(this.pts.getX(i), this.pts.getY(i));
        }
        return env;
    }

    public final int size() {
        return this.end - this.start;
    }

    @NotNull
    public final Coordinate getCoordinate(int index) {
        return this.pts.getCoordinate(this.start + index);
    }

    public final boolean isPoint() {
        return this.end - this.start == 1;
    }

    public final double distance(@NotNull FacetSequence facetSeq) {
        double d;
        Intrinsics.checkNotNullParameter((Object)facetSeq, (String)"facetSeq");
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        if (isPoint && isPointOther) {
            pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            d = pt.distance(seqPt);
        } else if (isPoint) {
            pt = this.pts.getCoordinate(this.start);
            d = this.computeDistancePointLine(pt, facetSeq, null);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            d = this.computeDistancePointLine(seqPt, this, null);
        } else {
            d = this.computeDistanceLineLine(facetSeq, null);
        }
        double distance = d;
        return distance;
    }

    @NotNull
    public final GeometryLocation[] nearestLocations(@NotNull FacetSequence facetSeq) {
        Intrinsics.checkNotNullParameter((Object)facetSeq, (String)"facetSeq");
        boolean isPoint = this.isPoint();
        boolean isPointOther = facetSeq.isPoint();
        Object[] locs = new GeometryLocation[2];
        if (isPoint && isPointOther) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
            locs[1] = new GeometryLocation(facetSeq.geom, facetSeq.start, new Coordinate(seqPt));
        } else if (isPoint) {
            Coordinate pt = this.pts.getCoordinate(this.start);
            this.computeDistancePointLine(pt, facetSeq, (GeometryLocation[])locs);
        } else if (isPointOther) {
            Coordinate seqPt = facetSeq.pts.getCoordinate(facetSeq.start);
            this.computeDistancePointLine(seqPt, this, (GeometryLocation[])locs);
            Object tmp = locs[0];
            locs[0] = locs[1];
            locs[1] = tmp;
        } else {
            this.computeDistanceLineLine(facetSeq, (GeometryLocation[])locs);
        }
        return (GeometryLocation[])ArraysKt.requireNoNulls((Object[])locs);
    }

    private final double computeDistanceLineLine(FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        int n = this.end - 1;
        for (int i = this.start; i < n; ++i) {
            Coordinate p0 = this.pts.getCoordinate(i);
            Coordinate p1 = this.pts.getCoordinate(i + 1);
            int n2 = facetSeq.end - 1;
            for (int j = facetSeq.start; j < n2; ++j) {
                Coordinate q1;
                Coordinate q0 = facetSeq.pts.getCoordinate(j);
                double dist = Distance.segmentToSegment(p0, p1, q0, q1 = facetSeq.pts.getCoordinate(j + 1));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                if (locs != null) {
                    GeometryLocation[] it = locs;
                    boolean bl = false;
                    this.updateNearestLocationsLineLine(i, p0, p1, facetSeq, j, q0, q1, it);
                }
                if (!(minDistance <= 0.0)) continue;
                return minDistance;
            }
        }
        return minDistance;
    }

    private final void updateNearestLocationsLineLine(int i, Coordinate p0, Coordinate p1, FacetSequence facetSeq, int j, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        LineSegment seg0 = new LineSegment(p0, p1);
        LineSegment seg1 = new LineSegment(q0, q1);
        Coordinate[] closestPt = seg0.closestPoints(seg1);
        Coordinate coordinate = closestPt[0];
        Intrinsics.checkNotNull((Object)coordinate);
        locs[0] = new GeometryLocation(this.geom, i, new Coordinate(coordinate));
        Geometry geometry = facetSeq.geom;
        Coordinate coordinate2 = closestPt[1];
        Intrinsics.checkNotNull((Object)coordinate2);
        locs[1] = new GeometryLocation(geometry, j, new Coordinate(coordinate2));
    }

    private final double computeDistancePointLine(Coordinate pt, FacetSequence facetSeq, GeometryLocation[] locs) {
        double minDistance = Double.MAX_VALUE;
        int n = facetSeq.end - 1;
        for (int i = facetSeq.start; i < n; ++i) {
            Coordinate q1;
            Coordinate q0 = facetSeq.pts.getCoordinate(i);
            double dist = Distance.pointToSegment(pt, q0, q1 = facetSeq.pts.getCoordinate(i + 1));
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            if (locs != null) {
                GeometryLocation[] it = locs;
                boolean bl = false;
                this.updateNearestLocationsPointLine(pt, facetSeq, i, q0, q1, it);
            }
            if (!(minDistance <= 0.0)) continue;
            return minDistance;
        }
        return minDistance;
    }

    private final void updateNearestLocationsPointLine(Coordinate pt, FacetSequence facetSeq, int i, Coordinate q0, Coordinate q1, GeometryLocation[] locs) {
        locs[0] = new GeometryLocation(this.geom, this.start, new Coordinate(pt));
        LineSegment seg = new LineSegment(q0, q1);
        Coordinate segClosestPoint = seg.closestPoint(pt);
        locs[1] = new GeometryLocation(facetSeq.geom, i, new Coordinate(segClosestPoint));
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("LINESTRING ( ");
        Coordinate p = new Coordinate();
        int n = this.end;
        for (int i = this.start; i < n; ++i) {
            if (i > this.start) {
                buf.append(", ");
            }
            this.pts.getCoordinate(i, p);
            buf.append(p.x + " " + p.y);
        }
        buf.append(" )");
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

