/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/operation/distance/FacetSequenceTreeBuilder;", "", "<init>", "()V", "FACET_SEQUENCE_SIZE", "", "STR_TREE_NODE_CAPACITY", "build", "Lorg/locationtech/jts/index/strtree/STRtree;", "g", "Lorg/locationtech/jts/geom/Geometry;", "computeFacetSequences", "", "Lorg/locationtech/jts/operation/distance/FacetSequence;", "addFacetSequences", "", "geom", "pts", "Lorg/locationtech/jts/geom/CoordinateSequence;", "sections", "kts-core"})
public final class FacetSequenceTreeBuilder {
    @NotNull
    public static final FacetSequenceTreeBuilder INSTANCE = new FacetSequenceTreeBuilder();
    private static final int FACET_SEQUENCE_SIZE = 6;
    private static final int STR_TREE_NODE_CAPACITY = 4;

    private FacetSequenceTreeBuilder() {
    }

    @NotNull
    public final STRtree build(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        STRtree tree = new STRtree(4);
        List<FacetSequence> sections = this.computeFacetSequences(g);
        Iterator<FacetSequence> i = sections.iterator();
        while (i.hasNext()) {
            FacetSequence section;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
            tree.insert(section.getEnvelope(), (Object)section);
        }
        tree.build();
        return tree;
    }

    private final List<FacetSequence> computeFacetSequences(Geometry g) {
        List sections = new ArrayList();
        g.apply(new GeometryComponentFilter(sections){
            final /* synthetic */ List<FacetSequence> $sections;
            {
                this.$sections = $sections;
            }

            public void filter(Geometry geom) {
                Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
                CoordinateSequence seq = null;
                if (geom instanceof LineString) {
                    seq = ((LineString)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.access$addFacetSequences(FacetSequenceTreeBuilder.INSTANCE, geom, seq, this.$sections);
                } else if (geom instanceof Point) {
                    seq = ((Point)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.access$addFacetSequences(FacetSequenceTreeBuilder.INSTANCE, geom, seq, this.$sections);
                }
            }
        });
        return sections;
    }

    private final void addFacetSequences(Geometry geom, CoordinateSequence pts, List<FacetSequence> sections) {
        CoordinateSequence coordinateSequence = pts;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int size = coordinateSequence.size();
        for (int i = 0; i <= size - 1; i += 6) {
            int end = i + 6 + 1;
            if (end >= size - 1) {
                end = size;
            }
            FacetSequence sect = new FacetSequence(geom, pts, i, end);
            sections.add(sect);
        }
    }

    public static final /* synthetic */ void access$addFacetSequences(FacetSequenceTreeBuilder $this, Geometry geom, CoordinateSequence pts, List sections) {
        $this.addFacetSequences(geom, pts, sections);
    }
}

