/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001a\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lorg/locationtech/jts/operation/distance3d/AxisPlaneCoordinateSequence;", "Lorg/locationtech/jts/geom/CoordinateSequence;", "seq", "indexMap", "", "<init>", "(Lorg/locationtech/jts/geom/CoordinateSequence;[I)V", "dimension", "", "getDimension", "()I", "getCoordinate", "Lorg/locationtech/jts/geom/Coordinate;", "i", "getCoordinateCopy", "", "index", "coord", "getX", "", "getY", "getZ", "getOrdinate", "ordinateIndex", "size", "setOrdinate", "value", "toCoordinateArray", "", "()[Lorg/locationtech/jts/geom/Coordinate;", "expandEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "env", "clone", "", "copy", "Companion", "kts-core"})
public final class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CoordinateSequence seq;
    @NotNull
    private final int[] indexMap;
    @NotNull
    private static final int[] XY_INDEX;
    @NotNull
    private static final int[] XZ_INDEX;
    @NotNull
    private static final int[] YZ_INDEX;

    private AxisPlaneCoordinateSequence(CoordinateSequence seq, int[] indexMap) {
        this.seq = seq;
        this.indexMap = indexMap;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    @NotNull
    public Coordinate getCoordinate(int i) {
        return this.getCoordinateCopy(i);
    }

    @Override
    @NotNull
    public Coordinate getCoordinateCopy(int i) {
        return new Coordinate(this.getX(i), this.getY(i), this.getZ(i));
    }

    @Override
    public void getCoordinate(int index, @Nullable Coordinate coord) {
        Intrinsics.checkNotNull((Object)coord);
        coord.x = this.getOrdinate(index, 0);
        coord.y = this.getOrdinate(index, 1);
        coord.setZ(this.getOrdinate(index, 2));
    }

    @Override
    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    @Override
    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    @Override
    public double getZ(int index) {
        return this.getOrdinate(index, 2);
    }

    @Override
    public double getOrdinate(int index, int ordinateIndex) {
        double d;
        if (ordinateIndex > 1) {
            d = 0.0;
        } else {
            CoordinateSequence coordinateSequence = this.seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            d = coordinateSequence.getOrdinate(index, this.indexMap[ordinateIndex]);
        }
        return d;
    }

    @Override
    public int size() {
        CoordinateSequence coordinateSequence = this.seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        return coordinateSequence.size();
    }

    @Override
    public void setOrdinate(int index, int ordinateIndex, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Envelope expandEnvelope(@NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public AxisPlaneCoordinateSequence copy() {
        throw new UnsupportedOperationException();
    }

    public /* synthetic */ AxisPlaneCoordinateSequence(CoordinateSequence seq, int[] indexMap, DefaultConstructorMarker $constructor_marker) {
        this(seq, indexMap);
    }

    static {
        int[] nArray = new int[]{0, 1};
        XY_INDEX = nArray;
        nArray = new int[]{0, 2};
        XZ_INDEX = nArray;
        nArray = new int[]{1, 2};
        YZ_INDEX = nArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/distance3d/AxisPlaneCoordinateSequence$Companion;", "", "<init>", "()V", "projectToXY", "Lorg/locationtech/jts/geom/CoordinateSequence;", "seq", "projectToXZ", "projectToYZ", "XY_INDEX", "", "XZ_INDEX", "YZ_INDEX", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoordinateSequence projectToXY(@Nullable CoordinateSequence seq) {
            return new AxisPlaneCoordinateSequence(seq, XY_INDEX, null);
        }

        @NotNull
        public final CoordinateSequence projectToXZ(@Nullable CoordinateSequence seq) {
            return new AxisPlaneCoordinateSequence(seq, XZ_INDEX, null);
        }

        @NotNull
        public final CoordinateSequence projectToYZ(@Nullable CoordinateSequence seq) {
            return new AxisPlaneCoordinateSequence(seq, YZ_INDEX, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

