/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.DirectedEdgeStar;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002J(\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u001b\u001a\u00020\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/operation/overlay/LineBuilder;", "", "op", "Lorg/locationtech/jts/operation/overlay/OverlayOp;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "<init>", "(Lorg/locationtech/jts/operation/overlay/OverlayOp;Lorg/locationtech/jts/geom/GeometryFactory;Lorg/locationtech/jts/algorithm/PointLocator;)V", "lineEdgesList", "", "resultLineList", "Lorg/locationtech/jts/geom/Geometry;", "build", "", "opCode", "", "findCoveredLineEdges", "", "collectLines", "collectLineEdge", "de", "Lorg/locationtech/jts/geomgraph/DirectedEdge;", "edges", "collectBoundaryTouchEdge", "buildLines", "labelIsolatedLines", "edgesList", "labelIsolatedLine", "e", "Lorg/locationtech/jts/geomgraph/Edge;", "targetIndex", "kts-core"})
public final class LineBuilder {
    @NotNull
    private final OverlayOp op;
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final PointLocator ptLocator;
    @NotNull
    private final List<Object> lineEdgesList;
    @NotNull
    private final List<Geometry> resultLineList;

    public LineBuilder(@NotNull OverlayOp op, @NotNull GeometryFactory geometryFactory, @NotNull PointLocator ptLocator) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        Intrinsics.checkNotNullParameter((Object)ptLocator, (String)"ptLocator");
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
        this.lineEdgesList = new ArrayList();
        this.resultLineList = new ArrayList();
    }

    @NotNull
    public final List<Geometry> build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private final void findCoveredLineEdges() {
        Iterator<?> nodeit = this.op.getGraph().getNodes().iterator();
        while (nodeit.hasNext()) {
            Object obj = nodeit.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node node = (Node)obj;
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdgeStar");
            ((DirectedEdgeStar)edgeEndStar).findCoveredLineEdges();
        }
        for (Object obj : this.op.getGraph().getEdgeEnds()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            Edge e = de.getEdge();
            if (!de.isLineEdge() || e.isCoveredSet()) continue;
            Coordinate coordinate = de.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            boolean isCovered = this.op.isCoveredByA(coordinate);
            e.setCovered(isCovered);
        }
    }

    private final void collectLines(int opCode) {
        for (Object obj : this.op.getGraph().getEdgeEnds()) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            this.collectLineEdge(de, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de, opCode, this.lineEdgesList);
        }
    }

    private final void collectLineEdge(DirectedEdge de, int opCode, List<Object> edges) {
        Label label = de.getLabel();
        Intrinsics.checkNotNull((Object)label);
        Label label2 = label;
        Edge e = de.getEdge();
        if (de.isLineEdge() && !de.isVisited() && OverlayOp.Companion.isResultOfOp(label2, opCode) && !e.isCovered()) {
            edges.add(e);
            de.setVisitedEdge(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List<Object> edges) {
        block7: {
            label = de.getLabel();
            if (de.isLineEdge()) {
                return;
            }
            if (de.isVisited()) {
                return;
            }
            if (de.isInteriorAreaEdge()) {
                return;
            }
            if (de.getEdge().isInResult()) {
                return;
            }
            if (de.isInResult()) break block7;
            v0 = de.getSym();
            Intrinsics.checkNotNull((Object)v0);
            if (!v0.isInResult()) ** GOTO lbl-1000
        }
        if (!de.getEdge().isInResult()) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        Assert.isTrue(v1);
        v2 = label;
        Intrinsics.checkNotNull((Object)v2);
        if (OverlayOp.Companion.isResultOfOp(v2, opCode) && opCode == 1) {
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private final void buildLines(int opCode) {
        for (Object object : this.lineEdgesList) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)object;
            LineString line = this.geometryFactory.createLineString(e.getCoordinates());
            this.resultLineList.add(line);
            e.setInResult(true);
        }
    }

    private final void labelIsolatedLines(List<?> edgesList) {
        for (Object obj : edgesList) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            Label label = e.getLabel();
            if (!e.isIsolated()) continue;
            Label label2 = label;
            Intrinsics.checkNotNull((Object)label2);
            if (label2.isNull(0)) {
                this.labelIsolatedLine(e, 0);
                continue;
            }
            this.labelIsolatedLine(e, 1);
        }
    }

    private final void labelIsolatedLine(Edge e, int targetIndex) {
        Coordinate coordinate = e.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Geometry geometry = this.op.getArgGeometry(targetIndex);
        Intrinsics.checkNotNull((Object)geometry);
        int loc = this.ptLocator.locate(coordinate, geometry);
        Label label = e.getLabel();
        Intrinsics.checkNotNull((Object)label);
        label.setLocation(targetIndex, loc);
    }
}

