/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.overlayng.Edge;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0082\u0004J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0082\u0004J\n\u0010\u0018\u001a\u00020\u0012H\u0096\u0080\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/operation/overlayng/EdgeKey;", "", "edge", "Lorg/locationtech/jts/operation/overlayng/Edge;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/Edge;)V", "p0x", "", "p0y", "p1x", "p1y", "initPoints", "", "init", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "compareTo", "", "ek", "equals", "", "o", "", "hashCode", "toString", "", "format", "x", "y", "Companion", "kts-core"})
public final class EdgeKey
implements Comparable<EdgeKey> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double p0x;
    private double p0y;
    private double p1x;
    private double p1y;

    public EdgeKey(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.initPoints(edge);
    }

    private final void initPoints(Edge edge) {
        boolean direction = edge.direction();
        if (direction) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int len = edge.size();
            this.init(edge.getCoordinate(len - 1), edge.getCoordinate(len - 2));
        }
    }

    private final void init(Coordinate p0, Coordinate p1) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        this.p0x = coordinate.x;
        this.p0y = p0.y;
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        this.p1x = coordinate2.x;
        this.p1y = p1.y;
    }

    @Override
    public int compareTo(@NotNull EdgeKey ek) {
        Intrinsics.checkNotNullParameter((Object)ek, (String)"ek");
        if (this.p0x < ek.p0x) {
            return -1;
        }
        if (this.p0x > ek.p0x) {
            return 1;
        }
        if (this.p0y < ek.p0y) {
            return -1;
        }
        if (this.p0y > ek.p0y) {
            return 1;
        }
        if (this.p1x < ek.p1x) {
            return -1;
        }
        if (this.p1x > ek.p1x) {
            return 1;
        }
        if (this.p1y < ek.p1y) {
            return -1;
        }
        return this.p1y > ek.p1y ? 1 : 0;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EdgeKey)) {
            return false;
        }
        Object ek = o;
        return this.p0x == ((EdgeKey)ek).p0x && this.p0y == ((EdgeKey)ek).p0y && this.p1x == ((EdgeKey)ek).p1x && this.p1y == ((EdgeKey)ek).p1y;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + Companion.hashCode(this.p0x);
        result2 = 37 * result2 + Companion.hashCode(this.p0y);
        result2 = 37 * result2 + Companion.hashCode(this.p1x);
        result2 = 37 * result2 + Companion.hashCode(this.p1y);
        return result2;
    }

    @NotNull
    public String toString() {
        return "EdgeKey(" + this.format(this.p0x, this.p0y) + ", " + this.format(this.p1x, this.p1y) + ")";
    }

    private final String format(double x, double y) {
        return OrdinateFormat.DEFAULT.format(x) + " " + OrdinateFormat.DEFAULT.format(y);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/operation/overlayng/EdgeKey$Companion;", "", "<init>", "()V", "create", "Lorg/locationtech/jts/operation/overlayng/EdgeKey;", "edge", "Lorg/locationtech/jts/operation/overlayng/Edge;", "hashCode", "", "x", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EdgeKey create(@NotNull Edge edge) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            return new EdgeKey(edge);
        }

        public final int hashCode(double x) {
            long f = Math.INSTANCE.doubleToLongBits(x);
            return (int)(f ^ f >>> 32);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

