/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.operation.overlayng.Edge;
import org.locationtech.jts.operation.overlayng.EdgeKey;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/operation/overlayng/EdgeMerger;", "", "<init>", "()V", "merge", "", "Lorg/locationtech/jts/operation/overlayng/Edge;", "edges", "kts-core"})
public final class EdgeMerger {
    @NotNull
    public static final EdgeMerger INSTANCE = new EdgeMerger();

    private EdgeMerger() {
    }

    @NotNull
    public final List<Edge> merge(@NotNull List<Edge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        List mergedEdges = new ArrayList();
        Map edgeMap = new HashMap();
        for (Edge edge : edges) {
            EdgeKey edgeKey = EdgeKey.Companion.create(edge);
            Edge baseEdge = (Edge)edgeMap.get(edgeKey);
            if (baseEdge == null) {
                edgeMap.put(edgeKey, edge);
                mergedEdges.add(edge);
                continue;
            }
            Assert.INSTANCE.isTrue(baseEdge.size() == edge.size(), "Merge of edges of different sizes - probable noding error.");
            baseEdge.merge(edge);
        }
        return mergedEdges;
    }
}

