/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.overlayng.MaximalEdgeRing;
import org.locationtech.jts.operation.overlayng.OverlayEdgeRing;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 F2\u00020\u0001:\u0001FB9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001f\u001a\u00020\u0003H\u0016J\u0006\u0010 \u001a\u00020\bJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00101\u001a\u00020+J\u0006\u00102\u001a\u00020+J\u0006\u00103\u001a\u00020+J\u0006\u00104\u001a\u00020+J\u0010\u00107\u001a\u00020+2\b\u00108\u001a\u0004\u0018\u00010\u0000J\b\u00109\u001a\u0004\u0018\u00010\u0000J\u0010\u0010;\u001a\u00020+2\b\u00108\u001a\u0004\u0018\u00010\u0000J\b\u0010<\u001a\u0004\u0018\u00010\u0000J\b\u0010>\u001a\u00020+H\u0002J\u0006\u0010?\u001a\u00020+J\b\u0010@\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020\u001dJ\n\u0010C\u001a\u00020DH\u0096\u0080\u0004J\b\u0010E\u001a\u00020DH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\rR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000fR\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\rR\u0011\u00105\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\rR\u0011\u00106\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u0011\u0010:\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\rR\u0011\u0010=\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\r\u00a8\u0006G"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "Lorg/locationtech/jts/edgegraph/HalfEdge;", "orig", "Lorg/locationtech/jts/geom/Coordinate;", "dirPt", "isForward", "", "label", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "coordinates", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;ZLorg/locationtech/jts/operation/overlayng/OverlayLabel;[Lorg/locationtech/jts/geom/Coordinate;)V", "()Z", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "value", "isInResultArea", "isInResultLine", "isVisited", "nextResultEdge", "edgeRing", "Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "getEdgeRing", "()Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "setEdgeRing", "(Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;)V", "maxEdgeRing", "Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing;", "nextResultMaxEdge", "directionPt", "getLabel", "getLocation", "", "index", "position", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "coordinatesOriented", "getCoordinatesOriented", "addCoordinates", "", "coords", "Lorg/locationtech/jts/geom/CoordinateList;", "symOE", "oNextOE", "isInResultAreaBoth", "unmarkFromResultAreaBoth", "markInResultArea", "markInResultAreaBoth", "markInResultLine", "isInResult", "isInResultEither", "setNextResult", "e", "nextResult", "isResultLinked", "setNextResultMax", "nextResultMax", "isResultMaxLinked", "markVisited", "markVisitedBoth", "getEdgeRingMax", "setEdgeRingMax", "maximalEdgeRing", "toString", "", "resultSymbol", "Companion", "kts-core"})
public final class OverlayEdge
extends HalfEdge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Coordinate dirPt;
    private final boolean isForward;
    @NotNull
    private final Coordinate[] coordinates;
    @NotNull
    private final OverlayLabel label;
    private boolean isInResultArea;
    private boolean isInResultLine;
    private boolean isVisited;
    @Nullable
    private OverlayEdge nextResultEdge;
    @Nullable
    private OverlayEdgeRing edgeRing;
    @Nullable
    private MaximalEdgeRing maxEdgeRing;
    @Nullable
    private OverlayEdge nextResultMaxEdge;

    public OverlayEdge(@Nullable Coordinate orig, @Nullable Coordinate dirPt, boolean isForward, @NotNull OverlayLabel label, @NotNull Coordinate[] coordinates) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Coordinate coordinate = orig;
        Intrinsics.checkNotNull((Object)coordinate);
        super(coordinate);
        this.dirPt = dirPt;
        this.isForward = isForward;
        this.coordinates = coordinates;
        this.label = label;
    }

    public final boolean isForward() {
        return this.isForward;
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    public final boolean isInResultArea() {
        return this.isInResultArea;
    }

    public final boolean isInResultLine() {
        return this.isInResultLine;
    }

    public final boolean isVisited() {
        return this.isVisited;
    }

    @Nullable
    public final OverlayEdgeRing getEdgeRing() {
        return this.edgeRing;
    }

    public final void setEdgeRing(@Nullable OverlayEdgeRing overlayEdgeRing) {
        this.edgeRing = overlayEdgeRing;
    }

    @Override
    @NotNull
    public Coordinate directionPt() {
        Coordinate coordinate = this.dirPt;
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate;
    }

    @NotNull
    public final OverlayLabel getLabel() {
        return this.label;
    }

    public final int getLocation(int index, int position) {
        return this.label.getLocation(index, position, this.isForward);
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return this.orig();
    }

    @NotNull
    public final Coordinate[] getCoordinatesOriented() {
        if (this.isForward) {
            return this.coordinates;
        }
        Coordinate[] coordinateArray = Arrays.copyOf(this.coordinates, this.coordinates.length);
        Intrinsics.checkNotNullExpressionValue((Object)coordinateArray, (String)"copyOf(...)");
        Coordinate[] copy = coordinateArray;
        CoordinateArrays.reverse(copy);
        return copy;
    }

    public final void addCoordinates(@NotNull CoordinateList coords) {
        boolean isFirstEdge;
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        boolean bl = isFirstEdge = coords.size() > 0;
        if (this.isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            int n = this.coordinates.length;
            for (int i = startIndex; i < n; ++i) {
                coords.add(this.coordinates[i], false);
            }
        } else {
            int startIndex = this.coordinates.length - 2;
            if (isFirstEdge) {
                startIndex = this.coordinates.length - 1;
            }
            for (int i = startIndex; -1 < i; --i) {
                coords.add(this.coordinates[i], false);
            }
        }
    }

    @NotNull
    public final OverlayEdge symOE() {
        HalfEdge halfEdge = this.sym();
        Intrinsics.checkNotNull((Object)halfEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlayng.OverlayEdge");
        return (OverlayEdge)halfEdge;
    }

    @NotNull
    public final OverlayEdge oNextOE() {
        HalfEdge halfEdge = this.oNext();
        Intrinsics.checkNotNull((Object)halfEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlayng.OverlayEdge");
        return (OverlayEdge)halfEdge;
    }

    public final boolean isInResultAreaBoth() {
        return this.isInResultArea && this.symOE().isInResultArea;
    }

    public final void unmarkFromResultAreaBoth() {
        this.isInResultArea = false;
        this.symOE().isInResultArea = false;
    }

    public final void markInResultArea() {
        this.isInResultArea = true;
    }

    public final void markInResultAreaBoth() {
        this.isInResultArea = true;
        this.symOE().isInResultArea = true;
    }

    public final void markInResultLine() {
        this.isInResultLine = true;
        this.symOE().isInResultLine = true;
    }

    public final boolean isInResult() {
        return this.isInResultArea || this.isInResultLine;
    }

    public final boolean isInResultEither() {
        return this.isInResult() || this.symOE().isInResult();
    }

    public final void setNextResult(@Nullable OverlayEdge e) {
        this.nextResultEdge = e;
    }

    @Nullable
    public final OverlayEdge nextResult() {
        return this.nextResultEdge;
    }

    public final boolean isResultLinked() {
        return this.nextResultEdge != null;
    }

    public final void setNextResultMax(@Nullable OverlayEdge e) {
        this.nextResultMaxEdge = e;
    }

    @Nullable
    public final OverlayEdge nextResultMax() {
        return this.nextResultMaxEdge;
    }

    public final boolean isResultMaxLinked() {
        return this.nextResultMaxEdge != null;
    }

    private final void markVisited() {
        this.isVisited = true;
    }

    public final void markVisitedBoth() {
        this.markVisited();
        this.symOE().markVisited();
    }

    @Nullable
    public final MaximalEdgeRing getEdgeRingMax() {
        return this.maxEdgeRing;
    }

    public final void setEdgeRingMax(@NotNull MaximalEdgeRing maximalEdgeRing) {
        Intrinsics.checkNotNullParameter((Object)maximalEdgeRing, (String)"maximalEdgeRing");
        this.maxEdgeRing = maximalEdgeRing;
    }

    @Override
    @NotNull
    public String toString() {
        Coordinate orig = this.orig();
        Coordinate dest = this.dest();
        String dirPtStr = this.coordinates.length > 2 ? ", " + WKTWriter.Companion.format(this.directionPt()) : "";
        return "OE( " + WKTWriter.Companion.format(orig) + dirPtStr + " .. " + WKTWriter.Companion.format(dest) + " ) " + this.label.toString(this.isForward) + this.resultSymbol() + " / Sym: " + this.symOE().getLabel().toString(this.symOE().isForward) + this.symOE().resultSymbol();
    }

    private final String resultSymbol() {
        if (this.isInResultArea) {
            return " resA";
        }
        return this.isInResultLine ? " resL" : "";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0011j\b\u0012\u0004\u0012\u00020\u0005`\u0012\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/operation/overlayng/OverlayEdge$Companion;", "", "<init>", "()V", "createEdge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "lbl", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "direction", "", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/overlayng/OverlayLabel;Z)Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "createEdgePair", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/overlayng/OverlayLabel;)Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "nodeComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OverlayEdge createEdge(@NotNull Coordinate[] pts, @NotNull OverlayLabel lbl, boolean direction) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
            Coordinate origin = null;
            Coordinate dirPt = null;
            if (direction) {
                origin = pts[0];
                dirPt = pts[1];
            } else {
                int ilast = pts.length - 1;
                origin = pts[ilast];
                dirPt = pts[ilast - 1];
            }
            return new OverlayEdge(origin, dirPt, direction, lbl, pts);
        }

        @NotNull
        public final OverlayEdge createEdgePair(@NotNull Coordinate[] pts, @NotNull OverlayLabel lbl) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            Intrinsics.checkNotNullParameter((Object)lbl, (String)"lbl");
            OverlayEdge e0 = this.createEdge(pts, lbl, true);
            OverlayEdge e1 = this.createEdge(pts, lbl, false);
            e0.link(e1);
            return e0;
        }

        @NotNull
        public final Comparator<OverlayEdge> nodeComparator() {
            return Companion::nodeComparator$lambda$0;
        }

        private static final int nodeComparator$lambda$0(OverlayEdge e1, OverlayEdge e2) {
            return e1.orig().compareTo(e2.orig());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

