/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.operation.polygonize.EdgeRing;
import org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge;
import org.locationtech.jts.operation.polygonize.PolygonizeEdge;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.DirectedEdgeStar;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.PlanarGraph;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0016\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cJ\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/operation/polygonize/PolygonizeGraph;", "Lorg/locationtech/jts/planargraph/PlanarGraph;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "addEdge", "", "line", "Lorg/locationtech/jts/geom/LineString;", "getNode", "Lorg/locationtech/jts/planargraph/Node;", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "computeNextCWEdges", "convertMaximalToMinimalEdgeRings", "ringEdges", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "edgeRings", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "getEdgeRings", "()Ljava/util/List;", "deleteCutEdges", "findEdgeRing", "startDE", "Lorg/locationtech/jts/operation/polygonize/PolygonizeDirectedEdge;", "deleteDangles", "", "computeDepthParity", "de", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nPolygonizeGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonizeGraph.kt\norg/locationtech/jts/operation/polygonize/PolygonizeGraph\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,425:1\n21#2:426\n21#2:427\n*S KotlinDebug\n*F\n+ 1 PolygonizeGraph.kt\norg/locationtech/jts/operation/polygonize/PolygonizeGraph\n*L\n203#1:426\n225#1:427\n*E\n"})
public final class PolygonizeGraph
extends PlanarGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory factory;

    public PolygonizeGraph(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
    }

    public final void addEdge(@NotNull LineString line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (line.isEmpty()) {
            return;
        }
        Coordinate[] linePts = CoordinateArrays.INSTANCE.removeRepeatedPoints(line.getCoordinates());
        if (linePts.length < 2) {
            return;
        }
        Coordinate startPt = linePts[0];
        Coordinate endPt = linePts[linePts.length - 1];
        Node nStart = this.getNode(startPt);
        Node nEnd = this.getNode(endPt);
        DirectedEdge de0 = new PolygonizeDirectedEdge(nStart, nEnd, linePts[1], true);
        DirectedEdge de1 = new PolygonizeDirectedEdge(nEnd, nStart, linePts[linePts.length - 2], false);
        Edge edge = new PolygonizeEdge(line);
        edge.setDirectedEdges(de0, de1);
        this.add(edge);
    }

    private final Node getNode(Coordinate pt) {
        Node node = this.findNode(pt);
        if (node == null) {
            node = new Node(pt, null, 2, null);
            this.add(node);
        }
        return node;
    }

    private final void computeNextCWEdges() {
        Iterator<?> iNode = this.nodeIterator();
        while (iNode.hasNext()) {
            Object obj = iNode.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)obj;
            PolygonizeGraph.Companion.computeNextCWEdges(node);
        }
    }

    private final void convertMaximalToMinimalEdgeRings(List<DirectedEdge> ringEdges) {
        for (DirectedEdge directedEdge : ringEdges) {
            List intNodes;
            Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)directedEdge;
            long label = de.getLabel();
            if (PolygonizeGraph.Companion.findIntersectionNodes(de, label) == null) continue;
            for (Object e : intNodes) {
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
                Node node = (Node)e;
                PolygonizeGraph.Companion.computeNextCCWEdges(node, label);
            }
        }
    }

    @NotNull
    public final List<EdgeRing> getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.Companion.label(this.getDirEdges(), -1L);
        List maximalRings = PolygonizeGraph.Companion.findLabeledEdgeRings(this.getDirEdges());
        this.convertMaximalToMinimalEdgeRings(maximalRings);
        List edgeRingList = new ArrayList();
        for (Object object : this.getDirEdges()) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)object;
            if (de.isMarked() || de.isInRing()) continue;
            EdgeRing er = this.findEdgeRing(de);
            edgeRingList.add(er);
        }
        return edgeRingList;
    }

    @NotNull
    public final List<LineString> deleteCutEdges() {
        this.computeNextCWEdges();
        PolygonizeGraph.Companion.findLabeledEdgeRings(this.getDirEdges());
        List cutLines = new ArrayList();
        for (Object object : this.getDirEdges()) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)object;
            if (de.isMarked()) continue;
            DirectedEdge directedEdge = de.getSym();
            Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge;
            if (de.getLabel() != sym.getLabel()) continue;
            de.setMarked(true);
            sym.setMarked(true);
            Edge edge = de.getEdge();
            Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeEdge");
            PolygonizeEdge e = (PolygonizeEdge)edge;
            cutLines.add(e.getLine());
        }
        return cutLines;
    }

    private final EdgeRing findEdgeRing(PolygonizeDirectedEdge startDE) {
        EdgeRing er = new EdgeRing(this.factory);
        er.build(startDE);
        return er;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<LineString> deleteDangles() {
        List<Node> nodesToRemove = this.findNodesOfDegree(1);
        Set dangleLines = new HashSet();
        List nodeStack = new ArrayList();
        Iterator<Node> i = nodesToRemove.iterator();
        while (i.hasNext()) {
            void $this$push$iv;
            List list = nodeStack;
            Node item$iv = i.next();
            boolean $i$f$push = false;
            $this$push$iv.add(item$iv);
        }
        while (!((Collection)nodeStack).isEmpty()) {
            Object t = StackKt.pop(nodeStack);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)t;
            Companion.deleteAllEdges(node);
            List<DirectedEdge> nodeOutEdges = node.getOutEdges().getEdges();
            for (DirectedEdge directedEdge : nodeOutEdges) {
                void $this$push$iv;
                Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)directedEdge;
                de.setMarked(true);
                DirectedEdge directedEdge2 = de.getSym();
                Intrinsics.checkNotNull((Object)directedEdge2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge2;
                sym.setMarked(true);
                Edge edge = de.getEdge();
                Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeEdge");
                PolygonizeEdge e = (PolygonizeEdge)edge;
                dangleLines.add(e.getLine());
                Node toNode = de.getToNode();
                if (PolygonizeGraph.Companion.getDegreeNonDeleted(toNode) != 1) continue;
                List list = nodeStack;
                Node item$iv = toNode;
                boolean $i$f$push = false;
                $this$push$iv.add(item$iv);
            }
        }
        return dangleLines;
    }

    public final void computeDepthParity() {
    }

    private final void computeDepthParity(PolygonizeDirectedEdge de) {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u001c\u0010\t\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/polygonize/PolygonizeGraph$Companion;", "", "<init>", "()V", "getDegreeNonDeleted", "", "node", "Lorg/locationtech/jts/planargraph/Node;", "getDegree", "label", "", "deleteAllEdges", "", "findIntersectionNodes", "", "startDE", "Lorg/locationtech/jts/operation/polygonize/PolygonizeDirectedEdge;", "findLabeledEdgeRings", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "dirEdges", "", "computeNextCWEdges", "computeNextCCWEdges", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getDegreeNonDeleted(Node node) {
            List<DirectedEdge> edges = node.getOutEdges().getEdges();
            int degree = 0;
            Iterator<DirectedEdge> i = edges.iterator();
            while (i.hasNext()) {
                if (i.next().isMarked()) continue;
                ++degree;
            }
            return degree;
        }

        private final int getDegree(Node node, long label) {
            List<DirectedEdge> edges = node.getOutEdges().getEdges();
            int degree = 0;
            for (DirectedEdge directedEdge : edges) {
                Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)directedEdge;
                if (de.getLabel() != label) continue;
                ++degree;
            }
            return degree;
        }

        public final void deleteAllEdges(@NotNull Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List<DirectedEdge> edges = node.getOutEdges().getEdges();
            for (DirectedEdge directedEdge : edges) {
                Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)directedEdge;
                de.setMarked(true);
                DirectedEdge directedEdge2 = de.getSym();
                Intrinsics.checkNotNull((Object)directedEdge2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge2;
                sym.setMarked(true);
            }
        }

        private final List<Node> findIntersectionNodes(PolygonizeDirectedEdge startDE, long label) {
            PolygonizeDirectedEdge de = startDE;
            List intNodes = null;
            do {
                Node node;
                if (this.getDegree(node = de.getFromNode(), label) > 1) {
                    if (intNodes == null) {
                        intNodes = new ArrayList();
                    }
                    intNodes.add(node);
                }
                Intrinsics.checkNotNull((Object)de.getNext());
                Assert.INSTANCE.isTrue(de != null, "found null DE in ring");
                Assert.INSTANCE.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
            } while (de != startDE);
            return intNodes;
        }

        private final List<DirectedEdge> findLabeledEdgeRings(Collection<?> dirEdges) {
            List edgeRingStarts = new ArrayList();
            long currLabel = 1L;
            for (Object obj : dirEdges) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)obj;
                if (de.isMarked() || de.getLabel() >= 0L) continue;
                edgeRingStarts.add(de);
                List<DirectedEdge> edges = EdgeRing.Companion.findDirEdgesInRing(de);
                this.label((Collection)edges, currLabel);
                long l = currLabel;
                currLabel = l + 1L;
            }
            return edgeRingStarts;
        }

        private final void label(Collection<?> dirEdges, long label) {
            for (Object obj : dirEdges) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)obj;
                de.setLabel(label);
            }
        }

        private final void computeNextCWEdges(Node node) {
            DirectedEdgeStar deStar = node.getOutEdges();
            PolygonizeDirectedEdge startDE = null;
            DirectedEdge prevDE = null;
            for (DirectedEdge directedEdge : deStar.getEdges()) {
                Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge outDE = (PolygonizeDirectedEdge)directedEdge;
                if (outDE.isMarked()) continue;
                if (startDE == null) {
                    startDE = outDE;
                }
                if (prevDE != null) {
                    DirectedEdge directedEdge2 = prevDE.getSym();
                    Intrinsics.checkNotNull((Object)directedEdge2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                    PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge2;
                    sym.setNext(outDE);
                }
                prevDE = outDE;
            }
            if (prevDE != null) {
                DirectedEdge directedEdge = prevDE.getSym();
                Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge;
                sym.setNext(startDE);
            }
        }

        private final void computeNextCCWEdges(Node node, long label) {
            DirectedEdgeStar deStar = node.getOutEdges();
            PolygonizeDirectedEdge firstOutDE = null;
            PolygonizeDirectedEdge prevInDE = null;
            List<DirectedEdge> edges = deStar.getEdges();
            int n = ((Collection)edges).size() + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    DirectedEdge directedEdge = edges.get(i);
                    Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                    PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)directedEdge;
                    DirectedEdge directedEdge2 = de.getSym();
                    Intrinsics.checkNotNull((Object)directedEdge2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
                    PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)directedEdge2;
                    PolygonizeDirectedEdge outDE = null;
                    if (de.getLabel() == label) {
                        outDE = de;
                    }
                    PolygonizeDirectedEdge inDE = null;
                    if (sym.getLabel() == label) {
                        inDE = sym;
                    }
                    if (outDE == null && inDE == null) continue;
                    if (inDE != null) {
                        prevInDE = inDE;
                    }
                    if (outDE == null) continue;
                    if (prevInDE != null) {
                        prevInDE.setNext(outDE);
                        prevInDE = null;
                    }
                    if (firstOutDE != null) continue;
                    firstOutDE = outDE;
                } while (0 <= n);
            }
            if (prevInDE != null) {
                Assert.isTrue(firstOutDE != null);
                prevInDE.setNext(firstOutDE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

