/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000bH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/operation/predicate/GeometryContainsPointVisitor;", "Lorg/locationtech/jts/geom/util/ShortCircuitedGeometryVisitor;", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "rectSeq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "containsPoint", "", "visit", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "isDone", "kts-core"})
public final class GeometryContainsPointVisitor
extends ShortCircuitedGeometryVisitor {
    @NotNull
    private final CoordinateSequence rectSeq;
    @NotNull
    private final Envelope rectEnv;
    private boolean containsPoint;

    public GeometryContainsPointVisitor(@NotNull Polygon rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        LinearRing linearRing = rectangle.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        CoordinateSequence coordinateSequence = linearRing.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        this.rectSeq = coordinateSequence;
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public final boolean containsPoint() {
        return this.containsPoint;
    }

    @Override
    protected void visit(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (!(geom instanceof Polygon)) {
            return;
        }
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        Coordinate rectPt = new Coordinate();
        for (int i = 0; i < 4; ++i) {
            this.rectSeq.getCoordinate(i, rectPt);
            if (!elementEnv.contains(rectPt) || !SimplePointInAreaLocator.Companion.containsPointInPolygon(rectPt, (Polygon)geom)) continue;
            this.containsPoint = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.containsPoint;
    }
}

