/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.predicate.EnvelopeIntersectsVisitor;
import org.locationtech.jts.operation.predicate.GeometryContainsPointVisitor;
import org.locationtech.jts.operation.predicate.RectangleIntersectsSegmentVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/predicate/RectangleIntersects;", "", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "rectEnv", "Lorg/locationtech/jts/geom/Envelope;", "intersects", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "Companion", "kts-core"})
public final class RectangleIntersects {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Polygon rectangle;
    @NotNull
    private final Envelope rectEnv;

    public RectangleIntersects(@NotNull Polygon rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.rectangle = rectangle;
        this.rectEnv = this.rectangle.getEnvelopeInternal();
    }

    public final boolean intersects(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (!this.rectEnv.intersects(geom.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor visitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        visitor.applyTo(geom);
        if (visitor.intersects()) {
            return true;
        }
        GeometryContainsPointVisitor ecpVisitor = new GeometryContainsPointVisitor(this.rectangle);
        ecpVisitor.applyTo(geom);
        if (ecpVisitor.containsPoint()) {
            return true;
        }
        RectangleIntersectsSegmentVisitor riVisitor = new RectangleIntersectsSegmentVisitor(this.rectangle);
        riVisitor.applyTo(geom);
        return riVisitor.intersects();
    }

    @JvmStatic
    public static final boolean intersects(@NotNull Polygon rectangle, @NotNull Geometry b) {
        return Companion.intersects(rectangle, b);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/predicate/RectangleIntersects$Companion;", "", "<init>", "()V", "intersects", "", "rectangle", "Lorg/locationtech/jts/geom/Polygon;", "b", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean intersects(@NotNull Polygon rectangle, @NotNull Geometry b) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            RectangleIntersects rp = new RectangleIntersects(rectangle);
            return rp.intersects(b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

