/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.NodeMap;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.operation.BoundaryOp;
import org.locationtech.jts.operation.relate.EdgeEndBuilder;
import org.locationtech.jts.operation.relate.RelateNode;
import org.locationtech.jts.operation.relate.RelateNodeFactory;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0018\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\b\u0010%\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u001fH\u0002J\"\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\u001f2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\b\u0010/\u001a\u00020\u0017H\u0002J\u0018\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020\u001fH\u0002R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/locationtech/jts/operation/relate/RelateComputer;", "", "arg", "", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "<init>", "([Lorg/locationtech/jts/geomgraph/GeometryGraph;)V", "[Lorg/locationtech/jts/geomgraph/GeometryGraph;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "nodes", "Lorg/locationtech/jts/geomgraph/NodeMap;", "im", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "isolatedEdges", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "invalidPoint", "Lorg/locationtech/jts/geom/Coordinate;", "computeIM", "insertEdgeEnds", "", "ee", "", "computeProperIntersectionIM", "intersector", "Lorg/locationtech/jts/geomgraph/index/SegmentIntersector;", "copyNodesAndLabels", "argIndex", "", "computeIntersectionNodes", "labelIntersectionNodes", "computeDisjointIM", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "labelNodeEdges", "updateIM", "labelIsolatedEdges", "thisIndex", "targetIndex", "labelIsolatedEdge", "e", "Lorg/locationtech/jts/geomgraph/Edge;", "target", "Lorg/locationtech/jts/geom/Geometry;", "labelIsolatedNodes", "labelIsolatedNode", "n", "Lorg/locationtech/jts/geomgraph/Node;", "Companion", "kts-core"})
public final class RelateComputer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryGraph[] arg;
    @NotNull
    private final LineIntersector li;
    @NotNull
    private final PointLocator ptLocator;
    @NotNull
    private final NodeMap nodes;
    @Nullable
    private final IntersectionMatrix im;
    @NotNull
    private final ArrayList<Object> isolatedEdges;
    @Nullable
    private final Coordinate invalidPoint;

    public RelateComputer(@NotNull GeometryGraph[] arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        this.arg = arg;
        this.li = new RobustLineIntersector();
        this.ptLocator = new PointLocator();
        this.nodes = new NodeMap(new RelateNodeFactory());
        this.isolatedEdges = new ArrayList();
    }

    @NotNull
    public final IntersectionMatrix computeIM() {
        IntersectionMatrix im = new IntersectionMatrix();
        im.set(2, 2, 2);
        Geometry geometry = this.arg[0].getGeometry();
        Intrinsics.checkNotNull((Object)geometry);
        Envelope envelope = geometry.getEnvelopeInternal();
        Geometry geometry2 = this.arg[1].getGeometry();
        Intrinsics.checkNotNull((Object)geometry2);
        if (!envelope.intersects(geometry2.getEnvelopeInternal())) {
            this.computeDisjointIM(im, this.arg[0].getBoundaryNodeRule());
            return im;
        }
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        SegmentIntersector intersector = this.arg[0].computeEdgeIntersections(this.arg[1], this.li, false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM(intersector, im);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List<Object> ee0 = eeBuilder.computeEdgeEnds(this.arg[0].getEdgeIterator());
        this.insertEdgeEnds(ee0);
        List<Object> ee1 = eeBuilder.computeEdgeEnds(this.arg[1].getEdgeIterator());
        this.insertEdgeEnds(ee1);
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(im);
        return im;
    }

    private final void insertEdgeEnds(List<? extends Object> ee) {
        for (Object object : ee) {
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)object;
            this.nodes.add(e);
        }
    }

    private final void computeProperIntersectionIM(SegmentIntersector intersector, IntersectionMatrix im) {
        Geometry geometry = this.arg[0].getGeometry();
        Intrinsics.checkNotNull((Object)geometry);
        int dimA = geometry.getDimension();
        Geometry geometry2 = this.arg[1].getGeometry();
        Intrinsics.checkNotNull((Object)geometry2);
        int dimB = geometry2.getDimension();
        boolean hasProper = intersector.hasProperIntersection();
        boolean hasProperInterior = intersector.hasProperInteriorIntersection();
        if (dimA == 2 && dimB == 2) {
            if (hasProper) {
                im.setAtLeast("212101212");
            }
        } else if (dimA == 2 && dimB == 1) {
            if (hasProper) {
                im.setAtLeast("FFF0FFFF2");
            }
            if (hasProperInterior) {
                im.setAtLeast("1FFFFF1FF");
            }
        } else if (dimA == 1 && dimB == 2) {
            if (hasProper) {
                im.setAtLeast("F0FFFFFF2");
            }
            if (hasProperInterior) {
                im.setAtLeast("1F1FFFFFF");
            }
        } else if (dimA == 1 && dimB == 1 && hasProperInterior) {
            im.setAtLeast("0FFFFFFFF");
        }
    }

    private final void copyNodesAndLabels(int argIndex) {
        Iterator<?> i = this.arg[argIndex].getNodeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node graphNode = (Node)obj;
            Coordinate coordinate = graphNode.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            Node newNode = this.nodes.addNode(coordinate);
            Label label = graphNode.getLabel();
            Intrinsics.checkNotNull((Object)label);
            newNode.setLabel(argIndex, label.getLocation(argIndex));
        }
    }

    private final void computeIntersectionNodes(int argIndex) {
        Iterator<?> i = this.arg[argIndex].getEdgeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int eLoc = label.getLocation(argIndex);
            Iterator<?> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                Object obj2 = eiIt.next();
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
                EdgeIntersection ei = (EdgeIntersection)obj2;
                RelateNode n = (RelateNode)this.nodes.addNode(ei.getCoord());
                if (eLoc == 1) {
                    RelateNode relateNode = n;
                    Intrinsics.checkNotNull((Object)relateNode);
                    relateNode.setLabelBoundary(argIndex);
                    continue;
                }
                RelateNode relateNode = n;
                Intrinsics.checkNotNull((Object)relateNode);
                Label label2 = relateNode.getLabel();
                Intrinsics.checkNotNull((Object)label2);
                if (!label2.isNull(argIndex)) continue;
                n.setLabel(argIndex, 0);
            }
        }
    }

    private final void labelIntersectionNodes(int argIndex) {
        Iterator<?> i = this.arg[argIndex].getEdgeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int eLoc = label.getLocation(argIndex);
            Iterator<?> eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                RelateNode n;
                Object obj2 = eiIt.next();
                Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
                EdgeIntersection ei = (EdgeIntersection)obj2;
                RelateNode relateNode = n = (RelateNode)this.nodes.find(ei.getCoord());
                Intrinsics.checkNotNull((Object)relateNode);
                Label label2 = relateNode.getLabel();
                Intrinsics.checkNotNull((Object)label2);
                if (!label2.isNull(argIndex)) continue;
                if (eLoc == 1) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                n.setLabel(argIndex, 0);
            }
        }
    }

    private final void computeDisjointIM(IntersectionMatrix im, BoundaryNodeRule boundaryNodeRule) {
        Geometry gb;
        Geometry ga;
        Geometry geometry = ga = this.arg[0].getGeometry();
        Intrinsics.checkNotNull((Object)geometry);
        if (!geometry.isEmpty()) {
            im.set(0, 2, ga.getDimension());
            im.set(1, 2, RelateComputer.Companion.getBoundaryDim(ga, boundaryNodeRule));
        }
        Geometry geometry2 = gb = this.arg[1].getGeometry();
        Intrinsics.checkNotNull((Object)geometry2);
        if (!geometry2.isEmpty()) {
            im.set(2, 0, gb.getDimension());
            im.set(2, 1, RelateComputer.Companion.getBoundaryDim(gb, boundaryNodeRule));
        }
    }

    private final void labelNodeEdges() {
        Iterator<?> ni = this.nodes.iterator();
        while (ni.hasNext()) {
            Object obj = ni.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.relate.RelateNode");
            RelateNode node = (RelateNode)obj;
            EdgeEndStar edgeEndStar = node.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar);
            edgeEndStar.computeLabelling(this.arg);
        }
    }

    private final void updateIM(IntersectionMatrix im) {
        Iterator<Object> iterator2 = this.isolatedEdges.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> ei = iterator2;
        while (ei.hasNext()) {
            Object object = ei.next();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)object;
            e.updateIM(im);
        }
        Iterator<?> ni = this.nodes.iterator();
        while (ni.hasNext()) {
            Object obj = ni.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.relate.RelateNode");
            RelateNode node = (RelateNode)obj;
            node.updateIM(im);
            node.updateIMFromEdges(im);
        }
    }

    private final void labelIsolatedEdges(int thisIndex, int targetIndex) {
        Iterator<?> ei = this.arg[thisIndex].getEdgeIterator();
        while (ei.hasNext()) {
            Object obj = ei.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Edge");
            Edge e = (Edge)obj;
            if (!e.isIsolated()) continue;
            this.labelIsolatedEdge(e, targetIndex, this.arg[targetIndex].getGeometry());
            this.isolatedEdges.add(e);
        }
    }

    private final void labelIsolatedEdge(Edge e, int targetIndex, Geometry target) {
        Geometry geometry = target;
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.getDimension() > 0) {
            Coordinate coordinate = e.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            int loc = this.ptLocator.locate(coordinate, target);
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            label.setAllLocations(targetIndex, loc);
        } else {
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            label.setAllLocations(targetIndex, 2);
        }
    }

    private final void labelIsolatedNodes() {
        Iterator<?> ni = this.nodes.iterator();
        while (ni.hasNext()) {
            Label label;
            Object obj = ni.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node n = (Node)obj;
            Label label2 = label = n.getLabel();
            Intrinsics.checkNotNull((Object)label2);
            Assert.INSTANCE.isTrue(label2.getGeometryCount() > 0, "node with empty label found");
            if (!n.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(n, 0);
                continue;
            }
            this.labelIsolatedNode(n, 1);
        }
    }

    private final void labelIsolatedNode(Node n, int targetIndex) {
        Coordinate coordinate = n.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Geometry geometry = this.arg[targetIndex].getGeometry();
        Intrinsics.checkNotNull((Object)geometry);
        int loc = this.ptLocator.locate(coordinate, geometry);
        Label label = n.getLabel();
        Intrinsics.checkNotNull((Object)label);
        label.setAllLocations(targetIndex, loc);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/relate/RelateComputer$Companion;", "", "<init>", "()V", "getBoundaryDim", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getBoundaryDim(Geometry geom, BoundaryNodeRule boundaryNodeRule) {
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            BoundaryNodeRule boundaryNodeRule2 = boundaryNodeRule;
            Intrinsics.checkNotNull((Object)boundaryNodeRule2);
            return BoundaryOp.Companion.hasBoundary(geometry, boundaryNodeRule2) ? (geom.getDimension() == 1 ? 0 : geom.getBoundaryDimension()) : -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

