/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.union.UnionStrategy;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J,\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u000bH\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u001e\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/operation/union/CascadedPolygonUnion;", "", "inputPolys", "", "unionFun", "Lorg/locationtech/jts/operation/union/UnionStrategy;", "<init>", "(Ljava/util/Collection;Lorg/locationtech/jts/operation/union/UnionStrategy;)V", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "countRemainder", "", "countInput", "union", "Lorg/locationtech/jts/geom/Geometry;", "unionTree", "geomTree", "", "binaryUnion", "geoms", "", "start", "end", "reduceToGeometries", "unionSafe", "g0", "g1", "unionActual", "Companion", "kts-core"})
public final class CascadedPolygonUnion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Collection<?> inputPolys;
    @Nullable
    private GeometryFactory geomFactory;
    @NotNull
    private final UnionStrategy unionFun;
    private int countRemainder;
    private int countInput;
    @NotNull
    private static final UnionStrategy CLASSIC_UNION = new UnionStrategy(){

        public Geometry union(Geometry g0, Geometry g1) {
            Geometry geometry;
            try {
                Geometry geometry2 = g0;
                Intrinsics.checkNotNull((Object)geometry2);
                Geometry geometry3 = g1;
                Intrinsics.checkNotNull((Object)geometry3);
                geometry = SnapIfNeededOverlayOp.Companion.union(geometry2, geometry3);
            }
            catch (TopologyException ex) {
                geometry = OverlayNGRobust.overlay(g0, g1, 2);
            }
            return geometry;
        }

        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private static final int STRTREE_NODE_CAPACITY = 4;

    @JvmOverloads
    public CascadedPolygonUnion(@Nullable Collection<?> inputPolys, @NotNull UnionStrategy unionFun) {
        Intrinsics.checkNotNullParameter((Object)unionFun, (String)"unionFun");
        this.inputPolys = inputPolys;
        this.unionFun = unionFun;
        if (this.inputPolys == null) {
            this.inputPolys = new ArrayList();
        }
        Collection<?> collection = this.inputPolys;
        Intrinsics.checkNotNull(collection);
        this.countRemainder = this.countInput = collection.size();
    }

    public /* synthetic */ CascadedPolygonUnion(Collection collection, UnionStrategy unionStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            unionStrategy = CLASSIC_UNION;
        }
        this(collection, unionStrategy);
    }

    @Nullable
    public final Geometry union() {
        if (this.inputPolys == null) {
            throw new IllegalStateException("union() method cannot be called twice");
        }
        Collection<?> collection = this.inputPolys;
        Intrinsics.checkNotNull(collection);
        if (collection.isEmpty()) {
            return null;
        }
        Collection<?> collection2 = this.inputPolys;
        Intrinsics.checkNotNull(collection2);
        Object obj = collection2.iterator().next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
        this.geomFactory = ((Geometry)obj).getFactory();
        STRtree index = new STRtree(4);
        Collection<?> collection3 = this.inputPolys;
        Intrinsics.checkNotNull(collection3);
        for (Object obj2 : collection3) {
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry item = (Geometry)obj2;
            index.insert(item.getEnvelopeInternal(), (Object)item);
        }
        this.inputPolys = null;
        List<?> list = index.itemsTree();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<org.locationtech.jts.geom.Geometry>");
        List itemTree = TypeIntrinsics.asMutableList(list);
        return this.unionTree(itemTree);
    }

    private final Geometry unionTree(List<? extends Geometry> geomTree) {
        List<Geometry> geoms = this.reduceToGeometries(geomTree);
        return CascadedPolygonUnion.binaryUnion$default(this, geoms, 0, 0, 6, null);
    }

    private final Geometry binaryUnion(List<Geometry> geoms, int start, int end) {
        Geometry geometry;
        if (end - start <= 1) {
            Geometry g0 = CascadedPolygonUnion.Companion.getGeometry(geoms, start);
            geometry = this.unionSafe(g0, null);
        } else if (end - start == 2) {
            geometry = this.unionSafe(CascadedPolygonUnion.Companion.getGeometry(geoms, start), CascadedPolygonUnion.Companion.getGeometry(geoms, start + 1));
        } else {
            int mid = (end + start) / 2;
            Geometry g0 = this.binaryUnion(geoms, start, mid);
            Geometry g1 = this.binaryUnion(geoms, mid, end);
            geometry = this.unionSafe(g0, g1);
        }
        return geometry;
    }

    static /* synthetic */ Geometry binaryUnion$default(CascadedPolygonUnion cascadedPolygonUnion, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return cascadedPolygonUnion.binaryUnion(list, n, n2);
    }

    private final List<Geometry> reduceToGeometries(List<? extends Geometry> geomTree) {
        List geoms = new ArrayList();
        Iterator<? extends Geometry> i = geomTree.iterator();
        while (i.hasNext()) {
            Geometry o;
            Intrinsics.checkNotNull((Object)i.next());
            Geometry geom = null;
            if (o instanceof List) {
                geom = this.unionTree((List)((Object)o));
            } else if (o instanceof Geometry) {
                geom = o;
            }
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            geoms.add(geometry);
        }
        return geoms;
    }

    private final Geometry unionSafe(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g0 == null) {
            Geometry geometry = g1;
            Intrinsics.checkNotNull((Object)geometry);
            return geometry.copy();
        }
        if (g1 == null) {
            return g0.copy();
        }
        int n = this.countRemainder;
        this.countRemainder = n + -1;
        Geometry union = this.unionActual(g0, g1);
        return union;
    }

    private final Geometry unionActual(Geometry g0, Geometry g1) {
        Geometry union = this.unionFun.union(g0, g1);
        return CascadedPolygonUnion.Companion.restrictToPolygons(union);
    }

    @JvmOverloads
    public CascadedPolygonUnion(@Nullable Collection<?> inputPolys) {
        this(inputPolys, null, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@Nullable Collection<?> polys) {
        return Companion.union(polys);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0007J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005J \u0010\u000f\u001a\u0004\u0018\u00010\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/union/CascadedPolygonUnion$Companion;", "", "<init>", "()V", "CLASSIC_UNION", "Lorg/locationtech/jts/operation/union/UnionStrategy;", "getCLASSIC_UNION", "()Lorg/locationtech/jts/operation/union/UnionStrategy;", "union", "Lorg/locationtech/jts/geom/Geometry;", "polys", "", "unionFun", "STRTREE_NODE_CAPACITY", "", "getGeometry", "list", "", "index", "restrictToPolygons", "g", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnionStrategy getCLASSIC_UNION() {
            return CLASSIC_UNION;
        }

        @JvmStatic
        @Nullable
        public final Geometry union(@Nullable Collection<?> polys) {
            CascadedPolygonUnion op = new CascadedPolygonUnion(polys, null, 2, null);
            return op.union();
        }

        @Nullable
        public final Geometry union(@Nullable Collection<?> polys, @NotNull UnionStrategy unionFun) {
            Intrinsics.checkNotNullParameter((Object)unionFun, (String)"unionFun");
            CascadedPolygonUnion op = new CascadedPolygonUnion(polys, unionFun);
            return op.union();
        }

        private final Geometry getGeometry(List<Geometry> list, int index) {
            return index >= list.size() ? null : list.get(index);
        }

        private final Geometry restrictToPolygons(Geometry g) {
            if (g instanceof Polygonal) {
                return g;
            }
            Geometry geometry = g;
            Intrinsics.checkNotNull((Object)geometry);
            List<Polygon> polygons = PolygonExtracter.Companion.getPolygons(geometry);
            return polygons.size() == 1 ? (Geometry)polygons.get(0) : (Geometry)g.getFactory().createMultiPolygon(GeometryFactory.Companion.toPolygonArray((Collection<? extends Geometry>)polygons));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

